/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui.card;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.qrcodeprovide.QRCodeGenerator;
import com.huawei.ism.tool.framework.pubservice.utils.qrcodeprovide.QRCodeInputParams;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.tool.upgradeevalu.util.EvaluSceneUtils;
import com.huawei.ism.ui.swing.dialog.HeadlessDialog;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import org.slf4j.Logger;

public class QRCodeImgDialog
extends HeadlessDialog {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(QRCodeImgDialog.class);
    private static final Dimension DIALOG_SIZE = new Dimension(310, 310);
    private static final int QRCIMG_SIZE = 300;
    private static final String QRCODE_IMAGE = "qrcImg.png";
    private static final String IMAGE_PNG = "\\.png";

    public QRCodeImgDialog(JDialog parent) {
        super((Window)parent);
        this.initUI();
    }

    private void initUI() {
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        JLabel offLineImage = this.getQRCodePic();
        JLabel suggestion = new JLabel(ResourceUtil.getString((String)"evalu.adddevice.closeqrcode.suggesstion"));
        suggestion.setForeground(Color.GRAY);
        JComponent comp = UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{suggestion}), UCD.buildHBoxCentert((Component[])new Component[]{offLineImage})});
        this.add(comp, "Center");
        UiMethod.setComponentSize((Dimension)DIALOG_SIZE, (Component[])new Component[]{this});
        this.toFront();
        SwingUtil.putScreenCenter((Window)((Object)this));
        this.setDefaultCloseOperation(2);
        this.addMouseListener(new MouseAction());
    }

    public JLabel getQRCodePic() {
        JLabel offLineImage = new JLabel();
        try {
            String tmpPath = EvaluContext.getInstance().getHome() + File.separator + "tmp" + File.separator + "com";
            File file = new File(tmpPath);
            if (!file.exists() && !file.mkdirs()) {
                LOGGER.error("mkdirs file " + tmpPath + " is error!");
                return offLineImage;
            }
            String url = ResourceUtil.getString((String)"upgrade.adviser.url");
            LOGGER.info(String.format(Locale.ENGLISH, "imagePath is: %s, imageName is: %s, url is: %s", tmpPath, QRCODE_IMAGE, url));
            String imgName = QRCODE_IMAGE.replaceAll(IMAGE_PNG, "");
            EvaluSceneUtils sceneUtilInformation = new EvaluSceneUtils();
            sceneUtilInformation.addRecordsDottingInformation("4", url);
            QRCodeInputParams qrParams = new QRCodeInputParams(url, tmpPath, imgName);
            qrParams.setHeight(300);
            qrParams.setWidth(300);
            QRCodeGenerator.getInstance().createQRCodePic(qrParams);
            offLineImage.setIcon(new ImageIcon(tmpPath + File.separator + QRCODE_IMAGE));
        }
        catch (ToolException e) {
            LOGGER.error("download notlineimage is error", e);
        }
        return offLineImage;
    }

    private void deleteComFile() {
        String tmpPath = EvaluContext.getInstance().getHome() + File.separator + "tmp" + File.separator + "com";
        try {
            File tmpFile = new File(tmpPath);
            if (!tmpFile.exists()) {
                LOGGER.error("Not exsit qrcCode file.");
                return;
            }
            FileUtils.deleteFile((File)tmpFile);
        }
        catch (Exception ex) {
            LOGGER.error("delete qrcCode file failed.", ex);
        }
    }

    private class MouseAction
    extends MouseAdapter {
        private MouseAction() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            QRCodeImgDialog.this.dispose();
            QRCodeImgDialog.this.deleteComFile();
        }
    }
}

