/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui.card;

import com.huawei.ism.tool.base.ui.wizard.FlowWizardCard;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.DeviceType;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluService;
import com.huawei.ism.tool.upgradeevalu.ui.card.SelectUpgradeComponentCardLayout;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.tool.upgradeevalu.util.QueryContainerVersion;
import com.huawei.ism.tool.upgradeevalu.util.SecondaryUpgradeUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JDialog;

public class SelectUpgradeComponentCard
extends FlowWizardCard {
    private List<EvaluDevNode> evaluDevList = null;
    private static final String CONTAINER = "_container";
    private EvaluContext evaluContext = EvaluContext.getInstance();
    private SelectUpgradeComponentCardLayout layout = new SelectUpgradeComponentCardLayout();
    private EvaluService evaluService = EvaluService.getInstance();

    protected FlowWizardCardLayout getLayout() {
        return this.layout;
    }

    protected boolean init() {
        this.evaluDevList = (List)this.getContext().getSingleObject("selectedDevs");
        this.layout = new SelectUpgradeComponentCardLayout();
        this.layout.getStorageRadioButton().setSelected(true);
        this.layout.getImageRadioButton().setEnabled(this.evaluDevList.stream().allMatch(SecondaryUpgradeUtils::isSupportSecondaryUpgrade));
        this.layout.getStorageImageRadioButton().setEnabled(this.evaluDevList.stream().allMatch(SecondaryUpgradeUtils::isSupportSecondaryUpgrade));
        return true;
    }

    public boolean ending() {
        if (this.layout.getStorageRadioButton().isSelected()) {
            this.evaluDevList.forEach(node -> this.setUpgradeComponentStrategy((EvaluDevNode)((Object)node), false, false));
            this.getContext().saveSingleObject("selectedDevs", this.evaluDevList);
            return true;
        }
        if (this.layout.getImageRadioButton().isSelected()) {
            this.evaluDevList.forEach(node -> this.setUpgradeComponentStrategy((EvaluDevNode)((Object)node), true, false));
            if (this.checkContainerService()) {
                return false;
            }
            this.getContext().saveSingleObject("selectedDevs", this.evaluDevList);
            return true;
        }
        if (this.layout.getStorageImageRadioButton().isSelected()) {
            this.evaluDevList.forEach(node -> this.setUpgradeComponentStrategy((EvaluDevNode)((Object)node), true, true));
            this.evaluDevList.forEach(this::clearContainerSuffix);
        }
        if (this.checkContainerService()) {
            return false;
        }
        this.evaluDevList.forEach(this::setProductMap);
        this.getContext().saveSingleObject("selectedDevs", this.evaluDevList);
        return true;
    }

    private void clearContainerSuffix(EvaluDevNode node) {
        node.setDeviceType(DeviceType.valueOf((String)node.getDeviceType().toString().replace(CONTAINER, "")));
    }

    private void setUpgradeComponentStrategy(EvaluDevNode node, boolean isSecondaryUpgrade, boolean isAllUpgrade) {
        node.setStorageImageUpgrade(isAllUpgrade);
        node.setSecondaryUpgrade(isSecondaryUpgrade);
    }

    private void setProductMap(EvaluDevNode dev) {
        this.clearContainerSuffix(dev);
        dev.setProducts(this.evaluService.queryProdcut(dev));
    }

    private void setA8000ProductMap(EvaluDevNode dev) {
        dev.setDeviceType(DeviceType.valueOf((String)(dev.getDeviceType().toString() + CONTAINER)));
        dev.setProducts(this.evaluService.queryProdcut(dev));
    }

    private boolean checkContainerService() {
        this.evaluDevList.forEach(this::setA8000ProductMap);
        List<EvaluDevNode> failedDevs = QueryContainerVersion.query(this.evaluDevList);
        if (!failedDevs.isEmpty()) {
            String failedIps = failedDevs.stream().map(DevNode::getIp).collect(Collectors.joining(","));
            DialogUtils.showInfoDialog((JDialog)this.evaluContext.getWizDialog(), (String)ResourceUtil.getStringWithParams((String)"secondaryupgrade.upgrade.container.version", (Object[])new Object[]{failedIps}));
            return true;
        }
        if (!this.checkContainerVersionConsistency()) {
            String ipAndVersion = this.evaluDevList.stream().map(evaluDevNode -> ResourceUtil.getStringWithParams((String)"secondaryupgrade.upgrade.container.version.ip.version", (Object[])new Object[]{evaluDevNode.getIp(), evaluDevNode.getContainerVersion()})).collect(Collectors.joining("\n"));
            DialogUtils.showInfoDialog((JDialog)this.evaluContext.getWizDialog(), (String)ResourceUtil.getStringWithParams((String)"secondaryupgrade.upgrade.container.version.Consistency", (Object[])new Object[]{ipAndVersion}));
            return true;
        }
        return false;
    }

    private boolean checkContainerVersionConsistency() {
        return this.evaluDevList.stream().map(EvaluDevNode::getContainerVersion).distinct().count() == 1L;
    }

    public boolean flowExiting() {
        return true;
    }
}

