/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui.component;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluItem;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluDevManager;
import com.huawei.ism.tool.upgradeevalu.evalu.ResultItem;
import com.huawei.ism.tool.upgradeevalu.ui.OnlineEvaluMainDialog;
import com.huawei.ism.tool.upgradeevalu.ui.component.ItemShowInfo;
import com.huawei.ism.tool.upgradeevalu.ui.component.ProgressPanel;
import com.huawei.ism.tool.upgradeevalu.util.EvaluConstants;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.tool.upgradeevalu.util.ItemProgressUpdateUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.UIManager;
import org.slf4j.Logger;

public class ItemsListCellRenderer
extends DefaultListCellRenderer {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ItemsListCellRenderer.class);
    private static final Dimension DATE_LABLE_SIZE = new Dimension(160, 20);
    private static final Dimension SCRIPT_LABEL_SIZE = new Dimension(600, 20);
    private static final Dimension ERROR_MESSAGE_SIZE = new Dimension(300, 20);
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String LIST_DROPCELLBACKGROUND = "List.dropCellBackground";
    private static final String SETFOREGROUND = "setForeground";
    private transient EvaluDevManager evaluDevMgr = EvaluDevManager.getInstance();

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JComponent view;
        Color bg = null;
        JList.DropLocation dropLocation = list.getDropLocation();
        if (null != dropLocation && !dropLocation.isInsert() && dropLocation.getIndex() == index) {
            bg = UIManager.getColor(LIST_DROPCELLBACKGROUND);
            isSelected = true;
        }
        ProgressPanel viewPan = new ProgressPanel();
        EvaluItem evaluItem = (EvaluItem)value;
        String topTipInfo = "";
        try {
            ItemShowInfo viewByItem = this.createViewByItem(evaluItem, viewPan);
            view = viewByItem.getShowComponent();
            topTipInfo = viewByItem.getTopTipInfo();
        }
        catch (Exception e) {
            LOGGER.error("add item to detailList error.", e);
            Date date = Calendar.getInstance().getTime();
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            String dateStr = format.format(date);
            JLabel dataLabel = new JLabel(dateStr);
            dataLabel.setPreferredSize(DATE_LABLE_SIZE);
            JLabel errorTipLabel = new JLabel(ResourceUtil.getString((String)"evalu.ui.component.detailListRenderer.error"));
            errorTipLabel.setPreferredSize(SCRIPT_LABEL_SIZE);
            JLabel errorMessageLabel = new JLabel(e.getMessage());
            errorMessageLabel.setPreferredSize(ERROR_MESSAGE_SIZE);
            view = UCD.buildHorizotalBox(null, (Component[])new Component[]{dataLabel, Box.createHorizontalStrut(12), errorTipLabel, Box.createHorizontalStrut(12), errorMessageLabel});
            topTipInfo = e.getMessage();
        }
        viewPan.setLayout(new BorderLayout());
        viewPan.add((Component)view, "North");
        viewPan.setComponentOrientation(list.getComponentOrientation());
        viewPan.setEnabled(list.isEnabled());
        viewPan.setFont(list.getFont());
        viewPan.setToolTipText(topTipInfo);
        if (isSelected) {
            viewPan.setBackground(null == bg ? list.getSelectionBackground() : bg);
            UiMethod.setBatchComponentProperty((String)SETFOREGROUND, (Object[])new Object[]{Color.WHITE}, (JComponent[])new JComponent[]{viewPan});
        } else {
            viewPan.setForeground(list.getForeground());
        }
        return viewPan;
    }

    private JComponent createCheckingView(EvaluItem evaluItem, ProgressPanel panel) {
        JComponent statusLabel = null;
        JLabel status = new JLabel(ResourceUtil.getString((String)"evalu.device.item.wait"));
        status.setIcon(EvaluConstants.WAITING_IMG);
        EvaluConstants.WAITING_IMG.setImageObserver((OnlineEvaluMainDialog)EvaluContext.getInstance().getUiObserver());
        int progress = ItemProgressUpdateUtil.INS.getProgress(evaluItem.getDevID());
        if (progress >= 0 && progress <= 100) {
            String timeLeft = ItemProgressUpdateUtil.INS.getTimeLeft(evaluItem.getDevID());
            statusLabel = StringUtils.isNULLStr((String)timeLeft) ? UCD.buildHorizotalBox(null, (Component[])new Component[]{new JLabel(ResourceUtil.getStringWithParams((String)"evalu.device.item.wait.progress", (Object[])new Object[]{progress})), Box.createHorizontalStrut(12), status}) : UCD.buildHorizotalBox(null, (Component[])new Component[]{new JLabel(ResourceUtil.getStringWithParams((String)"evalu.device.item.wait.progress", (Object[])new Object[]{progress})), Box.createHorizontalStrut(12), new JLabel(ResourceUtil.getStringWithParams((String)"evalu.device.item.wait.progress.timeleft", (Object[])new Object[]{timeLeft})), Box.createHorizontalStrut(12), status});
            panel.setShow(true);
            panel.setProgress(progress);
        } else {
            statusLabel = status;
        }
        return statusLabel;
    }

    private ItemShowInfo createViewByItem(EvaluItem evaluItem, ProgressPanel panel) throws ToolException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        EvaluDevNode dev = this.evaluDevMgr.getTabDevById(evaluItem.getDevID());
        if (dev == null) {
            throw new ToolException("getTabDevById faild = " + evaluItem.getDevID());
        }
        ResultItem retItem = evaluItem.getRetItem();
        JComponent statusLabel = null;
        statusLabel = this.setResultFlag(evaluItem, panel, retItem);
        JLabel nameLabel = null;
        if (evaluItem.isForgeItem()) {
            nameLabel = new JLabel(evaluItem.getName());
            if (dev.getExtraCheckItem().isAfterItem(evaluItem) && !evaluItem.getIdentifier().equals("forge.afterCheck")) {
                statusLabel = new JLabel("");
            }
        } else if ("innerCheck".equals(evaluItem.getItemType())) {
            nameLabel = new JLabel(evaluItem.getName());
        } else if (evaluItem.getCheckConfigItem() != null) {
            nameLabel = new JLabel(evaluItem.getCheckConfigItem().getName());
        } else {
            String key = evaluItem.getId() + ".name";
            nameLabel = new JLabel(evaluItem.getString(key));
        }
        nameLabel.setPreferredSize(SCRIPT_LABEL_SIZE);
        String finishTime = "";
        if (retItem.getFinishTime() != null) {
            finishTime = dateFormat.format(retItem.getFinishTime());
        }
        JLabel dataLabel = new JLabel(finishTime);
        dataLabel.setPreferredSize(DATE_LABLE_SIZE);
        JComponent dateComp = UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{Box.createHorizontalStrut(5), dataLabel});
        JComponent view = UCD.buildHorizotalBox(null, (Component[])new Component[]{dateComp, Box.createHorizontalStrut(12), nameLabel, Box.createHorizontalGlue(), UCD.buildHBoxRight((Component[])new Component[]{statusLabel, Box.createHorizontalStrut(12)})});
        return new ItemShowInfo(view, nameLabel.getText());
    }

    private JComponent setResultFlag(EvaluItem evaluItem, ProgressPanel panel, ResultItem retItem) {
        JComponent statusLabel;
        switch (retItem.getRetFlag()) {
            case WAITING: {
                try {
                    statusLabel = this.createCheckingView(evaluItem, panel);
                }
                catch (Exception e) {
                    LOGGER.error("build view component for item error", e);
                    statusLabel = new JLabel();
                }
                break;
            }
            case PASS: {
                statusLabel = new JLabel(ResourceUtil.getString((String)"evalu.ui.component.detailListRenderer.result.pass"));
                ((JLabel)statusLabel).setIcon(EvaluConstants.SUCCESS_IMG);
                break;
            }
            case NOTPASS: {
                statusLabel = new JLabel(ResourceUtil.getString((String)"evalu.ui.component.detailListRenderer.result.not.pass"));
                ((JLabel)statusLabel).setIcon(EvaluConstants.FAILED_IMG);
                break;
            }
            case NOSUPPORT: {
                statusLabel = new JLabel(ResourceUtil.getString((String)"evalu.ui.component.detailListRenderer.result.not.support"));
                ((JLabel)statusLabel).setIcon(EvaluConstants.NOSOUPPORT_IMG);
                break;
            }
            case WARN: {
                statusLabel = new JLabel(ResourceUtil.getString((String)"evalu.ui.component.detailListRenderer.result.warn"));
                ((JLabel)statusLabel).setIcon(EvaluConstants.WARING_IMG);
                break;
            }
            case NOCHECK: {
                statusLabel = new JLabel(ResourceUtil.getString((String)"evalu.ui.component.detailListRenderer.result.not.check"));
                ((JLabel)statusLabel).setIcon(EvaluConstants.NOCHECK_IMG);
                break;
            }
            case NOSTART: {
                statusLabel = new JLabel(ResourceUtil.getString((String)"evalu.ui.component.detailListRenderer.result.wait"));
                ((JLabel)statusLabel).setIcon(EvaluConstants.WAIT_EVALU_IMG);
                break;
            }
            default: {
                statusLabel = new JLabel("");
            }
        }
        return statusLabel;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
    }
}

