/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.ui.listenner;

import com.huawei.ism.tool.base.ui.wizard.FlowWizardDialog;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.framework.pubui.PublicUiManage;
import com.huawei.ism.tool.framework.pubui.common.IDeviceManageUI;
import com.huawei.ism.tool.framework.pubui.entity.DeviceManageSetting;
import com.huawei.ism.tool.upgradeevalu.entity.ProductCfg;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluService;
import com.huawei.ism.tool.upgradeevalu.ui.card.EvaluAddDevCard;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JDialog;
import org.slf4j.Logger;

public class EvaluAddDevListener
extends MouseAdapter
implements INodeSupport {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(EvaluAddDevListener.class);
    private EvaluAddDevCard card;
    private EvaluContext evaluContext = EvaluContext.getInstance();
    private EvaluService evaluService = EvaluService.getInstance();

    public EvaluAddDevListener(EvaluAddDevCard addDeviceCard) {
        this.card = addDeviceCard;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        IDeviceManageUI connUi = (IDeviceManageUI)PublicUiManage.getInstance().getUi(IDeviceManageUI.class);
        List<String> suppModels = this.evaluService.getSupportModels();
        FlowWizardDialog parent = this.evaluContext.getWizDialog();
        if (suppModels.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)parent, (String)ResourceUtil.getString((String)"eualu.ui.listener.addDev.not.product"));
            return;
        }
        DeviceManageSetting devMgrSeting = new DeviceManageSetting(false, true, false);
        this.initDeviceAddDialogData(devMgrSeting);
        boolean flag = connUi.showAddDeviceDialog((JDialog)parent, suppModels, (INodeSupport)this, devMgrSeting);
        if (!flag) {
            LOGGER.error("show add device dialog err.");
        }
    }

    private void initDeviceAddDialogData(DeviceManageSetting setting) {
        LinkedList<ItDeviceType> itDeviceList = new LinkedList<ItDeviceType>();
        HashMap deviceTypel2 = new HashMap();
        itDeviceList.add(ItDeviceType.Storage);
        itDeviceList.add(ItDeviceType.Host);
        LinkedList<String> hostdeviceTypeL2 = new LinkedList<String>();
        hostdeviceTypeL2.add("Linux");
        deviceTypel2.put(ItDeviceType.Host, hostdeviceTypeL2);
        setting.setItDeviceList(itDeviceList);
        setting.setDeviceTypel2(deviceTypel2);
    }

    public boolean isNodeSupport(DevNode dev) {
        ProductCfg prod = this.evaluService.matchProdcut(dev);
        return null != prod;
    }
}

