/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.util;

import com.google.common.base.Objects;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.former.service.IntelligentComputeSceneImpl;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.A800Node;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DmeNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class A800Utils {
    public static boolean isA800(String devType) {
        return Objects.equal(devType, "OceanStor A800");
    }

    public static boolean isA800(ItDeviceType devType) {
        return Objects.equal(devType, ItDeviceType.A800_NODE);
    }

    public static boolean isA800UpgradeCheck() {
        return SceneUtils.isA800UpgradeCheck();
    }

    public static boolean isA800Upgrade() {
        return SceneUtils.isA800Upgrade();
    }

    public static List<DevNode> getA800NodeFromEnv() {
        return DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).map(AiDevNode::getA800Nodes).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static List<com.huawei.ism.tool.framework.pubservice.entity.DevNode> getZones(com.huawei.ism.tool.framework.pubservice.entity.DevNode devNode) {
        Optional<A800Node> matchA800 = A800Utils.getA800NodeFromEnv().stream().filter(node -> node instanceof A800Node).map(A800Node.class::cast).filter(a800Node -> a800Node.getDeviceSerialNumber().equals(devNode.getDeviceSerialNumber())).findFirst();
        if (!matchA800.isPresent()) {
            return Collections.emptyList();
        }
        return matchA800.get().getZones().stream().map(EntityUtils::toNewDev).collect(Collectors.toList());
    }

    public static Optional<DmeNode> getZoneByDevNode(com.huawei.ism.tool.framework.pubservice.entity.DevNode devNode) {
        return A800Utils.getA800NodeFromEnv().stream().filter(node -> node instanceof A800Node).map(A800Node.class::cast).map(A800Node::getZones).flatMap(Collection::stream).filter(zone -> Objects.equal(zone.getDeviceSerialNumber(), devNode.getDeviceSerialNumber())).findFirst();
    }

    public static void saveAiDevNode2Box() {
        IntelligentComputeSceneImpl intelligentComputeScene = new IntelligentComputeSceneImpl();
        intelligentComputeScene.saveAiExtend();
    }

    public static Optional<AiDevNode> transToAiNode(DevNode requestZone) {
        return DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).filter(aiDevNode -> A800Utils.isZoneMatch(requestZone, aiDevNode)).findFirst();
    }

    private static boolean isZoneMatch(DevNode requestZone, AiDevNode aiDevNode) {
        return aiDevNode.getA800Nodes().stream().map(A800Node::getZones).flatMap(Collection::stream).anyMatch(zone -> Objects.equal(requestZone.getDeviceSerialNumber(), zone.getDeviceSerialNumber()));
    }

    private A800Utils() {
    }
}

