/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.util;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalUtils;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseLinkUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaseLinkUtils.class);

    public static String getSuggest(EvalFeatureResult result, String suggest, String path) {
        if (ItemResultEnum.NOTPASS.equals((Object)result.getItemResult()) || ItemResultEnum.CANNOTEVAL.equals((Object)result.getItemResult())) {
            if (suggest.contains(ResourceUtil.getString((String)"evalu.case"))) {
                String troubleKey = null;
                String devType = result.getDevType().toLowerCase(Locale.ENGLISH);
                if ("multiPathStatus".equals(result.getFeatureId())) {
                    troubleKey = CaseLinkUtils.isHpV1V2(result) ? "multipath.hpv1v2" : CaseLinkUtils.getTroubleshootMultipath(devType);
                } else if ("hostHbaTimeOut".equals(result.getFeatureId())) {
                    troubleKey = CaseLinkUtils.getTroubleshootHbaTimeOut(devType);
                } else if ("oracleTimeOut".equals(result.getFeatureId())) {
                    if (!result.getCaseKeyList().isEmpty()) {
                        suggest = CaseLinkUtils.replaceCaseList(result, suggest, path);
                        return suggest;
                    }
                    troubleKey = result.getFeatureId();
                } else if ("virtualFeature".equals(result.getFeatureId()) || "WindowsServer2008BuleScreen".equals(result.getFeatureId())) {
                    troubleKey = result.getFeatureId();
                } else if ("IscsiTimeoutCheck".equals(result.getFeatureId())) {
                    troubleKey = result.getFeatureId() + "." + devType;
                } else {
                    LOGGER.info("There is no relevant case document.");
                }
                suggest = CaseLinkUtils.insertCaseConnection(suggest, troubleKey, path);
            }
            suggest = CaseLinkUtils.replaceCaseList(result, suggest, path);
        }
        return suggest;
    }

    public static String replaceCaseList(EvalFeatureResult result, String suggest, String path) {
        if (suggest.matches("[\\s\\S]*\\[\\d+\\][\\s\\S]*")) {
            List<String> caseList = result.getCaseKeyList();
            if (caseList == null || caseList.isEmpty()) {
                LOGGER.warn("suggest map in wrong content...................!!");
                return suggest;
            }
            int idx = 0;
            for (String caseKey : caseList) {
                caseKey = "troubleshooting." + caseKey;
                String configKey = ResourceUtil.getString((String)caseKey);
                Map<String, String> keyInfoMap = HostEvalUtils.getHelpKeys(configKey);
                String[] keys = keyInfoMap.keySet().toArray(new String[keyInfoMap.size()]);
                String placeHolder = '[' + String.valueOf(idx) + ']';
                suggest = HostEvalUtils.replaceKeys(suggest, path, keyInfoMap.get(keys[0]), placeHolder, keys[0]);
                ++idx;
            }
        }
        return suggest;
    }

    private static boolean isHpV1V2(EvalFeatureResult result) {
        String devType = result.getDevType().toLowerCase(Locale.ENGLISH);
        String osName = result.getOsName();
        if (!"hp-ux".equals(devType)) {
            return false;
        }
        if (StringUtils.isNULLStr((String)osName)) {
            return false;
        }
        return osName.trim().equalsIgnoreCase("HP-UX 11i v1") || osName.trim().equalsIgnoreCase("HP-UX 11i v2");
    }

    private static String insertCaseConnection(String suggest, String troubleKey, String path) {
        if (org.apache.commons.lang3.StringUtils.isEmpty(troubleKey)) {
            LOGGER.info("Not matched to the case document.");
            return suggest;
        }
        String troubleshootKey = ResourceUtil.getString((String)("troubleshooting." + troubleKey));
        Map<String, String> helpKeyMap = HostEvalUtils.getHelpKeys(troubleshootKey);
        suggest = HostEvalUtils.replaceKeysByMap(suggest, path, helpKeyMap);
        return suggest;
    }

    private static String getTroubleshootMultipath(String devType) {
        String multiPath;
        switch (devType) {
            case "linux": {
                multiPath = "multipath.linux";
                break;
            }
            case "aix": {
                multiPath = "multipath.aix";
                break;
            }
            case "hp-ux": {
                multiPath = "multipath.hp";
                break;
            }
            case "vmware": {
                multiPath = "multipath.esxi";
                break;
            }
            case "solaris": {
                multiPath = "multipath.solaris";
                break;
            }
            case "fusionsphere": {
                multiPath = "multipath.linux";
                break;
            }
            case "windows": {
                multiPath = "multipath.windows";
                break;
            }
            default: {
                multiPath = "";
            }
        }
        return multiPath;
    }

    private static String getTroubleshootHbaTimeOut(String devType) {
        String hbaTimeOutPath;
        switch (devType) {
            case "linux": {
                hbaTimeOutPath = "hostHbaTimeOut.linux";
                break;
            }
            case "aix": {
                hbaTimeOutPath = "hostHbaTimeOut.aix";
                break;
            }
            case "hp-ux": {
                hbaTimeOutPath = "hostHbaTimeOut.hp";
                break;
            }
            case "vmware": {
                hbaTimeOutPath = "hostHbaTimeOut.vmware";
                break;
            }
            case "solaris": {
                hbaTimeOutPath = "hostHbaTimeOut.solaris";
                break;
            }
            case "fusionsphere": {
                hbaTimeOutPath = "hostHbaTimeOut.FusionSphere";
                break;
            }
            case "windows": {
                hbaTimeOutPath = "hostHbaTimeOut.Windows";
                break;
            }
            default: {
                hbaTimeOutPath = "";
            }
        }
        return hbaTimeOutPath;
    }
}

