/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.util;

import com.huawei.ism.tool.obase.entity.DevMap;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import java.util.List;
import java.util.Map;

public class EnvHelper {
    public static Map<String, String> getDevMapForRest(EvaluDevNode dev) {
        DevMap devMapDict = new DevMap();
        devMapDict.put("sn", dev.getDeviceSerialNumber());
        devMapDict.put("type", dev.getDeviceType().toString());
        devMapDict.put("version", dev.getProductVersion());
        devMapDict.put("name", dev.getDeviceName());
        devMapDict.put("ip", dev.getIp());
        devMapDict.put("sshPort", String.valueOf(dev.getPort()));
        devMapDict.put("tlvPort", "0");
        devMapDict.put("devInnerIpList", EnvHelper.buildIpListStr(dev.getIpList()));
        devMapDict.put("user", dev.getLoginUser().getUserName());
        devMapDict.put("pawd", dev.getLoginUser().getPassword());
        devMapDict.put("devPassword", dev.getDeveloperPwd());
        return devMapDict;
    }

    private static String buildIpListStr(List<String> ipList) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < ipList.size(); ++i) {
            String ip = ipList.get(i);
            if (StringUtils.isNULLStr((String)ip)) continue;
            builder.append(ip);
            if (i >= ipList.size() - 1) continue;
            builder.append(',');
        }
        return builder.toString();
    }
}

