/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.util;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EvalTimePropertiesUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(EvalTimePropertiesUtil.class);
    private static final String FILENAMEPRO = "sceneEval.properties";
    private String evalEndTimeKey = "lastEvalTime";
    private String filePath = ApplicationContext.getInstance().getConfigurationPath() + File.separator + "sceneEval.properties";
    private static EvalTimePropertiesUtil instance = null;

    private EvalTimePropertiesUtil() {
    }

    public String getEvalEndTimeKey() {
        return this.evalEndTimeKey;
    }

    public static EvalTimePropertiesUtil getInstance() {
        if (null == instance) {
            instance = new EvalTimePropertiesUtil();
        }
        return instance;
    }

    public String readBeforeEvalTime() {
        return this.readProperty(this.evalEndTimeKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readProperty(String key) {
        String value = "";
        FileInputStream is = null;
        try {
            File file = new File(this.filePath);
            is = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(is);
            value = properties.getProperty(key);
            StreamUtils.closeStream(null, (InputStream)is);
        }
        catch (IOException e) {
            LOGGER.error("readProperty is io error", e);
        }
        finally {
            StreamUtils.closeStream(null, is);
        }
        if (null == value) {
            return "";
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeProperty(String key, String value) {
        FileInputStream is = null;
        FileOutputStream os = null;
        Properties properties = new Properties();
        try {
            File file = new File(this.filePath);
            if (!file.exists() && !file.createNewFile()) {
                LOGGER.info("create evae time config time failed.");
            }
            is = new FileInputStream(file);
            properties.load(is);
            os = new FileOutputStream(file);
            properties.setProperty(key, value);
            properties.store(os, key);
            os.flush();
            StreamUtils.closeStream((OutputStream)os, (InputStream)is);
        }
        catch (IOException e) {
            LOGGER.error("writeProperty is io error", e);
        }
        finally {
            StreamUtils.closeStream(os, is);
        }
    }
}

