/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.util;

import com.google.common.base.Objects;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.entity.UpgradeMode;
import com.huawei.ism.tool.upgradeevalu.util.A800Utils;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.tool.upgradeevalu.util.SecondaryUpgradeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import utils.Products;

public class EvaluCommUtil {
    private static EvaluContext evaluContext = EvaluContext.getInstance();
    private static final String A8000 = "OceanProtect A8000";

    private static String getVRCVersion(String version) {
        Pattern pattern = Pattern.compile("(V.{3}R.{3}C.{2}|\\d+\\.\\d+)");
        Matcher matcher = pattern.matcher(version);
        String vrcVer = "--";
        if (matcher.find()) {
            vrcVer = matcher.group();
        }
        return vrcVer;
    }

    public static String getContainerScene(EvaluDevNode evaluDevNode) {
        if (evaluDevNode.isStorageImageUpgrade() && evaluDevNode.getContainerUpgradeMode() == UpgradeMode.PATCH_CONTAINER) {
            return UpgradeMode.PATCH_CONTAINER.toString();
        }
        if (evaluDevNode.getUpgradeMode() == UpgradeMode.PATCH_CONTAINER) {
            return UpgradeMode.PATCH_CONTAINER.toString();
        }
        return UpgradeMode.OFFLINE_CONTAINER.toString();
    }

    public static String getUpgradeScene(EvaluDevNode evaluDevNode) {
        String devVer = evaluDevNode.getProductVersion();
        if (evaluDevNode.isSecondaryUpgrade() && !evaluDevNode.isStorageImageUpgrade()) {
            if (evaluDevNode.getUpgradeMode() == UpgradeMode.PATCH_CONTAINER) {
                return UpgradeMode.PATCH_CONTAINER.toString();
            }
            return UpgradeMode.OFFLINE_CONTAINER.toString();
        }
        if (!Products.Feature.isSupportRollUpgrade((String)devVer)) {
            return UpgradeMode.ONLINE.toString();
        }
        if (evaluDevNode.isSupportFast()) {
            return UpgradeMode.FAST.toString();
        }
        return UpgradeMode.ROLL.toString();
    }

    public static String getActualMode(String mode) {
        if (mode.equalsIgnoreCase(UpgradeMode.ROLL.name())) {
            return UpgradeMode.ONLINE.name();
        }
        if (mode.equalsIgnoreCase(UpgradeMode.PARALLEL.name())) {
            return UpgradeMode.OFFLINE.name();
        }
        return mode;
    }

    public static int compareVersion(String version1, String version2) {
        if (!version1.matches("\\d+\\.\\d+.*") || !version2.matches("\\d+\\.\\d+.*")) {
            return version1.compareToIgnoreCase(version2);
        }
        String[] specialKeys = new String[]{"RC", "T", "SPC", "SPH"};
        for (int index = 0; index < specialKeys.length; ++index) {
            String tmpKey = specialKeys[index];
            if (!version1.contains(tmpKey) || !version2.contains(tmpKey)) continue;
            version1 = version1.replace(tmpKey, "");
            version2 = version2.replace(tmpKey, "");
        }
        String[] sectors1 = version1.split("\\.");
        String[] sectors2 = version2.split("\\.");
        for (int i = 0; i < Math.min(sectors1.length, sectors2.length); ++i) {
            Integer tmp2;
            Integer tmp1 = StringUtils.isNumeric(sectors1[i]) ? Integer.valueOf(Integer.parseInt(sectors1[i])) : null;
            Integer n = tmp2 = StringUtils.isNumeric(sectors2[i]) ? Integer.valueOf(Integer.parseInt(sectors2[i])) : null;
            if (tmp1 == null && tmp2 == null) {
                return sectors1[i].compareToIgnoreCase(sectors2[i]);
            }
            if (tmp1 != null && tmp2 != null) {
                if (tmp1 == tmp2) continue;
                return tmp1 > tmp2 ? 1 : -1;
            }
            return EvaluCommUtil.compareMix(sectors1[i], sectors2[i]);
        }
        return version1.compareToIgnoreCase(version2);
    }

    private static int compareMix(String version1, String version2) {
        if (version1.contains("RC")) {
            return -1;
        }
        if (version2.contains("RC")) {
            return 1;
        }
        if (version1.contains("T") || version2.contains("T")) {
            return -1;
        }
        return version1.compareToIgnoreCase(version2);
    }

    public static List<UpgradeMode> getSupportModeList(EvaluDevNode dev, String destVersion) {
        ArrayList<UpgradeMode> supportModeList = new ArrayList<UpgradeMode>();
        String destVRCVersion = EvaluCommUtil.getVRCVersion(destVersion);
        String currentDevType = dev.getDeviceType().toString();
        String currVRCVersion = EvaluCommUtil.getCurrVRCVerison(dev, currentDevType);
        List<EvaluContext.VersionPathItem> versionEvalPathList = evaluContext.getVersionEvalPathList();
        for (EvaluContext.VersionPathItem versionItem : versionEvalPathList) {
            String[] upgradeModeStrList;
            if (!versionItem.getDestVersion().contains(destVRCVersion) || !versionItem.getDeviceVersion().contains(currVRCVersion)) continue;
            if (versionItem.getUpgradeMode().equalsIgnoreCase("ALL")) {
                return EvaluCommUtil.getSupportModeListByAll(dev, supportModeList, currentDevType);
            }
            for (String upgradeModeStr : upgradeModeStrList = versionItem.getUpgradeMode().split(",")) {
                UpgradeMode mode = UpgradeMode.valueOf(UpgradeMode.class, upgradeModeStr.trim().toUpperCase(Locale.ENGLISH));
                supportModeList.add(mode);
            }
            return supportModeList;
        }
        return supportModeList;
    }

    private static String getCurrVRCVerison(EvaluDevNode dev, String currentDevType) {
        if (currentDevType.contains("_container")) {
            return EvaluCommUtil.getVRCVersion(dev.getContainerVersion());
        }
        return EvaluCommUtil.getVRCVersion(dev.getProductVersion());
    }

    @NotNull
    private static List<UpgradeMode> getSupportModeListByAll(EvaluDevNode dev, List<UpgradeMode> supportModeList, String currentDevType) {
        supportModeList.add(UpgradeMode.ONLINE);
        supportModeList.add(UpgradeMode.OFFLINE);
        supportModeList.add(UpgradeMode.FAST);
        supportModeList.add(UpgradeMode.APOLLO);
        if (currentDevType.contains(A8000) || SecondaryUpgradeUtils.isSupportSecondaryUpgrade(dev)) {
            supportModeList.add(UpgradeMode.OFFLINE_CONTAINER);
            supportModeList.add(UpgradeMode.PATCH_CONTAINER);
        }
        return supportModeList;
    }

    public static boolean isStorageOrA800(ItDeviceType itDeviceType) {
        return Objects.equal(ItDeviceType.Storage, itDeviceType) || A800Utils.isA800(itDeviceType);
    }
}

