/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.util;

import com.huawei.ism.tool.base.ui.wizard.FlowWizardDialog;
import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.common.data.ToolUserRole;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.tool.framework.platform.context.AbstractContext;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.scenedata.ScenePrepareProxyResponse;
import com.huawei.ism.tool.obase.utils.parser.FeatureSupportConfig;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluItem;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluMode;
import com.huawei.ism.tool.upgradeevalu.entity.ProductCfg;
import com.huawei.ism.tool.upgradeevalu.entity.UpgEvaUserOpData;
import com.huawei.ism.tool.upgradeevalu.evalu.ResultFlag;
import com.huawei.ism.tool.upgradeevalu.ui.IUiObserver;
import com.huawei.ism.tool.upgradeevalu.ui.OnlineEvaluMainDialog;
import com.huawei.ism.tool.upgradeevalu.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JDialog;

public final class EvaluContext
extends AbstractContext {
    public static final String LOG_RECORED_FAIL_DES = "Log records failed.";
    private static final EvaluContext INSTANCE = new EvaluContext();
    private String home = ApplicationContext.getInstance().getWorkPath();
    private List<ProductCfg> allProductCfg = new ArrayList<ProductCfg>();
    private JDialog mainDialog;
    private IUiObserver uiObserver;
    private FlowWizardDialog wizDialog;
    private File tmpDir;
    private File reportHome = FileUtil.getDefaultDirectory();
    private File reportDir = new File(this.reportHome, "report");
    private File htmlDir = new File(this.reportHome, "report" + File.separator + "html");
    private EvaluMode evaluMode = EvaluMode.LINK;
    private boolean isExistPkg = true;
    private boolean runEvaluing = false;
    private Map<String, List<String>> supportVersionMap = new HashMap<String, List<String>>();
    private List<FeatureSupportConfig> featureSupports = new ArrayList<FeatureSupportConfig>();
    private ImageIcon processingImage = ResourceUtil.getImage((String)"loading1.png");
    private volatile boolean endEvalu = false;
    private List<String> needOpenVersions = new ArrayList<String>();
    private Map<EvaluDevNode, UpgEvaUserOpData> userOpData = new HashMap<EvaluDevNode, UpgEvaUserOpData>();
    private List<UpgEvaUserOpData> useropList = new LinkedList<UpgEvaUserOpData>();
    private boolean isClickUpgTips = false;
    private Map<EvaluDevNode, Boolean> isClickUpgTipsMap = new HashMap<EvaluDevNode, Boolean>();
    private ToolUserRole runRole;
    private List<VersionPathItem> versionEvalPathList = new ArrayList<VersionPathItem>();
    private Map<String, String> zoneDataMap = new HashMap<String, String>();
    private String svpIp = "";
    private boolean isResetIP = false;
    private static volatile Date startTime = null;
    private static Date endTime = null;
    private static boolean autoAddDevice = false;
    private static boolean disableModifySetting = false;
    private ScenePrepareProxyResponse proxyResponse = null;

    private EvaluContext() {
    }

    public ImageIcon getProcessingImage() {
        return this.processingImage;
    }

    public void setProcessingImage(ImageIcon processingImage) {
        this.processingImage = processingImage;
    }

    public EvaluMode getEvaluMode() {
        return this.evaluMode;
    }

    public void setEvaluMode(EvaluMode evaluMode) {
        this.evaluMode = evaluMode;
    }

    public static EvaluContext getInstance() {
        return INSTANCE;
    }

    public List<ProductCfg> getAllProductCfg() {
        return this.allProductCfg;
    }

    public void setAllProductCfg(List<ProductCfg> allProductCfg) {
        this.allProductCfg = allProductCfg;
    }

    public IUiObserver getUiObserver() {
        return this.uiObserver;
    }

    public void setUiObserver(IUiObserver observer) {
        this.uiObserver = observer;
    }

    public FlowWizardDialog getWizDialog() {
        return this.wizDialog;
    }

    public void setWizDialog(FlowWizardDialog wizDialog) {
        this.wizDialog = wizDialog;
    }

    public Locale getLoc() {
        return LanguageManager.getInstance().getCurrentLanguage();
    }

    public File getReportDir() {
        return this.reportDir;
    }

    public void setReportDir(File reportDir) {
        this.reportDir = reportDir;
    }

    public File getTmpDir() {
        return this.tmpDir;
    }

    public void setTmpDir(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    public boolean isExistsPkg() {
        return this.isExistPkg;
    }

    public void setExistsPkg(boolean isExistsPkg) {
        this.isExistPkg = isExistsPkg;
    }

    public String getHome() {
        return this.home;
    }

    public boolean isRunEvaluing() {
        return this.runEvaluing;
    }

    public void setRunEvaluing(boolean runEvaluing) {
        this.runEvaluing = runEvaluing;
    }

    public Map<String, List<String>> getSupportVersionMap() {
        return this.supportVersionMap;
    }

    public void setSupportVersionMap(Map<String, List<String>> supportVersionMap) {
        this.supportVersionMap = supportVersionMap;
    }

    public File getHtmlDir() {
        return this.htmlDir;
    }

    public void setHtmlDir(File htmlDir) {
        this.htmlDir = htmlDir;
    }

    public boolean isEndEvalu() {
        return this.endEvalu;
    }

    public void setEndEvalu(boolean endEvalu) {
        this.endEvalu = endEvalu;
    }

    public List<String> getNeedOpenVersions() {
        return this.needOpenVersions;
    }

    public void setNeedOpenVersions(List<String> needOpenVersions) {
        this.needOpenVersions = needOpenVersions;
    }

    public Map<EvaluDevNode, UpgEvaUserOpData> getUserOpData() {
        return this.userOpData;
    }

    public void setUserOpData(Map<EvaluDevNode, UpgEvaUserOpData> userOpData) {
        this.userOpData = userOpData;
    }

    public boolean setUserOpTaskOverTimeInfo(long sTime, EvaluDevNode dev, EvaluItem item) {
        long eTime = DateUtil.toBeiJingTimeMillis((Date)new Date());
        if (null == dev) {
            return false;
        }
        return this.getUserOpData().get((Object)dev).appendOverTimesItems(sTime, eTime, item);
    }

    public void setUserOpTaskInfo(EvaluDevNode dev) {
        if (null == dev) {
            return;
        }
        UpgEvaUserOpData userop = this.getUserOpData().get((Object)dev);
        String logStr = "Set dev: " + dev.getIp() + " userOpTaskInfo: ";
        userop.setTaskStartTime(null == dev.getStartTime() ? 0L : dev.getStartTime().getTimeInMillis());
        userop.setTaskEndTime(null == dev.getEndTime() ? System.currentTimeMillis() : dev.getEndTime().getTimeInMillis());
        switch (dev.getEvaluState()) {
            case SUCCESS: {
                userop.setTaskResult(UserOpTaskResult.SUCCESS);
                break;
            }
            case FAILURE: {
                userop.setTaskResult(UserOpTaskResult.FAILED);
                break;
            }
            case RUN: {
                userop.setTaskResult(UserOpTaskResult.IN_COMPLETE);
                break;
            }
        }
        logStr = logStr + "[isClickUpgTips: " + (Object)((Object)userop.getIsClickUpgTips()) + "],[taskStartTime: " + userop.getTaskStartTime() + "],[taskEndTime: " + userop.getTaskEndTime() + "],[taskResult: " + userop.getTaskResult().toString() + "],";
        this.updateUiAgain(dev);
        this.setWarmAndNotPassItem(dev, userop);
        logStr = logStr + "[failed items: " + userop.getFailedNum() + ":" + userop.getFailedItems() + "],[alarm items: " + userop.getAlarmNum() + ":" + userop.getAlarmItems() + "],[overtime items: " + userop.getOverTimesNum() + ":" + userop.getOverTimesItems() + "]";
        try {
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).info(logStr);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(LOG_RECORED_FAIL_DES, e);
        }
        this.addUserOpInfoToList(userop);
        try {
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Add userOpInfo of dev: " + dev.getIp() + " to cache list success");
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(LOG_RECORED_FAIL_DES, e);
        }
        dev.setEvaluFinish(true);
    }

    private void setWarmAndNotPassItem(EvaluDevNode dev, UpgEvaUserOpData userop) {
        List<EvaluItem> items = dev.getAllEvaluItem();
        for (EvaluItem item : items) {
            if (null == item.getRetItem()) continue;
            if (item.getRetItem().getRetFlag() == ResultFlag.NOTPASS) {
                userop.appendFailedItems(item);
            }
            if (item.getRetItem().getRetFlag() != ResultFlag.WARN) continue;
            userop.appendAlarmItems(item);
        }
    }

    public void updateUiAgain(EvaluDevNode dev) {
        if (this.uiObserver != null && this.uiObserver instanceof OnlineEvaluMainDialog) {
            this.uiObserver.updateDevTableRow(dev);
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("uiObserver.updateDevTableRow(dev) updated");
        }
    }

    public void addUserOpInfoToList(UpgEvaUserOpData userop) {
        this.useropList.add(userop);
    }

    public List<UpgEvaUserOpData> getUseropList() {
        return this.useropList;
    }

    public boolean isClickUpgTipsBoolean() {
        return this.isClickUpgTips;
    }

    public void setIsClickUpgTips(boolean isClickUpgTips) {
        this.isClickUpgTips = isClickUpgTips;
    }

    public void putIsClickUpgTipsOfDevToMap(EvaluDevNode dev, boolean isClicked) {
        this.isClickUpgTipsMap.put(dev, isClicked);
    }

    public Map<EvaluDevNode, Boolean> getIsClickUpgTipsMap() {
        return this.isClickUpgTipsMap;
    }

    public ToolUserRole getRunRole() {
        return this.runRole;
    }

    public void setRunRole(ToolUserRole runRole) {
        this.runRole = runRole;
    }

    public boolean isCustomerRole() {
        return this.runRole.equals((Object)ToolUserRole.CUSTOMER);
    }

    public boolean isGuestRole() {
        return this.runRole.equals((Object)ToolUserRole.GUEST);
    }

    public List<VersionPathItem> getVersionEvalPathList() {
        return this.versionEvalPathList;
    }

    public void setVersionEvalPathList(List<VersionPathItem> versionEvalPathList) {
        this.versionEvalPathList = versionEvalPathList;
    }

    public String getSvpIp() {
        return this.svpIp;
    }

    public void setSvpIp(String svpIp) {
        this.svpIp = svpIp;
    }

    public boolean isResetIP() {
        return this.isResetIP;
    }

    public void setResetIP(boolean setIp) {
        this.isResetIP = setIp;
    }

    public static Date getStartTime() {
        if (null != startTime) {
            return (Date)startTime.clone();
        }
        return null;
    }

    public static void setStartTime(Date startTime) {
        if (EvaluContext.startTime == null) {
            EvaluContext.startTime = (Date)startTime.clone();
        }
        endTime = null;
    }

    public static Date getEndTime() {
        if (null != endTime) {
            return (Date)endTime.clone();
        }
        return null;
    }

    public static void setEndTime(Date endTime) {
        EvaluContext.endTime = (Date)endTime.clone();
    }

    public static boolean isAutoAddDevice() {
        return autoAddDevice;
    }

    public static void setAutoAddDevice(boolean autoAddDevice) {
        EvaluContext.autoAddDevice = autoAddDevice;
    }

    public static boolean isDisableModifySetting() {
        return disableModifySetting;
    }

    public static void setDisableModifySetting(boolean disableModifySetting) {
        EvaluContext.disableModifySetting = disableModifySetting;
    }

    public JDialog getMainDialog() {
        return this.mainDialog;
    }

    public void setMainDialog(JDialog mainDialog) {
        this.mainDialog = mainDialog;
    }

    public ScenePrepareProxyResponse getProxyResponse() {
        return this.proxyResponse;
    }

    public void setProxyResponse(ScenePrepareProxyResponse proxyResponse) {
        this.proxyResponse = proxyResponse;
    }

    public List<FeatureSupportConfig> getFeatureSupports() {
        return this.featureSupports;
    }

    public void setFeatureSupports(List<FeatureSupportConfig> featureSupports) {
        this.featureSupports = featureSupports;
    }

    public Map<String, String> getZoneDataMap() {
        return this.zoneDataMap;
    }

    public void setZoneDataMap(Map<String, String> zoneDataMap) {
        this.zoneDataMap = zoneDataMap;
    }

    public static class VersionPathItem {
        private String device;
        private String deviceVersion;
        private String destVersion;
        private String upgradeMode;
        private ItDeviceType deviceType;

        public String getDevice() {
            return this.device;
        }

        public void setDevice(String device) {
            this.device = device;
        }

        public String getDeviceVersion() {
            return this.deviceVersion;
        }

        public void setDeviceVersion(String deviceVersion) {
            this.deviceVersion = deviceVersion;
        }

        public String getDestVersion() {
            return this.destVersion;
        }

        public void setDestVersion(String destVersion) {
            this.destVersion = destVersion;
        }

        public String getUpgradeMode() {
            return this.upgradeMode;
        }

        public void setUpgradeMode(String upgradeMode) {
            this.upgradeMode = upgradeMode;
        }

        public ItDeviceType getDeviceType() {
            return this.deviceType;
        }

        public void setDeviceType(ItDeviceType deviceType) {
            this.deviceType = deviceType;
        }
    }
}

