/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.util;

import com.google.common.base.Objects;
import com.huawei.ism.tool.base.scene.utils.SceneDataExchange;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.runtime.SystemProperties;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.ISceneBean;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.ISceneEnvironment;
import com.huawei.ism.tool.framework.pubservice.entity.ScenePathValue;
import com.huawei.ism.tool.framework.pubservice.entity.SceneValue;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneDataConstant;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.ism.tool.framework.pubservice.utils.DateFormatUtil;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.entity.UpgradeMode;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluDevManager;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluState;
import com.huawei.ism.tool.upgradeevalu.evalu.ResultFlag;
import com.huawei.ism.tool.upgradeevalu.model.EvalTaskResult;
import com.huawei.ism.tool.upgradeevalu.report.CompatibilityResourceUtils;
import com.huawei.ism.tool.upgradeevalu.util.A800Utils;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalContext;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import utils.Products;

public class EvaluSceneUtils {
    private static final String SRC = "_src";
    private static final String DEST = "_dest";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(EvaluSceneUtils.class);
    private static final String JSON_SCENERESULT_PATH = "jsonSceneResultPath";
    private static final String SCENE_TOOL_ID = "upgradeEvaluation";
    private static final String UPGRADE_SETTING_TOOL_ID = "SceneSetting";
    public static final String SCENE_TOOL_HOST_ID = "CompatibilityAnalysis";
    public static final String SCENE_TOOL_SETTING_ID = "setting";
    private static final String JSON_SCENERESULT_ARGS_ID = "jsonSceneArgsList";
    private static final String SCENE_SN = "SN";
    private static final String SCENE_IP = "IP";
    private static final String EMPTY_DATA = "";
    private static final String SCENE_DEV_STATUS = "status";
    private static final String SCENE_DEV_TOOLID = "toolId";
    private static final String NODE_DISABLE_STEP_LIST = "disabledStepList";
    private static final String NODE_DISPLAY_STEP_LIST = "displayStepList";
    private static final String SCENE_RESULT_SUCCESS = "SUCCESS";
    private static final String SCENE_RESULT_FAILED = "FAILED";
    private static final String CHM_CLICK_EVENT = "chm_click_event";
    private static final String SCENE_SUB_SCENE_UPGRADE_NAME = "Upgrade";
    private static final String SCENE_XML_DEVICE_NAME = "package";
    private static final String SCENE_SUB_SCENE_UPGRADE_CHECK = "Upgrade Check";
    private static final String SCENE_A800_UPGRADE_CHECK = "IntelligentCompute_A800_upgrade_eval";
    private static final String TOOLSFOLDER = "tools";
    private static final int SNS_LIST_MAX_LENTH = 3;
    private static Boolean hostComAnaScene = null;
    public static final int STAUTS = 3;
    private static JSONArray dottingInformationJsonArray = new JSONArray();
    private static final String HOSTEVALUATION_STEP = "hostEvaluation";
    public static final String HOST_INFO_FILE = "hostInfo4PreUpgradeCheck.csv";
    private static final List<UpgradeMode> CONTAINER_UPGRADE_MODE = new ArrayList<UpgradeMode>(Arrays.asList(UpgradeMode.PATCH_CONTAINER, UpgradeMode.OFFLINE_CONTAINER));
    private static final String HOST_INFO_TABLE = "Host Name,Host IP,Initiator Name,Storage Device Name,Storage Device SN,Storage Device IP";
    private File sceneHostPath = null;
    private static final String NODE_DISABLE_STEP_DESC = "disableDesc";
    private Map<String, String> disableDescMap = new HashMap<String, String>();
    private static final String EXECUTE_TYPE = "executeType";
    private static final String EXECUTE_TYPE_PARTIAL = "0";
    public static boolean isHyperMetro = false;
    public static final String KUNPENG = "Kunpeng";

    public File getSceneHostPath() {
        return this.sceneHostPath;
    }

    public void setSceneHostPath(File sceneHostPath) {
        this.sceneHostPath = sceneHostPath;
    }

    public boolean isScene() {
        return SceneUtils.isScene();
    }

    public static boolean isContainerSubScene() {
        return Objects.equal(SceneUtils.getCurrentStepId(), "containerUpgradeEvaluation");
    }

    public String sceneResultPath() {
        ScenePathValue sceneValue = null;
        String scenePath = null;
        try {
            sceneValue = (ScenePathValue)SceneEnvironmentImpl.getInstance().getEnvirValueByKey(JSON_SCENERESULT_PATH);
            if (null == sceneValue) {
                return EMPTY_DATA;
            }
            scenePath = sceneValue.getJsonSceneResultPathValue();
            LOGGER.info(String.format(Locale.ENGLISH, "The sceneResultPath is:%s", scenePath));
        }
        catch (ToolException e) {
            LOGGER.error("the sceneResultPath exception:", e);
        }
        if (sceneValue == null) {
            scenePath = EMPTY_DATA;
        }
        return scenePath;
    }

    public boolean sceneSelectDevNode(String sn) {
        String sceneStatus = null;
        try {
            ISceneEnvironment environment = SceneEnvironmentImpl.getInstance();
            sceneStatus = environment.getDataVarByKey(EvaluSceneUtils.getDevNodeJsonQuery(sn));
            LOGGER.info(String.format(Locale.ENGLISH, "the dev status is :%s", sceneStatus));
        }
        catch (ToolException e) {
            LOGGER.error("get scene select device node failed", e);
            return false;
        }
        if (sceneStatus.equals(TaskResult.Result.SUCCESS.toString())) {
            LOGGER.info(String.format(Locale.ENGLISH, "devNode's scene is %s", sceneStatus));
            return false;
        }
        return true;
    }

    public String getCurrentSubScene() {
        SceneValue sceneValue = null;
        String subScene = null;
        try {
            ISceneBean bean = SceneEnvironmentImpl.getInstance().getEnvirValueByKey("jsonScene");
            if (null == bean) {
                return EMPTY_DATA;
            }
            sceneValue = (SceneValue)bean;
            subScene = sceneValue.getSubScene();
            LOGGER.info(String.format(Locale.ENGLISH, "The current sub scene is:%s", subScene));
        }
        catch (ToolException e) {
            LOGGER.error("the sub scene exception:", e);
        }
        if (sceneValue == null) {
            subScene = EMPTY_DATA;
        }
        return subScene;
    }

    public boolean isUpgradeSubScene() {
        return SCENE_SUB_SCENE_UPGRADE_NAME.equalsIgnoreCase(this.getCurrentSubScene());
    }

    public boolean isPreUpgradeCheckSubScene() {
        return SCENE_SUB_SCENE_UPGRADE_CHECK.equalsIgnoreCase(this.getCurrentSubScene()) || SCENE_A800_UPGRADE_CHECK.equalsIgnoreCase(this.getCurrentSubScene());
    }

    private static String getDevNodeJsonQuery(String sn) {
        HashMap<String, String> jsonQueryMap = new HashMap<String, String>();
        jsonQueryMap.put(SCENE_DEV_TOOLID, SCENE_TOOL_ID);
        jsonQueryMap.put(SCENE_SN, sn);
        JSONObject jsonObject = new JSONObject(jsonQueryMap);
        return jsonObject.toString();
    }

    public TaskResult finishedSceneTask() {
        return this.finishedSceneTask(null);
    }

    public TaskResult finishedSceneTask(List<EvaluDevNode> allDevNodes) {
        TaskResult ret = null;
        try {
            if (null == allDevNodes) {
                allDevNodes = EvaluDevManager.getInstance().getTabDevs();
            }
            List<Map<String, String>> sceneData = this.sceneEnvirData(allDevNodes);
            LOGGER.info(String.format(Locale.ENGLISH, "the sceneData is %s", sceneData));
            this.writeAllHostInfo();
            if (hostComAnaScene.booleanValue()) {
                SceneDataConstant.xmlDeviceName = SCENE_XML_DEVICE_NAME;
            }
            LOGGER.info(String.format(Locale.ENGLISH, "display step list sceneData:%s", sceneData));
            ret = SceneEnvironmentImpl.getInstance().finishedSceneTask(sceneData);
        }
        catch (ToolException e) {
            LOGGER.error("the finishedSceneTask exception", e);
        }
        catch (Exception e1) {
            LOGGER.error("the finishedSceneTask has exception.", e1);
        }
        return ret;
    }

    private String getDisableStep(List<EvaluDevNode> devNodes) {
        String diaableStep = EMPTY_DATA;
        boolean isAllLimitDev = EvaluSceneUtils.isAllLimitDevice(devNodes);
        boolean isAllOnline = EvaluSceneUtils.isUpgradeModeOnline(devNodes);
        if (!isAllOnline) {
            diaableStep = HOSTEVALUATION_STEP;
            String disableDesc = CompatibilityResourceUtils.getServiceString("preupgradeCheck.upgradeEvaluation.device.offline.custom.model");
            this.disableDescMap.put(NODE_DISABLE_STEP_DESC, disableDesc);
            LOGGER.info(String.format(Locale.ENGLISH, "disableAction:%s", diaableStep));
            return diaableStep;
        }
        if (EvaluSceneUtils.isSVPEnvAndAllDeviceNotSVP(devNodes)) {
            diaableStep = "hostEvaluation,upgradeEvaluation";
            String disableDesc = CompatibilityResourceUtils.getServiceString("preupgradeCheck.upgradeEvaluation.device.svp.add.device");
            this.disableDescMap.put(NODE_DISABLE_STEP_DESC, disableDesc);
            LOGGER.info(String.format(Locale.ENGLISH, "disableAction:%s", diaableStep));
            return diaableStep;
        }
        if (isAllLimitDev) {
            diaableStep = HOSTEVALUATION_STEP;
            String disableDesc = CompatibilityResourceUtils.getServiceString("preupgradeCheck.upgradeEvaluation.device.import.tv1.fail");
            this.disableDescMap.put(NODE_DISABLE_STEP_DESC, disableDesc);
        }
        LOGGER.info(String.format(Locale.ENGLISH, "disableAction:%s", diaableStep));
        return diaableStep;
    }

    public static boolean isLimitDevice(EvaluDevNode devNode) {
        String deviceType = devNode.getDeviceType().toString().toUpperCase(Locale.ENGLISH);
        String productVersion = devNode.getProductVersion().toUpperCase(Locale.ENGLISH);
        LOGGER.info(String.format(Locale.ENGLISH, "deviceType=%s", deviceType));
        if (productVersion.startsWith("V1") && (deviceType.endsWith("T") || deviceType.startsWith("S")) && !deviceType.startsWith("H")) {
            LOGGER.info("is tv1 device.");
            return true;
        }
        ArrayList<String> nosupportHostEvaluDevs = new ArrayList<String>();
        nosupportHostEvaluDevs.add("DORADO NAS");
        if (nosupportHostEvaluDevs.contains(deviceType)) {
            LOGGER.info("is limit device");
            return true;
        }
        return false;
    }

    public static boolean isAllLimitDevice(List<EvaluDevNode> allDevNodes) {
        if (allDevNodes.isEmpty()) {
            return false;
        }
        int i = 0;
        int count = allDevNodes.size();
        for (EvaluDevNode devNode : allDevNodes) {
            if (!EvaluSceneUtils.isLimitDevice(devNode)) continue;
            ++i;
        }
        return i == count;
    }

    public static boolean isUpgradeModeOnline(List<EvaluDevNode> allDevNodes) {
        if (allDevNodes.isEmpty()) {
            return true;
        }
        for (EvaluDevNode devNode : allDevNodes) {
            LOGGER.info("UpgradeMode:{},isStopHostBusiness:{}", (Object)devNode.getUpgradeMode(), (Object)devNode.isStopHostBusiness());
            UpgradeMode upgradeMode = devNode.getUpgradeMode();
            if (EvaluSceneUtils.isContainerSubScene()) {
                upgradeMode = devNode.getStorageUpgradeMode();
            }
            if (UpgradeMode.ONLINE != upgradeMode && UpgradeMode.APOLLO != upgradeMode || devNode.isStopHostBusiness()) continue;
            return true;
        }
        return false;
    }

    public static boolean isSVPEnvAndAllDeviceNotSVP(List<EvaluDevNode> allDevNodes) {
        if (!LocalHostUtil.isRunInV3LaterSvp()) {
            return false;
        }
        if (allDevNodes.isEmpty()) {
            return false;
        }
        for (EvaluDevNode devNode : allDevNodes) {
            if (!devNode.isIpListAreInnerIp()) continue;
            return false;
        }
        return true;
    }

    public List<Map<String, String>> sceneEnvirData(List<EvaluDevNode> allDevNodes) {
        ArrayList<Map<String, String>> sceneListMap = new ArrayList<Map<String, String>>();
        if (hostComAnaScene.booleanValue()) {
            this.createHostCompSceneData(sceneListMap);
            return sceneListMap;
        }
        if (EvaluSceneUtils.getSceneArg().equals(SCENE_TOOL_SETTING_ID)) {
            this.createSceneDataForSetting(sceneListMap, allDevNodes);
        } else {
            this.createEvaluToolSceneData(sceneListMap, allDevNodes);
        }
        return sceneListMap;
    }

    private void saveDeviceInfo(List<EvaluDevNode> allDevNodes) {
        StringBuilder toPrepareSNs = new StringBuilder();
        SceneDataExchange.getInstance().initDataExchange();
        for (EvaluDevNode devNode : allDevNodes) {
            toPrepareSNs.append(devNode.getDeviceSerialNumber()).append(',');
            SceneDataExchange.getInstance().saveKV(devNode.getDeviceSerialNumber(), devNode.getIp());
            LOGGER.info(String.format(Locale.ENGLISH, "evalu dev is :%s", devNode.getIp()));
            String key = devNode.getDeviceSerialNumber();
            SceneDataExchange.getInstance().saveKV(key + DEST, devNode.getDestVersion());
            SceneDataExchange.getInstance().saveKV(key + SRC, devNode.getProductVersion());
        }
        SceneDataExchange.getInstance().saveKV("needHandleSn", toPrepareSNs.toString());
    }

    private void createEvaluToolSceneData(List<Map<String, String>> sceneListMap, List<EvaluDevNode> allDevNodes) {
        Map<String, String> disableStepMap;
        for (EvaluDevNode devNode : allDevNodes) {
            Map<String, String> evaluMap = this.createEvaluMap(devNode);
            if (null == evaluMap || evaluMap.isEmpty()) continue;
            sceneListMap.add(evaluMap);
        }
        if (sceneListMap.isEmpty()) {
            return;
        }
        if (SCENE_SUB_SCENE_UPGRADE_CHECK.equals(this.getCurrentSubScene()) && null != (disableStepMap = this.caluDisableStep(allDevNodes)) && !disableStepMap.isEmpty()) {
            LOGGER.info(String.format(Locale.ENGLISH, "scene evalu operation data is :%s", disableStepMap.toString()));
            sceneListMap.add(disableStepMap);
        }
        if (this.isUpgradeSubScene()) {
            this.checkNeedInstallPatch(sceneListMap);
        }
    }

    private void createHostCompSceneData(List<Map<String, String>> sceneListMap) {
        Map<String, EvalTaskResult> results = HostEvalContext.getHostRvalResult();
        for (Map.Entry<String, EvalTaskResult> entry : results.entrySet()) {
            Map<String, String> evaluMap;
            LOGGER.info(String.format(Locale.ENGLISH, "evalu file is : %s", entry.getKey()));
            EvalTaskResult result = entry.getValue();
            if (result.getProgressCurrent() != 100.0f || null == (evaluMap = this.createHostEvaluMap(result)) || evaluMap.isEmpty()) continue;
            sceneListMap.add(evaluMap);
        }
    }

    private void createSceneDataForSetting(List<Map<String, String>> sceneListMap, List<EvaluDevNode> allDevNodes) {
        for (EvaluDevNode evaDevNode2 : allDevNodes) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(SCENE_DEV_STATUS, TaskResult.Result.SUCCESS.toString());
            map.put(SCENE_DEV_TOOLID, UPGRADE_SETTING_TOOL_ID);
            map.put(SCENE_SN, evaDevNode2.getDeviceSerialNumber());
            map.put(SCENE_IP, evaDevNode2.getIp());
            sceneListMap.add(map);
        }
        Map<String, String> disableStepMap = this.caluDisableStep(allDevNodes);
        if (null != disableStepMap && !disableStepMap.isEmpty()) {
            LOGGER.info(String.format(Locale.ENGLISH, "scene evalu operation data is :%s", disableStepMap.toString()));
            sceneListMap.add(disableStepMap);
        }
        allDevNodes.forEach(evaDevNode -> this.setDisplayStepMap(sceneListMap, (EvaluDevNode)((Object)evaDevNode)));
        HashMap<String, String> resultPathMap = new HashMap<String, String>();
        resultPathMap.put("resultFileSavePath", ApplicationContext.getInstance().getFilePath());
        sceneListMap.add(resultPathMap);
        this.saveDeviceInfo(allDevNodes);
    }

    private void setDisplayStepMap(List<Map<String, String>> sceneListMap, EvaluDevNode evaDevNode) {
        if (evaDevNode.isStorageImageUpgrade()) {
            LOGGER.info("Upgrade mode :{}", (Object)evaDevNode.getUpgradeMode());
            if (Objects.equal((Object)evaDevNode.getUpgradeMode(), (Object)UpgradeMode.FAST)) {
                this.addDisplayStepMapToSceneList(sceneListMap, "UpgradePrepare,upgradeEvaluation,containerUpgradeEvaluation,Collect");
                return;
            }
            this.addDisplayStepMapToSceneList(sceneListMap, "UpgradePrepare,Inspector,upgradeEvaluation,containerUpgradeEvaluation,Collect,hostEvaluation");
            return;
        }
        if (evaDevNode.getUpgradeMode().equals((Object)UpgradeMode.FAST)) {
            this.addDisplayStepMapToSceneList(sceneListMap, "UpgradePrepare,upgradeEvaluation,Collect");
            return;
        }
        if (CONTAINER_UPGRADE_MODE.contains((Object)evaDevNode.getUpgradeMode())) {
            this.addDisplayStepMapToSceneList(sceneListMap, "UpgradePrepare,upgradeEvaluation");
            return;
        }
        if (this.isNotSupportHostEval(evaDevNode)) {
            this.addDisplayStepMapToSceneList(sceneListMap, "UpgradePrepare,Inspector,upgradeEvaluation,Collect");
            return;
        }
        this.addDisplayStepMapToSceneList(sceneListMap, "UpgradePrepare,Inspector,upgradeEvaluation,Collect,hostEvaluation");
    }

    private boolean isNotSupportHostEval(EvaluDevNode evaDevNode) {
        return Products.isOceanStoComputingDev((String)evaDevNode.getDeviceType().toString()) || Products.isOceanStorMicroDev((String)evaDevNode.getDeviceType().toString()) || A800Utils.isA800UpgradeCheck();
    }

    private void addDisplayStepMapToSceneList(List<Map<String, String>> sceneListMap, String displayStep) {
        HashMap<String, String> displayMap = new HashMap<String, String>();
        displayMap.put(NODE_DISPLAY_STEP_LIST, displayStep);
        sceneListMap.add(displayMap);
        LOGGER.info(String.format(Locale.ENGLISH, "display step list:%s", displayStep));
    }

    private static void createExecTimeData(Map<String, String> sceneData) {
        if (null != EvaluContext.getStartTime()) {
            Date startTime = EvaluContext.getStartTime();
            String startTimeStr = new DateFormatUtil().getDateString(startTime);
            sceneData.put("startTime", startTimeStr);
        }
        if (null != EvaluContext.getEndTime()) {
            Date endTime = EvaluContext.getEndTime();
            String endTimeStr = new DateFormatUtil().getDateString(endTime);
            sceneData.put("endTime", endTimeStr);
        }
    }

    private void checkNeedInstallPatch(List<Map<String, String>> sceneListMap) {
        List<EvaluDevNode> allDevNodes = EvaluDevManager.getInstance().getTabDevs();
        boolean needInstallPatch = false;
        for (EvaluDevNode devNode : allDevNodes) {
            LOGGER.info(String.format(Locale.ENGLISH, "evalu dev is :%s", devNode.getIp()));
            if (!devNode.getResultHelper().isNeedInstallPatch()) continue;
            needInstallPatch = true;
        }
        if (needInstallPatch) {
            HashMap<String, String> dynamicStepMap = new HashMap<String, String>();
            dynamicStepMap.put("toolShowInfo", "installPath");
            dynamicStepMap.put("infoUrl_id", "patch");
            dynamicStepMap.put("type", "tool");
            dynamicStepMap.put("title_en", "Install Patch");
            dynamicStepMap.put("title_zh", "\u5b89\u88c5\u8865\u4e01");
            sceneListMap.add(dynamicStepMap);
        }
    }

    private Map<String, String> createHostEvaluMap(EvalTaskResult result) {
        HashMap<String, String> evaluDataMap = new HashMap<String, String>();
        evaluDataMap.put(SCENE_DEV_STATUS, result.getTaskStatus().getStatusDesc());
        evaluDataMap.put(SCENE_SN, result.getHostEvalTask().getIdentifier());
        evaluDataMap.put(SCENE_DEV_TOOLID, SCENE_TOOL_ID);
        return evaluDataMap;
    }

    private Map<String, String> createEvaluMap(EvaluDevNode devNode) {
        HashMap<String, String> evaluDataMap = new HashMap<String, String>();
        EvaluState status = devNode.getEvaluState();
        ResultFlag retFlag = devNode.getEvaluRet().getRetFlag();
        String devIp = devNode.getIp();
        String devSerial = devNode.getDeviceSerialNumber();
        if (EvaluState.WAIT == status || EvaluState.RUN == status) {
            return null;
        }
        if (EvaluState.SUCCESS == status && ResultFlag.PASS.equals((Object)retFlag)) {
            evaluDataMap.put(SCENE_DEV_STATUS, SCENE_RESULT_SUCCESS);
        } else {
            evaluDataMap.put(SCENE_DEV_STATUS, SCENE_RESULT_FAILED);
            if (this.isUpgradeSubScene()) {
                evaluDataMap.put(EXECUTE_TYPE, EXECUTE_TYPE_PARTIAL);
                LOGGER.info(String.format(Locale.ENGLISH, "evalu dev exist not pass item : %s", devNode.getIp()));
            }
        }
        evaluDataMap.put(SCENE_SN, devSerial);
        evaluDataMap.put(SCENE_IP, devIp);
        if (ApplicationContext.getInstance().isSpecificDeviceMode() && !StringUtils.isEmpty(devNode.getSvpIp())) {
            evaluDataMap.put(SCENE_IP, devNode.getSvpIp());
        }
        evaluDataMap.put(SCENE_DEV_TOOLID, SCENE_TOOL_ID);
        this.putDottingInformationMap(evaluDataMap);
        EvaluSceneUtils.createExecTimeData(evaluDataMap);
        return evaluDataMap;
    }

    private Map<String, String> emptyNata() {
        HashMap<String, String> scenceMap = new HashMap<String, String>();
        scenceMap.put(SCENE_IP, EMPTY_DATA);
        scenceMap.put(SCENE_SN, EMPTY_DATA);
        scenceMap.put(SCENE_DEV_STATUS, EMPTY_DATA);
        scenceMap.put(SCENE_DEV_TOOLID, SCENE_TOOL_ID);
        this.putDottingInformationMap(scenceMap);
        return scenceMap;
    }

    public static boolean isHostScene() {
        if (null != hostComAnaScene) {
            return hostComAnaScene;
        }
        String sceneKey = System.getenv(JSON_SCENERESULT_ARGS_ID);
        String toolScene = EMPTY_DATA;
        try {
            JSONObject jsonObj = new JSONObject(sceneKey);
            toolScene = (String)jsonObj.get("toolScene");
            hostComAnaScene = SCENE_TOOL_HOST_ID.equals(toolScene) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        catch (Exception e) {
            LOGGER.error("prase jsonSceneArgsList failed");
            hostComAnaScene = false;
        }
        return hostComAnaScene;
    }

    public static String getSceneArg() {
        String toolScene = EMPTY_DATA;
        try {
            String sceneKey = System.getenv(JSON_SCENERESULT_ARGS_ID);
            JSONObject jsonObj = new JSONObject(sceneKey);
            toolScene = (String)jsonObj.get("toolScene");
            hostComAnaScene = SCENE_TOOL_HOST_ID.equals(toolScene) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        catch (Exception e) {
            LOGGER.error("prase jsonSceneArgsList failed");
        }
        return toolScene;
    }

    public void addRecordsDottingInformation(String type, String context) {
        try {
            if (this.isScene()) {
                Date date = new Date();
                SimpleDateFormat ft = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
                JSONObject scenceDottingJsonObject = new JSONObject();
                scenceDottingJsonObject.put("type", (Object)type);
                scenceDottingJsonObject.put("time", (Object)ft.format(date));
                scenceDottingJsonObject.put("context", (Object)context);
                scenceDottingJsonObject.put("platform", (Object)"toolkit");
                scenceDottingJsonObject.put("module", (Object)SCENE_TOOL_ID);
                LOGGER.info(String.format(Locale.ENGLISH, "the sence data is %s", scenceDottingJsonObject.toString()));
                dottingInformationJsonArray.put((Object)scenceDottingJsonObject);
            }
        }
        catch (Exception e) {
            LOGGER.error("the dotting information exception:", e);
        }
    }

    public void putDottingInformationMap(Map<String, String> scenceMap) {
        try {
            boolean dottingInfomationFlag;
            String dottingStr = dottingInformationJsonArray.toString();
            boolean bl = dottingInfomationFlag = dottingStr.contains("\"type\":\"4\"") || dottingStr.contains("\"type\":\"1\"");
            if (dottingInfomationFlag && dottingStr.contains("\"type\":\"5\"")) {
                this.addRecordsDottingInformation("6", "WAIT");
                scenceMap.put(CHM_CLICK_EVENT, dottingInformationJsonArray.toString());
            } else {
                scenceMap.put(CHM_CLICK_EVENT, EMPTY_DATA);
            }
        }
        catch (Exception e) {
            LOGGER.error("the scenedata exception:", e);
        }
    }

    public String sceneHostResultPath() {
        String scenePath = this.sceneResultPath();
        if (EMPTY_DATA.equals(scenePath)) {
            LOGGER.info("Host info file(hostInfo4PreUpgradeCheck.csv) path is null");
            return EMPTY_DATA;
        }
        return scenePath + File.separator + HOST_INFO_FILE;
    }

    private void romoveItem(ArrayList<String> plist, String obj) {
        if (plist.contains(obj)) {
            plist.remove(obj);
        }
    }

    private Map<String, String> caluDisableStep(List<EvaluDevNode> allDevNodes) {
        ArrayList<String> disableStepList = new ArrayList<String>();
        HashMap<String, String> evaluOperStateMap = new HashMap<String, String>();
        String disableStep = this.getDisableStep(allDevNodes);
        evaluOperStateMap.putAll(this.disableDescMap);
        if (HOSTEVALUATION_STEP.equals(disableStep)) {
            LOGGER.info("hostevaluate step has disabled by selecte device step.");
            evaluOperStateMap.put(NODE_DISABLE_STEP_LIST, HOSTEVALUATION_STEP);
            return evaluOperStateMap;
        }
        if (allDevNodes.isEmpty()) {
            LOGGER.info("evaluate device is null.");
            return evaluOperStateMap;
        }
        disableStepList.add(HOSTEVALUATION_STEP);
        LOGGER.info("begin to create disable step Map.");
        for (EvaluDevNode devNode : allDevNodes) {
            if (this.needDisableHostEvalutionStep(devNode)) continue;
            LOGGER.info(String.format(Locale.ENGLISH, "the device need not disable hostevalu.deviceId=%s", devNode.getIp()));
            this.romoveItem(disableStepList, HOSTEVALUATION_STEP);
        }
        if (!disableStepList.isEmpty()) {
            evaluOperStateMap.put(NODE_DISABLE_STEP_LIST, StringUtils.join(disableStepList, ","));
        }
        return evaluOperStateMap;
    }

    private boolean needDisableHostEvalutionStep(EvaluDevNode devNode) {
        EvaluState status = devNode.getEvaluState();
        LOGGER.info(String.format(Locale.ENGLISH, "evaluate status:%s", status.toString()));
        return UpgradeMode.OFFLINE == devNode.getUpgradeMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTableHeadData() {
        if (null == this.sceneHostPath) {
            LOGGER.info("The file is null");
            return;
        }
        FileOutputStream out = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            out = new FileOutputStream(this.sceneHostPath, true);
            osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
            bw = new BufferedWriter(osw);
            bw.write(HOST_INFO_TABLE);
            bw.write("\r\n");
        }
        catch (Exception e) {
            LOGGER.error("write host info file exception.", e);
        }
        finally {
            try {
                if (null != bw) {
                    bw.close();
                }
                if (null != osw) {
                    osw.close();
                }
                if (null != out) {
                    out.close();
                }
            }
            catch (IOException e) {
                LOGGER.warn("close host info stream failed.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAllHostInfo() {
        block10: {
            List<EvaluDevNode> allDevNodes = EvaluDevManager.getInstance().getTabDevs();
            if (null == this.sceneHostPath) {
                LOGGER.info("Host info file is null");
                return;
            }
            ArrayList<String> allHostList = new ArrayList<String>();
            for (EvaluDevNode devNode : allDevNodes) {
                ArrayList<String> hostInfoList = devNode.getHostInfoList();
                if (null == hostInfoList || hostInfoList.isEmpty()) {
                    LOGGER.info(String.format(Locale.ENGLISH, "The device has not host info. Device SN: %s", devNode.getDeviceSerialNumber()));
                    continue;
                }
                allHostList.addAll(hostInfoList);
            }
            if (allHostList.isEmpty()) {
                LOGGER.info("host info is empty.");
                return;
            }
            FileOutputStream out = null;
            OutputStreamWriter osw = null;
            BufferedWriter bw = null;
            try {
                this.writeTableHeadData();
                out = new FileOutputStream(this.sceneHostPath, true);
                osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
                bw = new BufferedWriter(osw);
                for (String info : allHostList) {
                    bw.write(info);
                    bw.write("\r\n");
                }
                StreamUtils.closeResource(null, (Closeable)bw);
            }
            catch (Exception e) {
                LOGGER.error("Write host file exception.", e);
                break block10;
            }
            finally {
                StreamUtils.closeResource(null, bw);
                StreamUtils.closeResource(null, osw);
                StreamUtils.closeResource(null, (Closeable)out);
            }
            StreamUtils.closeResource(null, (Closeable)osw);
            StreamUtils.closeResource(null, (Closeable)out);
        }
    }

    public static boolean getCheckItemValue(String value) {
        boolean isOfflineUpgradeVisable = false;
        String userDir = ApplicationContext.getInstance().getWorkPath();
        String workPath = EMPTY_DATA;
        try {
            int index = userDir.lastIndexOf(TOOLSFOLDER);
            workPath = index != -1 ? userDir.substring(0, index) : userDir;
            LOGGER.info(String.format(Locale.ENGLISH, "the current work path is : %s", workPath));
            SystemProperties appConfigs = new SystemProperties(workPath);
            isOfflineUpgradeVisable = "true".equalsIgnoreCase(appConfigs.getValue(value));
        }
        catch (MissingResourceException e) {
            LOGGER.error("Can not find the key from system.properties.");
        }
        catch (Exception e) {
            LOGGER.error("Find other exception:", e);
        }
        LOGGER.info(String.format(Locale.ENGLISH, "isOfflineUpgradeVisable: %s", isOfflineUpgradeVisable));
        return isOfflineUpgradeVisable;
    }

    public static boolean isHyperMetroScene() {
        return isHyperMetro;
    }

    public static void setHyperMetro(boolean isHyper) {
        isHyperMetro = isHyper;
    }

    public static String cutTooLongSns2Lines(String sns) {
        String[] snsList = sns.split(",");
        String snsParsed = EMPTY_DATA;
        for (int poi = 0; poi < snsList.length; ++poi) {
            snsParsed = poi != 0 && poi % 3 == 0 ? snsParsed + snsList[poi] + ",<br/>" : (poi + 1 == snsList.length ? snsParsed + snsList[poi] : snsParsed + snsList[poi] + ",");
        }
        return snsParsed;
    }

    static {
        EvaluSceneUtils.isHostScene();
    }
}

