/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.util;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.utils.in.CommonMethod;
import com.huawei.ism.tool.obase.utils.in.ComponentDefine;
import com.huawei.ism.tool.upgradeevalu.util.FileUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileAssistant {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileAssistant.class);
    private static final int EXECUTE_COMPRESS_SUCCESS = 1;
    private static final int EXECUTE_COMPRESS_FAILD = -1;
    private static final int MAX_NUM = 99999;
    private static final String LOGS = "logs";
    private static final String RUNLOG = "runlog";
    private static final String A_LINE_T7Z = " a -t7z";
    private static final String NULL_A_NULL = " a ";
    private static final String NULL_X_NULL = " x ";
    private static final String NULL_LINE_O = " -o";
    private static final String NULL_LINE_Y = " -y";
    private static final String NULL_LINE_P = " -p";
    private static final String LINE_R_LINE_Y = " -r -y";
    private static final String DECOMPRESS_RESULT = "password";
    private static final String OS_POINT_NAME = "os.name";
    private static final String WINDOWS = "Windows";
    private static final String RD = "rd ";
    private static final String Q_NULL_S = "/Q /S";
    private static final String RM_NULL_RF = "rm -rf ";
    private static final String A_TZIP = " a -tzip";
    private static final String LINE_V = "-v";
    private static final String CREATE_FAILED = "create failed";
    private static final String BZ2_SUFFIX = "\\.bz2";
    private static final String TAR_SUFFIX = "\\.tar";
    private static final String GZ_SUFFIX = "\\.gz";
    private static final Object LOCKOBJ = new Object();
    public static final String COLLECT_SYSTEM_LOG_NAME = "System_log";

    private FileAssistant() {
    }

    public static void clearDir(String dir) {
        if (StringUtils.isNULLStr((String)dir)) {
            return;
        }
        File file = new File(dir);
        if (!file.exists()) {
            return;
        }
        FileUtils.deleteFile((File)file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(String filePath) {
        if (StringUtils.isNULLStr((String)filePath)) {
            return "";
        }
        FileInputStream in = null;
        String str = "";
        try {
            in = new FileInputStream(filePath);
            int len = in.available();
            byte[] bs = new byte[len];
            if (in.read(bs) <= 0) {
                String string = str;
                return string;
            }
            str = new String(bs, Charset.defaultCharset());
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Get file content  error.file not found.");
        }
        catch (Exception e) {
            LOGGER.error("Get file content error.", e);
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)in);
        }
        return str;
    }

    public static void clearEmptyLogFile() {
        String workPath = ApplicationContext.getInstance().getWorkPath();
        File logDir = new File(workPath + File.separator + LOGS + File.separator + RUNLOG);
        File[] logsFiles = logDir.listFiles();
        if (null == logsFiles) {
            return;
        }
        for (File file : logsFiles) {
            if (0L != file.length() || file.delete()) continue;
            LOGGER.error("Delete file: " + file.getName() + " error!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compressFile7z(String aimFileName, String ... sourceDir) {
        Object object = LOCKOBJ;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])sourceDir) || StringUtils.isNULLStr((String)aimFileName)) {
                LOGGER.info("path is null.");
                return false;
            }
            StringBuffer sb = new StringBuffer();
            for (String file : sourceDir) {
                sb.append(ComponentDefine.getMarks() + file + ComponentDefine.getMarks() + " ");
            }
            StringBuffer cmd = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(A_LINE_T7Z).append(" ").append(ComponentDefine.getMarks()).append(aimFileName).append(ComponentDefine.getMarks()).append(" ").append(sb.toString());
            if (!FileAssistant.executeCmd(cmd.toString(), true)) {
                LOGGER.error("Compress " + sb.toString() + " error");
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compressTgzFile(String aimFileName, String ... sourceDir) {
        Object object = LOCKOBJ;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])sourceDir) || StringUtils.isNULLStr((String)aimFileName)) {
                LOGGER.info("path is null.");
                return false;
            }
            String tempName = aimFileName.replace(".tgz", ".tar");
            StringBuffer sb = new StringBuffer();
            for (String file : sourceDir) {
                sb.append(ComponentDefine.getMarks() + file + ComponentDefine.getMarks() + " ");
            }
            StringBuffer cmd = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(NULL_A_NULL).append(ComponentDefine.getMarks()).append(tempName).append(ComponentDefine.getMarks()).append(" ").append(sb.toString());
            if (!FileAssistant.executeCmd(cmd.toString(), true)) {
                LOGGER.error("Compress " + sb.toString() + " error");
                return false;
            }
            if (!FileAssistant.compressTarFile(tempName, aimFileName)) {
                FileUtils.deleteFile((File)new File(tempName));
                return false;
            }
            FileUtils.deleteFile((File)new File(tempName));
            return true;
        }
    }

    private static boolean compressTarFile(String tempName, String targetPath) {
        StringBuffer cmd = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(NULL_A_NULL).append(ComponentDefine.getMarks()).append(targetPath).append(ComponentDefine.getMarks()).append(" ").append(ComponentDefine.getMarks()).append(tempName).append(ComponentDefine.getMarks());
        if (!FileAssistant.executeCmd(cmd.toString(), true)) {
            LOGGER.error("Compress " + tempName + " error");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deCopmressZipFile(String targetPath, String zipSourceFilePath, String ... targetFiles) {
        Object object = LOCKOBJ;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])targetFiles) || StringUtils.hasNULLStr((String[])new String[]{targetPath, zipSourceFilePath})) {
                LOGGER.info("path is null.");
                return;
            }
            if (!FileUtils.fileSize2GInvalid((File)new File(zipSourceFilePath))) {
                LOGGER.info(String.format(Locale.ENGLISH, "the file size is over 2G. %s", zipSourceFilePath));
                return;
            }
            StringBuffer targetFileSb = new StringBuffer();
            for (String targetFile : targetFiles) {
                targetFileSb.append(targetFile);
                targetFileSb.append(" ");
            }
            String targets = targetFileSb.toString().trim();
            StringBuffer cmdSb = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(NULL_X_NULL).append(ComponentDefine.getMarks()).append(zipSourceFilePath).append(ComponentDefine.getMarks()).append(NULL_LINE_O).append(ComponentDefine.getMarks()).append(targetPath).append(ComponentDefine.getMarks()).append(ComponentDefine.getMarks()).append(targets).append(LINE_R_LINE_Y);
            if (!FileAssistant.executeCmd(cmdSb.toString(), true)) {
                LOGGER.info(String.format(Locale.ENGLISH, "Decompress %s from zip file %s with 7z error !", targets, zipSourceFilePath));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int deCopmressZipFileWithPassword(String targetPath, String zipFilePath, String password, String ... targetFiles) {
        Object object = LOCKOBJ;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])targetFiles) || StringUtils.hasNULLStr((String[])new String[]{targetPath, zipFilePath})) {
                LOGGER.info("path is null.");
                return 1;
            }
            if (!FileUtils.fileSize2GInvalid((File)new File(zipFilePath))) {
                LOGGER.info(String.format(Locale.ENGLISH, "the file size is over 2G. %s", zipFilePath));
                return 1;
            }
            StringBuffer targetFileSb = new StringBuffer();
            for (String targetFile : targetFiles) {
                targetFileSb.append(targetFile);
                targetFileSb.append(" ");
            }
            String targetFile = targetFileSb.toString().trim();
            StringBuffer cmdSb = FileAssistant.composeDecomposeCmdWithPwd(targetPath, zipFilePath, targetFile);
            String result = FileAssistant.executeCmdWithPassword(cmdSb.toString(), password);
            if (-1 != result.indexOf("Wrong password")) {
                return -1;
            }
            LOGGER.info(String.format(Locale.ENGLISH, "Decompress %s from zip file %s with 7z result: %s", targetFile, zipFilePath, result));
            if (-1 != result.toLowerCase(Locale.ENGLISH).indexOf(DECOMPRESS_RESULT)) {
                try {
                    if (!FileAssistant.executeCmd(password, false)) {
                        LOGGER.info(String.format(Locale.ENGLISH, "Decompress %s from zip file %s with 7z error !", targetFile, zipFilePath));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("executeCmd Password error!!!", e);
                }
            }
            return 1;
        }
    }

    private static StringBuffer composeDecomposeCmdWithPwd(String targetPath, String zipFilePath, String targetFile) {
        return new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(NULL_X_NULL).append(ComponentDefine.getMarks()).append(zipFilePath).append(ComponentDefine.getMarks()).append(NULL_LINE_O).append(ComponentDefine.getMarks()).append(targetPath).append(ComponentDefine.getMarks()).append(" ").append(targetFile).append(LINE_R_LINE_Y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deCopmressTotalZipFile(String targetWithPath, String zipFilePath, String[] pwds) {
        Object object = LOCKOBJ;
        synchronized (object) {
            StringBuffer cmd;
            String result;
            if (StringUtils.hasNULLStr((String[])new String[]{targetWithPath, zipFilePath})) {
                LOGGER.info("path is null.");
                return;
            }
            if (!FileUtils.fileSize2GInvalid((File)new File(zipFilePath))) {
                LOGGER.info(String.format(Locale.ENGLISH, "the file size is over 2G. %s", zipFilePath));
                return;
            }
            for (int i = 0; i < pwds.length && !FileAssistant.isExecuteSuccess(result = FileAssistant.executeCmdWithPassword((cmd = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(NULL_X_NULL).append(ComponentDefine.getMarks()).append(zipFilePath).append(ComponentDefine.getMarks()).append(NULL_LINE_O).append(ComponentDefine.getMarks()).append(targetWithPath).append(ComponentDefine.getMarks()).append(NULL_LINE_Y).append(NULL_LINE_P).append(pwds[i])).toString(), pwds[i])); ++i) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deCopmressTotalZipFile(String targetWithPath, String zipFilePath) {
        Object object = LOCKOBJ;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])new String[]{targetWithPath, zipFilePath})) {
                LOGGER.info("path is null.");
                return;
            }
            if (!FileUtils.fileSize2GInvalid((File)new File(zipFilePath))) {
                LOGGER.info(String.format(Locale.ENGLISH, "the file size is over 2G. %s", zipFilePath));
                return;
            }
            StringBuffer cmd = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(NULL_X_NULL).append(ComponentDefine.getMarks()).append(zipFilePath).append(ComponentDefine.getMarks()).append(NULL_LINE_O).append(ComponentDefine.getMarks()).append(targetWithPath).append(ComponentDefine.getMarks()).append(NULL_LINE_Y);
            if (!FileAssistant.executeCmd(cmd.toString(), true)) {
                LOGGER.info(String.format(Locale.ENGLISH, "Decompress zip file %s with 7z error!", zipFilePath));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deCompressTgz(String targetPath, String gzFilePath) {
        Object object = LOCKOBJ;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])new String[]{targetPath, gzFilePath})) {
                LOGGER.info("path is null.");
                return false;
            }
            File gzFile = new File(gzFilePath);
            if (!FileUtils.fileSize2GInvalid((File)gzFile)) {
                LOGGER.info(String.format(Locale.ENGLISH, "the file size is over 2G. %s", gzFilePath));
                return false;
            }
            String tarFileName = targetPath + File.separator + gzFile.getName().replace(".tgz", ".tar");
            if (!FileAssistant.deCopmressAllZipFile(targetPath, gzFilePath)) {
                LOGGER.info("deCopmress tgz file to tar file failed!");
                return false;
            }
            if (!FileAssistant.deCopmressAllZipFile(targetPath, tarFileName)) {
                LOGGER.info("deCopmress tar file failed!");
                return false;
            }
            File tarFile = new File(tarFileName);
            if (!tarFile.delete()) {
                LOGGER.error("Delete file " + tarFileName + " error!");
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deCopmressAllZipFile(String targetWithPath, String zipFilePath) {
        Object object = LOCKOBJ;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])new String[]{targetWithPath, zipFilePath})) {
                LOGGER.info("path is null.");
                return false;
            }
            if (!FileUtils.fileSize2GInvalid((File)new File(zipFilePath))) {
                LOGGER.info(String.format(Locale.ENGLISH, "the file size is over 2G. %s", zipFilePath));
                return false;
            }
            StringBuffer cmdBuffer = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(NULL_X_NULL).append(ComponentDefine.getMarks()).append(zipFilePath);
            cmdBuffer.append(ComponentDefine.getMarks()).append(NULL_LINE_O).append(ComponentDefine.getMarks()).append(targetWithPath).append(ComponentDefine.getMarks()).append(NULL_LINE_Y);
            if (!FileAssistant.executeCmd(cmdBuffer.toString(), true)) {
                LOGGER.info(String.format(Locale.ENGLISH, "Decompress zip file %s with 7z error!", zipFilePath));
                return false;
            }
            return true;
        }
    }

    public static String executeCmdWithPassword(String cmd, String pwssword) {
        Process pro = null;
        try {
            LOGGER.info(String.format(Locale.ENGLISH, "Execute command ", cmd.replace(cmd, "******")));
            pro = OSCmdUtils.createCmdProcess((String[])new String[]{cmd});
        }
        catch (Exception e) {
            LOGGER.error("Execute " + cmd.replace(cmd, "******") + " error: ", e);
            return "";
        }
        return CommonMethod.executePassword((Process)pro, (String)pwssword);
    }

    public static boolean executeCmdInPath(String cmd) {
        Process pro = null;
        try {
            LOGGER.info(String.format(Locale.ENGLISH, "Execute command %s", cmd));
            pro = OSCmdUtils.createCmdProcess((String[])new String[]{"cmd.exe /C " + cmd});
        }
        catch (Exception e) {
            LOGGER.error("Execute " + cmd + " error: ", e);
            return false;
        }
        String result = CommonMethod.getProcessResult((Process)pro);
        LOGGER.info(String.format(Locale.ENGLISH, "executeCmd result:%s", result));
        return !result.toLowerCase(Locale.ENGLISH).contains("error");
    }

    public static boolean executeCmdInPathWithoutResult(String cmd) {
        cmd = "cmd.exe /C " + cmd;
        try {
            LOGGER.info(String.format(Locale.ENGLISH, "Execute command %s", cmd));
            OSCmdUtils.executeCmd((String)cmd);
        }
        catch (Exception e) {
            LOGGER.error("Execute " + cmd + " error: ", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deCompressTarGzFile(String targetPath, String tarGzFilePath) {
        Object object = LOCKOBJ;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])new String[]{targetPath, tarGzFilePath})) {
                LOGGER.info("path is null.");
                return;
            }
            if (!FileUtils.fileSize2GInvalid((File)new File(tarGzFilePath))) {
                LOGGER.info(String.format(Locale.ENGLISH, "the file size is over 2G. %s", tarGzFilePath));
                return;
            }
            String tarFileName = tarGzFilePath.split(GZ_SUFFIX)[0];
            FileAssistant.deCopmressTotalZipFile(targetPath, tarGzFilePath);
            FileAssistant.deCopmressTotalZipFile(tarGzFilePath, tarFileName);
            File tarFile = new File(tarFileName);
            if (!tarFile.delete()) {
                LOGGER.error("Delete file " + tarFileName + " error!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deCompressTarbz2File(String targetPath, String tarGzFilePath) {
        Object object = LOCKOBJ;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])new String[]{targetPath, tarGzFilePath})) {
                LOGGER.info("path is null.");
                return;
            }
            if (!FileUtils.fileSize2GInvalid((File)new File(tarGzFilePath))) {
                LOGGER.info(String.format(Locale.ENGLISH, "the file size is over 2G. %s", tarGzFilePath));
                return;
            }
            if (!tarGzFilePath.endsWith(".bz2")) {
                return;
            }
            String tarFileName = tarGzFilePath.split(BZ2_SUFFIX)[0];
            File file = new File(tarFileName);
            String tarbz2FileName = file.getName();
            String[] tmp = tarbz2FileName.split(TAR_SUFFIX);
            FileAssistant.deCopmressTotalZipFile(targetPath, tarGzFilePath);
            FileAssistant.deCopmressTotalZipFile(targetPath + File.separator + tmp[0], tarFileName);
            File tarFile = new File(tarFileName);
            if (!tarFile.delete()) {
                LOGGER.error("Delete file " + tarFileName + " error!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deCompressTarbz2FileWithName(String targetPath, String tarGzFilePath) {
        Object object = LOCKOBJ;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])new String[]{targetPath, tarGzFilePath})) {
                LOGGER.info("path is null.");
                return;
            }
            if (!FileUtils.fileSize2GInvalid((File)new File(tarGzFilePath))) {
                LOGGER.info(String.format(Locale.ENGLISH, "the file size is over 2G. %s", tarGzFilePath));
                return;
            }
            String tarFileName = tarGzFilePath.split(BZ2_SUFFIX)[0];
            FileAssistant.deCopmressTotalZipFile(targetPath, tarGzFilePath);
            FileAssistant.deCopmressTotalZipFile(targetPath, tarFileName);
            File tarFile = new File(tarFileName);
            if (!tarFile.delete()) {
                LOGGER.error("Delete file " + tarFileName + " error!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deCompressTgzFile(String targetPath, String gzFilePath) {
        Object object = LOCKOBJ;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])new String[]{targetPath, gzFilePath})) {
                LOGGER.info("path is null.");
                return;
            }
            File gzFile = new File(gzFilePath);
            if (!FileUtils.fileSize2GInvalid((File)gzFile)) {
                LOGGER.info(String.format(Locale.ENGLISH, "the file size is over 2G. %s", gzFilePath));
                return;
            }
            String tarFileName = targetPath + File.separator + gzFile.getName().replace(".tgz", ".tar");
            FileAssistant.deCopmressTotalZipFile(targetPath, gzFilePath);
            FileAssistant.deCopmressTotalZipFile(targetPath, tarFileName);
            File tarFile = new File(tarFileName);
            if (!tarFile.delete()) {
                LOGGER.error("Delete file " + tarFileName + " error!");
            }
        }
    }

    public static boolean delFile(String filePath) {
        if (StringUtils.hasNULLStr((String[])new String[]{filePath})) {
            LOGGER.info("path is null.");
            return false;
        }
        File sourceZipFile = new File(filePath);
        if (sourceZipFile.exists()) {
            return sourceZipFile.delete();
        }
        LOGGER.error("the filePath is not exist!:" + filePath);
        return true;
    }

    public static boolean delDirAndFile(String fileDir) {
        if (StringUtils.hasNULLStr((String[])new String[]{fileDir})) {
            LOGGER.info("path is null.");
            return false;
        }
        LOGGER.info(String.format(Locale.ENGLISH, "delete dir and file:%s", fileDir));
        File file2Del = new File(fileDir);
        FileAssistant.clearFileDir(file2Del);
        if (!file2Del.delete()) {
            FileAssistant.delDirWithOsCmd(FilePathUtils.getCanonicalPath((File)file2Del));
        }
        return true;
    }

    public static boolean delDirWithOsCmd(String dirPath) {
        if (StringUtils.hasNULLStr((String[])new String[]{dirPath})) {
            LOGGER.info("path is null.");
            return false;
        }
        String osName = System.getProperty(OS_POINT_NAME);
        if (osName == null) {
            return false;
        }
        if (osName.contains(WINDOWS)) {
            return FileAssistant.executeCmdInPath(RD + ComponentDefine.getMarks() + dirPath + ComponentDefine.getMarks() + " " + Q_NULL_S);
        }
        if (osName.contains("Linux")) {
            return FileAssistant.executeCmd(RM_NULL_RF + dirPath, true);
        }
        return false;
    }

    public static void clearFileDir(File filetoDelete) {
        if (null == filetoDelete) {
            return;
        }
        if (!filetoDelete.isDirectory()) {
            return;
        }
        File tmpFile = new File(filetoDelete.toURI().getPath());
        File[] files = tmpFile.listFiles();
        boolean isDelectSuccess = false;
        if (null == files || files.length == 0) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                FileAssistant.clearFileDir(file);
            }
            try {
                isDelectSuccess = file.delete();
            }
            catch (SecurityException e) {
                LOGGER.error("Delete file exception", e);
            }
            if (isDelectSuccess) continue;
            LOGGER.error("Delete file " + file.getName() + " error");
        }
    }

    public static Collection<String> listAllFile(String parentPath, String ... fileSuffix) {
        ArrayList<String> result = new ArrayList<String>();
        File path = new File(parentPath);
        File[] subFiles = path.listFiles();
        if (subFiles == null) {
            return result;
        }
        for (File file : subFiles) {
            String fileName = file.getName();
            String filePath = FilePathUtils.getCanonicalPath((File)file);
            if (FileAssistant.isMathFileSuffix(fileName, fileSuffix)) {
                result.add(filePath);
                continue;
            }
            if (!file.isDirectory()) continue;
            result.addAll(FileAssistant.listAllFile(filePath, fileSuffix));
        }
        return result;
    }

    private static boolean isMathFileSuffix(String fileName, String ... fileSuffixs) {
        for (String suffix : fileSuffixs) {
            if (!fileName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static Collection<String> listAllFileWithNameIndex(String parentPath, String nameIndex) {
        ArrayList<String> result = new ArrayList<String>();
        File path = new File(parentPath);
        File[] subFiles = path.listFiles();
        if (subFiles == null) {
            return result;
        }
        for (File file : subFiles) {
            String fileName = file.getName();
            String filePath = FilePathUtils.getCanonicalPath((File)file);
            if (file.isDirectory() || -1 == fileName.indexOf(nameIndex)) continue;
            result.add(filePath);
        }
        return result;
    }

    public static void clearFileDir(File filetoDelete, String except) {
        if (null == filetoDelete) {
            return;
        }
        URI uri = filetoDelete.toURI();
        File tmpFile = null;
        try {
            tmpFile = new File(uri.toURL().getPath());
        }
        catch (MalformedURLException e1) {
            LOGGER.error("Create file error.", e1);
        }
        if (null == tmpFile) {
            return;
        }
        if (!tmpFile.isDirectory()) {
            return;
        }
        File[] files = tmpFile.listFiles();
        if (null == files) {
            return;
        }
        boolean isDeleteSuccss = false;
        for (File file : files) {
            if (file.isDirectory()) {
                FileAssistant.clearFileDir(file);
            }
            if (-1 != file.getName().indexOf(except)) continue;
            try {
                isDeleteSuccss = file.delete();
            }
            catch (SecurityException e) {
                LOGGER.error("Delete file exception", e);
            }
            if (isDeleteSuccss) continue;
            LOGGER.error("Delete file " + file.getName() + " error");
        }
    }

    public static void mergeFiles(String sourceFile, String resultFile) {
        if (StringUtils.hasNULLStr((String[])new String[]{sourceFile, resultFile})) {
            LOGGER.info("path is null.");
            return;
        }
        String osName = System.getProperty(OS_POINT_NAME);
        if (osName == null) {
            return;
        }
        StringBuffer cmdSb = new StringBuffer();
        if (osName.contains(WINDOWS)) {
            cmdSb.append("type").append(" ").append(ComponentDefine.getMarks()).append(sourceFile).append(ComponentDefine.getMarks()).append(">>").append(ComponentDefine.getMarks()).append(resultFile).append(ComponentDefine.getMarks());
        } else if (osName.contains("Linux")) {
            cmdSb.append("cat").append(" ").append(ComponentDefine.getMarks()).append(sourceFile).append(ComponentDefine.getMarks()).append(">>").append(ComponentDefine.getMarks()).append(resultFile).append(ComponentDefine.getMarks());
        }
        if (!FileAssistant.executeCmdInPath(cmdSb.toString())) {
            LOGGER.info(String.format(Locale.ENGLISH, "Merge file %s to %s error!", sourceFile, resultFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deCompressFiles(String rootPath, List<String> includePaths) {
        Object object = LOCKOBJ;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])new String[]{rootPath})) {
                LOGGER.info("path is null.");
                return;
            }
            File file = new File(rootPath);
            File[] childrens = file.listFiles();
            if (null == childrens) {
                return;
            }
            for (File child : childrens) {
                File[] files;
                if (!includePaths.contains(child.getName()) || (files = child.listFiles()) == null) continue;
                for (File item : files) {
                    if (!item.getName().endsWith(".tgz")) continue;
                    FileAssistant.deCompressTgzFile(FileUtil.getCanonicalPath(child), FileUtil.getCanonicalPath(item));
                    if (item.delete()) continue;
                    LOGGER.error("Can not delete file: " + item.getName());
                }
            }
        }
    }

    private static String get7zPath() {
        StringBuffer buffer = new StringBuffer().append(ApplicationContext.getInstance().getWorkPath()).append(File.separator).append("utils").append(File.separator).append("7z").append(File.separator).append("7za");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressFile7zToSplitVolume(String size, String aimFileName, String ... sourceDir) {
        Object object = LOCKOBJ;
        synchronized (object) {
            if (StringUtils.hasNULLStr((String[])sourceDir)) {
                LOGGER.info("path is null.");
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (String file : sourceDir) {
                stringBuffer.append(ComponentDefine.getMarks() + file + ComponentDefine.getMarks() + " ");
            }
            StringBuffer cmdFor7z = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(A_TZIP).append(" ").append(ComponentDefine.getMarks()).append(aimFileName).append(ComponentDefine.getMarks()).append(" ").append(stringBuffer.toString()).append(LINE_V).append(size);
            boolean reslut = FileAssistant.executeCmd(cmdFor7z.toString(), true);
            if (!reslut) {
                LOGGER.error("Compress " + stringBuffer.toString() + " error");
            } else {
                LOGGER.info("Compressed files has succeed!");
            }
        }
    }

    public static boolean executeCmd(String cmd, boolean log) {
        Process pro = null;
        if (log) {
            LOGGER.info("Execute command {}", (Object)cmd);
        }
        try {
            pro = OSCmdUtils.createCmdProcess((String[])new String[]{cmd});
        }
        catch (Exception e) {
            LOGGER.error("Execute error: ", e);
            return false;
        }
        LOGGER.info("Execute command over");
        String result = CommonMethod.getProcessResult((Process)pro);
        LOGGER.info(String.format(Locale.ENGLISH, "executeCmd result:%s", result));
        return FileAssistant.isExecuteSuccess(result);
    }

    private static boolean isExecuteSuccess(String result) {
        return !result.toLowerCase(Locale.ENGLISH).contains("error");
    }

    public static boolean unZip(String outPath, String unzipfile) {
        try {
            ZipUtils.decompressFile((File)new File(unzipfile), (String)outPath);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("unzip error: ", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean seachFileFrom7zFile(String filepath, String fileName) {
        SevenZFile sevenZFile = null;
        File file = new File(filepath);
        try {
            sevenZFile = new SevenZFile(file);
            Iterable<SevenZArchiveEntry> entries = sevenZFile.getEntries();
            for (SevenZArchiveEntry next : entries) {
                if (!next.getName().contains(fileName)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOGGER.error("seven Z File init error try zip file check");
            boolean bl = FileAssistant.zipFileCheck(file, fileName);
            return bl;
        }
        finally {
            StreamUtils.closeResource(null, (Closeable)sevenZFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean zipFileCheck(File file, String fileName) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            Enumeration<ZipArchiveEntry> zipFileEntries = zipFile.getEntries();
            while (zipFileEntries.hasMoreElements()) {
                ZipArchiveEntry zipNextElement = zipFileEntries.nextElement();
                String formateKeyword = fileName.replaceAll("\\\\", "/");
                if (!zipNextElement.getName().contains(fileName) && !zipNextElement.getName().contains(formateKeyword)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e1) {
            LOGGER.error("zip package check keyword encount error");
            ToolLoggerFactory.getLogger(FileAssistant.class).info("Not exist file(" + fileName + ") in the 7z file: " + file);
        }
        finally {
            StreamUtils.closeResource(null, (Closeable)zipFile);
        }
        return false;
    }
}

