/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.util;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.devicemanager.utils.FilesUtil;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.File;
import javax.swing.filechooser.FileSystemView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtil.class);
    private static final String LEFTSLASHS = "\\\\";
    private static final String RIGHTSLASH = "/";
    private static final String COLON = ":";
    private static final String LEFTSLASHS_POINT = "\\.";
    private static final FileUtil INSTANCE = new FileUtil();

    private FileUtil() {
    }

    public static FileUtil getInstance() {
        return INSTANCE;
    }

    public static boolean checkNormalPath(String path) {
        path = path.replaceAll(LEFTSLASHS, "");
        path = path.replaceAll(RIGHTSLASH, "");
        path = path.replaceAll(COLON, "");
        return !(path = path.replaceAll(LEFTSLASHS_POINT, "")).contains("  ");
    }

    public static boolean checkBlankPath(String path) {
        return ApplicationContext.getInstance().isWindowsOS() || !path.contains(" ");
    }

    public static File getDefaultDirectory() {
        File file = FileSystemView.getFileSystemView().getDefaultDirectory();
        if (!FilesUtil.isNormalPath((String)FilePathUtils.getCanonicalPath((File)file))) {
            String tmpdir = FilePathUtils.checkFile((String)System.getProperty("java.io.tmpdir"));
            file = new File(tmpdir);
        }
        return file;
    }

    public static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (Exception e) {
            LOGGER.error("get canonical path error", e);
            return "";
        }
    }
}

