/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.util;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.SystemEnvUtil;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.GrabResultEntity;
import com.huawei.ism.tool.upgradeevalu.model.EvalItemResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.parser.CompatibilityXlsParser;
import com.huawei.ism.tool.upgradeevalu.service.CompatibilityExcelInfo;
import com.huawei.ism.tool.upgradeevalu.utils.CommonUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class Grab2EvalUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Grab2EvalUtils.class);
    private static final CompatibilityXlsParser C_XLS_PAR = new CompatibilityXlsParser();
    private static final String TEMP_PATH = SystemEnvUtil.getDefaultUserDir() + File.separator + "upgradeTemp";

    public static ItemInfo findDevItemInfo(List<Map<String, Object>> evalData, GrabDevNode2 devNode) {
        for (Map<String, Object> data : evalData) {
            Map deviceInfo = (Map)data.get("deviceMap");
            List itemInfos = ItDeviceType.Database.equals((Object)devNode.getItDeviceType()) ? (List)deviceInfo.get("DatabaseReport") : (List)deviceInfo.get("HostReport");
            if (itemInfos == null) continue;
            for (ItemInfo it : itemInfos) {
                if (!devNode.getDeviceSerialNumber().equals(it.getInfoGrabMetaMsg("deviceSerialNumber"))) continue;
                return it;
            }
        }
        return null;
    }

    public static List<Map<String, Object>> parseDevData4eval(Set<String> zipFils) {
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>();
        Object[] zFiles = zipFils.toArray();
        for (int i = zipFils.size() - 1; i >= 0; --i) {
            Object zipFile = zFiles[i];
            CompatibilityExcelInfo compatibilityExcelInfo = new CompatibilityExcelInfo();
            try {
                Map<String, Object> excelDevMap = compatibilityExcelInfo.getAllExcelContent(zipFile.toString());
                datas.add(excelDevMap);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("parse conbine data error0", e);
            }
        }
        return datas;
    }

    public static List<ItemInfo> getItemsInfo(GrabDevNode2 devNode, Map<String, Object> excelDevMap) {
        List itemInfos = ItDeviceType.Database.equals((Object)devNode.getItDeviceType()) ? (List)excelDevMap.get("DatabaseReport") : (List)excelDevMap.get("HostReport");
        return itemInfos;
    }

    public static EvalItemResult parseGrabResult(GrabResultEntity entity, EvalItemResult evalItemResult) throws ToolException, IOException {
        String txtFilePath = entity.getGrabResult4EvalPath();
        String excelFilePath = entity.getGrabResultExcelPath();
        GrabDevNode2 devNode = entity.getEvalNode();
        File tempFile = Grab2EvalUtils.createGrabResultTempFile();
        LinkedList<String> excelData = new LinkedList<String>();
        String creatNewExcel = Grab2EvalUtils.creatNewExcel(excelFilePath, devNode, tempFile.getCanonicalPath(), excelData);
        String copyFiletoZip = Grab2EvalUtils.copyFiletoZip(txtFilePath, excelFilePath, creatNewExcel, tempFile.getCanonicalPath());
        ItemInfo itemInfo = null;
        CompatibilityExcelInfo compatibilityExcelInfo = new CompatibilityExcelInfo();
        Map<String, Object> excelDevMap = compatibilityExcelInfo.getAllExcelContent(copyFiletoZip);
        Object devMap = excelDevMap.get("deviceMap");
        Map devResultMap = (Map)devMap;
        if (devResultMap.containsKey("HostReport")) {
            itemInfo = (ItemInfo)((List)devResultMap.get("HostReport")).get(0);
        } else if (devResultMap.containsKey("DatabaseReport")) {
            itemInfo = (ItemInfo)((List)devResultMap.get("DatabaseReport")).get(0);
        } else {
            LOGGER.error("devType not supported.");
            throw new ToolException("devType not supported.");
        }
        if (itemInfo != null) {
            itemInfo.setConbineDataList(excelData);
        }
        evalItemResult.setItemInfo(itemInfo);
        CommonUtils.deleteFile(tempFile);
        return evalItemResult;
    }

    private static File createGrabResultTempFile() throws ToolException {
        int tryTimes = 0;
        while (tryTimes++ < 5) {
            String tempfilePath = TEMP_PATH + File.separator + new Date().getTime();
            File tempFile = new File(tempfilePath);
            boolean createNewFile = tempFile.mkdirs();
            LOGGER.info("parse Grab Result tempfilePath: {}, mkdir result{}", (Object)tempfilePath, (Object)createNewFile);
            if (createNewFile) {
                return tempFile;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                LOGGER.error("create Grab Result Temp File sleep failed.");
            }
        }
        throw new ToolException("compatibility.compat.exception.parseGrabResult.failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String creatNewExcel(String excelFilePath, GrabDevNode2 devNode, String tempfilePath, List<String> excelData) {
        File oldExcelFile = new File(excelFilePath);
        String excelName = oldExcelFile.getName();
        String newExcelFilePath = FilePathUtils.checkFile((String)(tempfilePath + File.separator + excelName));
        HSSFWorkbook oldWorkbook = null;
        HSSFWorkbook newWorkbook = null;
        FileOutputStream fos = null;
        FileInputStream fis = null;
        try {
            HSSFSheet createSheet;
            fis = new FileInputStream(oldExcelFile);
            oldWorkbook = new HSSFWorkbook(fis);
            newWorkbook = new HSSFWorkbook();
            HSSFSheet hostSheet = oldWorkbook.getSheet("data");
            HSSFSheet hSSFSheet = createSheet = ItDeviceType.Host.equals((Object)devNode.getItDeviceType()) ? newWorkbook.createSheet("HostReport") : newWorkbook.createSheet("DatabaseReport");
            if (null != hostSheet) {
                Grab2EvalUtils.creatExcelDate(hostSheet, createSheet, devNode.getIp(), excelData);
            } else {
                LOGGER.error("oldWorkbook.getSheet(\"data\") is filed,hostSheet =null");
            }
            fos = new FileOutputStream(newExcelFilePath);
            newWorkbook.write(fos);
        }
        catch (Exception e) {
            try {
                LOGGER.error("Error copying new EXCEL", e);
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(fos, (InputStream)fis);
                StreamUtils.closeResource(null, oldWorkbook);
                StreamUtils.closeResource(null, newWorkbook);
                throw throwable;
            }
            StreamUtils.closeStream(fos, (InputStream)fis);
            StreamUtils.closeResource(null, (Closeable)oldWorkbook);
            StreamUtils.closeResource(null, (Closeable)newWorkbook);
        }
        StreamUtils.closeStream((OutputStream)fos, (InputStream)fis);
        StreamUtils.closeResource(null, (Closeable)oldWorkbook);
        StreamUtils.closeResource(null, (Closeable)newWorkbook);
        return newExcelFilePath;
    }

    private static List<String> creatExcelDate(Sheet hostSheet, Sheet createSheet, String devNodeIp, List<String> dataList) {
        short textDataFormat = createSheet.getWorkbook().createDataFormat().getFormat("@");
        for (int i = 0; i < 2; ++i) {
            int columns = hostSheet.getRow(i).getLastCellNum();
            Row createRow = createSheet.createRow(i);
            for (int j = 0; j < columns; ++j) {
                String valueFromCell = C_XLS_PAR.getValueFromCell(hostSheet, j, i, null);
                if (j == 0 && i == 0) {
                    Grab2EvalUtils.makeCellStyleText(createRow.createCell(j), textDataFormat).setCellValue("IP");
                } else if (j == 0 && i == 1) {
                    dataList.add(devNodeIp);
                    Grab2EvalUtils.makeCellStyleText(createRow.createCell(j), textDataFormat).setCellValue(devNodeIp);
                }
                Grab2EvalUtils.makeCellStyleText(createRow.createCell(j + 1), textDataFormat).setCellValue(valueFromCell);
                if (i != 1) continue;
                dataList.add(valueFromCell);
            }
        }
        return dataList;
    }

    private static Cell makeCellStyleText(Cell cell, short textDataFormat) {
        CellStyle cellStyle = cell.getCellStyle();
        cellStyle.setDataFormat(textDataFormat);
        cell.setCellStyle(cellStyle);
        return cell;
    }

    private static String copyFiletoZip(String txtFilePath, String excelFilePath, String creatNewExcel, String tempfilePath) {
        String zipSrcPath = FilePathUtils.checkFile((String)(tempfilePath + "zip"));
        String zipSrcPathwithTxt = FilePathUtils.checkFile((String)(zipSrcPath + File.separator + "EvalMetaData"));
        File excelSrcfile = FilePathUtils.checkFile((File)new File(creatNewExcel));
        File txtSrcfile = FilePathUtils.checkFile((File)new File(txtFilePath));
        boolean mkdirs = new File(zipSrcPathwithTxt).mkdirs();
        if (mkdirs) {
            try {
                File targetFile = new File(FilesUtil.getCanonicalPath((File)new File(zipSrcPath)) + File.separator + excelSrcfile.getName());
                StreamUtils.copyFile((File)excelSrcfile, (File)targetFile);
                File txtTargetFile = new File(FilesUtil.getCanonicalPath((File)new File(zipSrcPathwithTxt)) + File.separator + txtSrcfile.getName());
                StreamUtils.copyFile((File)txtSrcfile, (File)txtTargetFile);
            }
            catch (Exception e) {
                LOGGER.error("copy file error", e);
            }
            String zipPath = FilePathUtils.checkFile((String)(tempfilePath + File.separator + new File(zipSrcPath).getName() + ".zip"));
            ZipUtils.compressFile((String)zipPath, (String)zipSrcPath);
            CommonUtils.deleteFile(new File(zipSrcPath));
            return zipPath;
        }
        return null;
    }
}

