/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.util;

import com.huawei.ism.connection.TLVConnection;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.wizardparse.factory.ConnectorFactory;
import com.huawei.ism.tool.bizpack.wizardparse.factory.SshConnector;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IConnectionManage;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.DeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.User;
import com.huawei.ism.tool.framework.pubservice.exception.ConnectionException;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.utils.Base64EncodeUtils;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HVSDevUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HVSDevUtils.class);
    private static final int SSH_PORT = 22;
    private static List<DevNode> nodeList = new ArrayList<DevNode>();
    private static boolean hasNewDevEnv = false;

    private HVSDevUtils() {
    }

    public static List<DevNode> getDevFromEnv() {
        if (!nodeList.isEmpty()) {
            return nodeList;
        }
        String devVar = "jsonDevEncode_1";
        String devInfo = System.getenv(devVar);
        if (null == devInfo) {
            HVSDevUtils.loadDevsFromEnv();
        } else {
            LOGGER.info(String.format(Locale.ENGLISH, "================================== this is new mode, \njsonDevEncode_1=%s", StringUtils.getCleanMessage((String)System.getenv("jsonDevEncode_1"))));
            HVSDevUtils.loadDevsFromEnvNew();
        }
        return nodeList;
    }

    private static void loadDevsFromEnv() {
        int i = 0;
        String devVar = "toolDev_";
        String devInfo = System.getenv(devVar + ++i);
        while (!StringUtils.isNULLStr((String)devInfo)) {
            if (!HVSDevUtils.parseAndSaveDev(devInfo)) {
                LOGGER.warn("devInfo parse failed.{}", (Object)StringUtils.getCleanMessage((String)devInfo));
                break;
            }
            devInfo = System.getenv(devVar + ++i);
        }
    }

    private static boolean parseAndSaveDev(String devInfo) {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        for (String attr : devInfo.split(";; ")) {
            int i = attr.indexOf(58);
            if (i < 0 || i > attr.length()) continue;
            attrMap.put(attr.substring(0, i), attr.substring(i + 1));
        }
        String devIp = (String)attrMap.get("devIp");
        LOGGER.info(String.format(Locale.ENGLISH, "env's devIp=%s", StringUtils.getCleanMessage((String)devIp)));
        EvaluContext.getInstance().setSvpIp(devIp);
        String devType = (String)attrMap.get("devType");
        String devVersion = (String)attrMap.get("devVersion");
        String devName = (String)attrMap.get("devName");
        String username = (String)attrMap.get("username");
        String password = (String)attrMap.get("password");
        String serialNo = (String)attrMap.get("serialNo");
        String devInnerIp = (String)attrMap.get("devInnerIp");
        String ipListAreInnerIp = (String)attrMap.get("ipListAreInnerIp");
        if (null == devIp || null == devType || null == username || null == password) {
            return false;
        }
        DeviceType type = DeviceType.ALL;
        try {
            type = DeviceType.valueOf((String)devType);
        }
        catch (Exception e) {
            LOGGER.error("Invalid device type: " + devType, e);
        }
        DevNode node = new DevNode();
        HVSDevUtils.setDevNode(devIp, devVersion, devName, username, password, devInnerIp, ipListAreInnerIp, type, node);
        if (null == serialNo || serialNo.trim().isEmpty()) {
            IConnectionManage connMag = (IConnectionManage)PublicServiceManage.getInstance().getService(IConnectionManage.class);
            if (null == connMag) {
                return false;
            }
            try {
                TLVConnection conn = (TLVConnection)connMag.tlvLogin(node);
                serialNo = conn.getDeviceID();
            }
            catch (ConnectionException e) {
                LOGGER.error("Login device is failed!", e);
            }
        }
        node.setDeviceSerialNumber(serialNo);
        nodeList.add(node);
        return true;
    }

    private static void setDevNode(String devIp, String devVersion, String devName, String username, String password, String devInnerIp, String ipListAreInnerIp, DeviceType type, DevNode node) {
        node.setIp(devIp);
        node.setLoginUser(new User(username, password));
        node.setDeviceType(type);
        node.setDeviceName(devName);
        node.setProductVersion(devVersion);
        if (!StringUtils.isNULLStr((String)ipListAreInnerIp)) {
            node.setIpListAreInnerIp(Boolean.valueOf(ipListAreInnerIp).booleanValue());
        }
        String[] ipList = devInnerIp.split(",");
        HVSDevUtils.setCurrIp(username, password, node, ipList);
        HVSDevUtils.addNodeIp(node, ipList);
    }

    private static void setCurrIp(String username, String password, DevNode node, String[] ipList) {
        String currIp = HVSDevUtils.tryInnerIpArray(ipList, new User(username, password), 22);
        if (null != currIp) {
            EvaluContext.getInstance().setResetIP(true);
            node.setIp(currIp);
        }
    }

    private static void addNodeIp(DevNode node, String[] ipList) {
        for (String ip : ipList) {
            if (StringUtils.isNULLStr((String)ip)) continue;
            node.addIp(ip);
        }
    }

    public static void loadDevsFromEnvNew() {
        int i = 0;
        String devVar = hasNewDevEnv ? "jsonDevEncodeNew_" : "jsonDevEncode_";
        String devInfo = System.getenv(devVar + ++i);
        LOGGER.info(String.format(Locale.ENGLISH, "devInfoNew=%s", StringUtils.getCleanMessage((String)devInfo)));
        while (!StringUtils.isNULLStr((String)devInfo)) {
            if (!HVSDevUtils.parseAndSaveDevNew(devInfo)) {
                LOGGER.warn("devInfoNew parse failed." + StringUtils.getCleanMessage((String)devInfo));
                break;
            }
            devInfo = System.getenv(devVar + ++i);
        }
    }

    private static boolean parseAndSaveDevNew(String devInfo) {
        try {
            JSONObject jsonObject = new JSONObject(devInfo);
            DevNode devNode = new DevNode();
            User user = HVSDevUtils.setDevNodeData(jsonObject, devNode);
            JSONArray ipList = jsonObject.getJSONArray("devInnerIps");
            String currIp = HVSDevUtils.tryInnerIpJson(ipList, user, devNode.getPort());
            if (null != currIp) {
                EvaluContext.getInstance().setResetIP(true);
                devNode.setIp(currIp);
            }
            for (int j = 0; j < ipList.length(); ++j) {
                String ip = ipList.getString(j);
                devNode.addIp(ip);
            }
            String serialNo = jsonObject.getString("serialNo");
            if (null == serialNo || serialNo.trim().isEmpty()) {
                IConnectionManage connMag = (IConnectionManage)PublicServiceManage.getInstance().getService(IConnectionManage.class);
                if (null == connMag) {
                    return false;
                }
                try {
                    TLVConnection conn = (TLVConnection)connMag.tlvLogin(devNode);
                    serialNo = conn.getDeviceID();
                }
                catch (ConnectionException e) {
                    LOGGER.error("Login device is failed!", e);
                }
            }
            devNode.setDeviceSerialNumber(serialNo);
            LOGGER.info(String.format(Locale.ENGLISH, "new ==================devNode=%s", devNode));
            nodeList.add(devNode);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(HVSDevUtils.class).error("addNOde Error : ", e);
        }
        return true;
    }

    private static User setDevNodeData(JSONObject jsonObject, DevNode devNode) {
        devNode.setIp(jsonObject.getString("devIp"));
        EvaluContext.getInstance().setSvpIp(jsonObject.getString("devIp"));
        devNode.setDeviceType(DeviceType.valueOf((String)jsonObject.getString("devType")));
        devNode.setProductVersion(jsonObject.getString("devVersion"));
        if (jsonObject.has("remoteSNs")) {
            ArrayList<String> remoteSNs = new ArrayList<String>();
            JSONArray remoteSNArray = jsonObject.getJSONArray("remoteSNs");
            for (int i = 0; i < remoteSNArray.length(); ++i) {
                String remoteSn = remoteSNArray.getString(i);
                remoteSNs.add(remoteSn);
            }
            devNode.setRemoteSNs(remoteSNs);
        }
        try {
            devNode.setPort(jsonObject.getInt("port"));
            devNode.setHighDevSVPModuleInfo(jsonObject.getString("highDevSVPModuleInfo"));
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(HVSDevUtils.class).error("Toolkit Frame is old", e);
            devNode.setPort(22);
        }
        devNode.setDeviceName(HVSDevUtils.decodeByBase64(jsonObject.getString("devName")));
        devNode.setDeviceSerialNumber(jsonObject.getString("serialNo"));
        devNode.setDeveloperPwd(AESEncrypt.decrypt((String)jsonObject.getString("developerPwd")));
        User user = new User(HVSDevUtils.decodeByBase64(jsonObject.getString("username")), AESEncrypt.decrypt((String)jsonObject.getString("password")));
        devNode.setLoginUser(user);
        if (jsonObject.has("ipListAreInnerIp")) {
            String ipListAreInnerIp = jsonObject.getString("ipListAreInnerIp");
            devNode.setIpListAreInnerIp(Boolean.valueOf(ipListAreInnerIp).booleanValue());
        }
        return user;
    }

    private static String decodeByBase64(String code) {
        if (hasNewDevEnv) {
            return Base64EncodeUtils.decodeNew((String)code);
        }
        return Base64EncodeUtils.decode((String)code);
    }

    private static String tryInnerIpArray(String[] ipList, User user, int port) {
        ConnectorFactory connFactory = ConnectorFactory.getInstance();
        for (String ip : ipList) {
            try {
                SshConnector creator = connFactory.createSshConnector(ip, port, user.getUserName(), user.getPassword());
                SshConnection sshCon = creator.getConnection();
                if (null == sshCon) continue;
                return ip;
            }
            catch (ToolException e) {
                LOGGER.warn("old mode create ssh error.", e);
            }
        }
        return null;
    }

    private static String tryInnerIpJson(JSONArray ipList, User user, int port) {
        ConnectorFactory connFactory = ConnectorFactory.getInstance();
        for (int j = 0; j < ipList.length(); ++j) {
            try {
                String ip = ipList.getString(j);
                SshConnector creator = connFactory.createSshConnector(ip, port, user.getUserName(), user.getPassword());
                SshConnection sshCon = creator.getConnection();
                if (null == sshCon) continue;
                return ip;
            }
            catch (ToolException e) {
                LOGGER.warn("new mode create ssh error.", e);
            }
        }
        return null;
    }

    static {
        try {
            if (!StringUtils.isNULLStr((String)System.getenv("newDev"))) {
                LOGGER.info("newDev exist in envirement.");
                hasNewDevEnv = true;
            }
            LOGGER.info(String.format(Locale.ENGLISH, "hasNewDevEnv=%s", hasNewDevEnv));
        }
        catch (RuntimeException e) {
            LOGGER.error("get newDev exception.", e);
        }
    }
}

