/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.util;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.common.data.DataType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HostEvalDbIndexPorperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostEvalDbIndexPorperties.class);
    private static final String PROPATH = DataType.applicationCfg.getDirName() + File.separator;
    private static final String FILENAMEPRO = "db_index_collect.properties";
    private static final String TASKKEY = "isFirstStartUp";
    private static final String COMMENT = "flag";

    public static synchronized Map<String, String> getProperty() {
        Properties properties = HostEvalDbIndexPorperties.getDbIndexProperties();
        Enumeration<?> list = properties.propertyNames();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        while (list.hasMoreElements()) {
            String indexName = (String)list.nextElement();
            String fileName = properties.getProperty(indexName);
            dataMap.put(indexName, fileName);
        }
        return dataMap;
    }

    private static Properties getDbIndexProperties() {
        Properties proper = new Properties();
        FileInputStream fileInput = null;
        try {
            File file = new File(PROPATH + FILENAMEPRO);
            if (file.exists()) {
                fileInput = new FileInputStream(file);
                proper.load(fileInput);
            }
        }
        catch (IOException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("get taskNumber is error");
            }
        }
        finally {
            StreamUtils.closeStream(null, fileInput);
        }
        return proper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setProperty(String value) {
        Properties properties = new Properties();
        FileOutputStream fileOut = null;
        FileInputStream fileIn = null;
        try {
            File file = new File(PROPATH + FILENAMEPRO);
            fileIn = new FileInputStream(file);
            properties.load(fileIn);
            properties.setProperty(TASKKEY, value);
            fileOut = new FileOutputStream(file);
            properties.store(fileOut, COMMENT);
            StreamUtils.closeStream((OutputStream)fileOut, (InputStream)fileIn);
        }
        catch (IOException e) {
            LOGGER.error("set flag is error!");
        }
        finally {
            StreamUtils.closeStream(fileOut, fileIn);
        }
    }
}

