/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.util;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SHA256Check;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.SystemEnvUtil;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.infograb.entity.GrabResultEntity;
import com.huawei.ism.tool.obase.entity.ListCellEntity;
import com.huawei.ism.tool.obase.entity.StorageInfo;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.excel.POIUtils;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.enums.TaskStatusEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalItemResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalTaskResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.service.StorInfoProgressUpdater;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalContext;
import com.huawei.ism.tool.upgradeevalu.util.StorageInfoQryTask;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.swing.JLabel;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import utils.FilesUtil;

public abstract class HostEvalUtils {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(HostEvalUtils.class);
    private static final int ERROR_INDEX = -1;

    public static boolean excuteVerify(InputStream excelFile, InputStream signFile) throws IOException {
        String shaVerifyCode = StreamUtils.readStringFormInputStream((InputStream)signFile);
        if (StringUtils.isNULLStr((String)shaVerifyCode)) {
            return false;
        }
        shaVerifyCode = shaVerifyCode.substring(0, 192);
        String fileHash = SHA256Check.getInstance().getShaCode(excelFile);
        return fileHash.equals(shaVerifyCode);
    }

    public static boolean isHostCanEval(EvalItemResult evalItemResult) {
        ItemInfo ii = evalItemResult.getItemInfo();
        ItDeviceType idt = ii.getDeviceType();
        String osName = ii.getOsName();
        return ItDeviceType.Host.equals((Object)idt) && (osName == null || !osName.contains("SUSE"));
    }

    public static String getHelpFilePath() {
        String workDir = SystemEnvUtil.getDefaultUserDir();
        File helpFilePath = new File(workDir, "help");
        return FilesUtil.getCanonicalPath((File)helpFilePath) + File.separator;
    }

    public static Map<String, String> getHelpKeys(String key) {
        HashMap<String, String> helpKeys = new HashMap<String, String>();
        try {
            if (StringUtils.isNULLStr((String)key)) {
                return helpKeys;
            }
            String[] vals = key.split("\\{");
            if (vals.length >= 2) {
                String keyString = vals[0].trim();
                String urlString = vals[1].trim();
                int urlLen = urlString.length();
                urlString = urlString.substring(0, urlLen - 1);
                helpKeys.put(keyString, urlString);
            }
        }
        catch (RuntimeException e) {
            ToolLoggerFactory.getLogger(HostEvalUtils.class).error("HostEval get help key error!", e);
        }
        return helpKeys;
    }

    public static String replaceKeysByMap(String value, String path, Map<String, String> helpKeys) {
        String tmp = value;
        for (Map.Entry<String, String> entry : helpKeys.entrySet()) {
            String hValue = entry.getValue();
            String hKey = entry.getKey();
            tmp = HostEvalUtils.replaceKeys(tmp, path, hValue, hKey);
        }
        return tmp;
    }

    public static String replaceKeys(String value, String path, String helpUrl, String placeHolder, String showCaseName) {
        if (path == null) {
            path = HostEvalUtils.getHelpFilePath();
        }
        StringBuffer tmp = new StringBuffer();
        if (!StringUtils.hasNULLStr((String[])new String[]{value, helpUrl, placeHolder, showCaseName})) {
            path = path.replaceAll("\\\\", "/");
            helpUrl = helpUrl.replaceAll("\\\\", "/");
            helpUrl = helpUrl.replaceAll("//", "/");
            StringBuffer replaceBuffer = HostEvalUtils.makeLink(path, helpUrl, showCaseName);
            int keyLoc = value.indexOf(placeHolder);
            String sum = value.substring(0, keyLoc + placeHolder.length());
            String targetString = sum.replace(placeHolder, replaceBuffer.toString());
            tmp.append(targetString);
            value = value.substring(keyLoc + placeHolder.length());
            tmp.append(value);
            return tmp.toString();
        }
        return tmp.toString();
    }

    public static String replaceKeys(String value, String path, String helpUrl, String helpKey) {
        StringBuffer tmp = new StringBuffer();
        if (!StringUtils.hasNULLStr((String[])new String[]{value, path, helpUrl, helpKey})) {
            path = path.replaceAll("\\\\", "/");
            StringBuffer replaceBuffer = HostEvalUtils.makeLink(path, helpUrl, helpKey);
            int keyLoc = value.indexOf(helpKey);
            String sum = value.substring(0, keyLoc + helpKey.length());
            String targetString = sum.replaceFirst(helpKey, replaceBuffer.toString());
            tmp.append(targetString);
            value = value.replace(sum, "");
            tmp.append(value);
            return tmp.toString();
        }
        return tmp.toString();
    }

    public static StringBuffer makeLink(String path, String helpUrl, String helpKey) {
        StringBuffer replaceBuffer = new StringBuffer();
        helpUrl = path + helpUrl;
        replaceBuffer.append("<a class=\"link\" href=\"").append(helpUrl).append("\" target=\"_blank\">").append(helpKey).append("</a>");
        return replaceBuffer;
    }

    public static int getColIndexFromSheet(Sheet sheet, String currentLanguageValue, String againstLanguageValue) {
        int rows = sheet.getLastRowNum() + 1;
        if (1 < rows) {
            Row row = sheet.getRow(0);
            int colNum = row.getLastCellNum();
            for (int c = 0; c < colNum; ++c) {
                String content = POIUtils.getStringCellValue((Cell)row.getCell(c));
                if (!currentLanguageValue.equals(content) && !againstLanguageValue.equals(content)) continue;
                return c;
            }
        }
        return -1;
    }

    public static void buildLabelWithWidth(JLabel label, int width) {
        String desc = label.getText();
        FontMetrics fontMetrics = label.getFontMetrics(label.getFont());
        String[] descTemp = desc.split("(?i)<br>|<p>");
        int height = 0;
        for (String descLine : descTemp) {
            int total = fontMetrics.stringWidth(descLine);
            height += (total / width + 1) * (label.getFont().getSize() + 6);
        }
        label.setPreferredSize(new Dimension(width, height));
        label.setText("<html>" + desc + "</html>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<StorageInfo> getStorageInfoList() {
        List nodeList = DefaultNodeProviderImpl.getInstance().getNodeList();
        if (nodeList.isEmpty()) {
            return new ArrayList<StorageInfo>();
        }
        ArrayList<StorageInfo> storageInfoList = new ArrayList<StorageInfo>();
        ArrayList<Future<StorageInfo>> results = new ArrayList<Future<StorageInfo>>();
        HostEvalUtils.addQueryTip("eval.ui.start.load.storage.info.start", null);
        try {
            for (com.huawei.ism.tool.obase.entity.DevNode devNode : nodeList) {
                if (!ItDeviceType.Storage.equals((Object)devNode.getItDeviceType())) continue;
                StorInfoProgressUpdater callback = new StorInfoProgressUpdater(devNode);
                StorageInfoQryTask task = new StorageInfoQryTask(devNode, callback);
                results.add(AsyncExcutor.submit((Callable)task));
            }
            HostEvalUtils.fillResult(storageInfoList, results);
        }
        finally {
            HostEvalUtils.addQueryTip("eval.ui.start.load.storage.info.end", "eval.ui.start.load.storage.info.start");
        }
        HostEvalContext.getStorageMap().put("storageInfo", storageInfoList);
        return storageInfoList;
    }

    public static void addQueryTip(String qryTip, String rmvKey) {
        Map<String, EvalTaskResult> resultMap = HostEvalContext.getHostRvalResult();
        for (Map.Entry<String, EvalTaskResult> entry : resultMap.entrySet()) {
            ListCellEntity entity = new ListCellEntity();
            entity.setMessageTip(ResourceUtil.getString((String)qryTip));
            entity.setShowSingleTip(true);
            entry.getValue().getEvalDetailListHead().add((ListCellEntity<ItemResultEnum>)entity);
            if (rmvKey == null) continue;
            entity = new ListCellEntity();
            entity.setMessageTip(ResourceUtil.getString((String)rmvKey));
            entity.setShowSingleTip(true);
            entry.getValue().getEvalDetailListHead().remove(entity);
        }
    }

    public static void fillResult(ArrayList<StorageInfo> storageInfoList, List<Future<StorageInfo>> results) {
        for (Future<StorageInfo> result : results) {
            try {
                if (result == null) continue;
                storageInfoList.add(result.get());
            }
            catch (Exception e) {
                LOGGER.error("get resukt error", e);
            }
        }
    }

    public static void handleTaskStatus(EvalTaskResult taskResult) {
        if (!taskResult.isCheckFile()) {
            taskResult.setTaskStatus(TaskStatusEnum.EVALUATION_STOP);
            return;
        }
        if (TaskStatusEnum.EVALUATION_STOP.equals((Object)taskResult.getTaskStatus())) {
            return;
        }
        int countNotPass = 0;
        int countNotEval = 0;
        int countOptimRecomd = 0;
        int countPass = 0;
        for (EvalItemResult evalItemResult : taskResult.getEvalItemList()) {
            if (evalItemResult.getItemResultEnum() == ItemResultEnum.NOTPASS) {
                ++countNotPass;
                continue;
            }
            if (evalItemResult.getItemResultEnum() == ItemResultEnum.CANNOTEVAL || evalItemResult.getItemResultEnum() == ItemResultEnum.EVALUATION_STOP) {
                ++countNotEval;
                continue;
            }
            if (evalItemResult.getItemResultEnum() == ItemResultEnum.OPTIM_RECOMD) {
                ++countOptimRecomd;
                continue;
            }
            if (evalItemResult.getItemResultEnum() != ItemResultEnum.PASS) continue;
            ++countPass;
        }
        if (countPass == taskResult.getEvalItemList().size()) {
            taskResult.setTaskStatus(TaskStatusEnum.EVALUATION_PASS);
            return;
        }
        if (countNotPass > 0) {
            taskResult.setTaskStatus(TaskStatusEnum.EVALUATION_NOTPASS);
        } else if (countNotEval > 0) {
            taskResult.setTaskStatus(TaskStatusEnum.EVALUATION_CAN_NOTEVAL);
        } else if (countOptimRecomd > 0) {
            taskResult.setTaskStatus(TaskStatusEnum.OPTIM_RECOMD);
        } else {
            taskResult.setTaskStatus(TaskStatusEnum.EVALUATION_CAN_NOTEVAL);
        }
    }

    public static EvalItemResult findEvalItemResult(GrabResultEntity entity, EvalTaskResult taskResult) {
        return HostEvalUtils.findEvalItemResult(entity.getEvalNode(), taskResult);
    }

    public static EvalItemResult findEvalItemResult(DevNode evalDevNode, EvalTaskResult taskResult) {
        for (EvalItemResult evalItemResult : taskResult.getEvalItemList()) {
            if (!evalDevNode.getDeviceSerialNumber().equalsIgnoreCase(evalItemResult.getEvalDevNode().getDeviceSerialNumber()) || !evalDevNode.getDevKey().equalsIgnoreCase(evalItemResult.getEvalDevNode().getDevKey())) continue;
            return evalItemResult;
        }
        LOGGER.error("cannot find evalitemResult:" + evalDevNode.getDevKey());
        throw new NullPointerException("cannot find evalitemResult:" + evalDevNode.getDevKey());
    }

    public static void countHostNumber(Integer size, String sizeKey) {
        Integer currentSize = HostEvalContext.getHostNumberMap().get(sizeKey);
        currentSize = null != currentSize ? Integer.valueOf(currentSize + size) : size;
        HostEvalContext.getHostNumberMap().put(sizeKey, currentSize);
    }

    public static boolean isTaskEnd(ItemResultEnum itemResultEnum) {
        return ItemResultEnum.PASS.equals((Object)itemResultEnum) || ItemResultEnum.NOTPASS.equals((Object)itemResultEnum) || ItemResultEnum.CANNOTEVAL.equals((Object)itemResultEnum) || ItemResultEnum.EVALUATION_STOP.equals((Object)itemResultEnum);
    }

    public static boolean isTaskEnd(TaskStatusEnum taskStatusEnum) {
        return TaskStatusEnum.EVALUATION_PASS.equals((Object)taskStatusEnum) || TaskStatusEnum.EVALUATION_NOTPASS.equals((Object)taskStatusEnum) || TaskStatusEnum.EVALUATION_CAN_NOTEVAL.equals((Object)taskStatusEnum) || TaskStatusEnum.EVALUATION_STOP.equals((Object)taskStatusEnum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static <T> List<T> copyDeeplyList(List<T> srcList) {
        ByteArrayOutputStream byteOut = null;
        ObjectOutputStream out = null;
        ObjectInputStream in = null;
        List destList = null;
        try {
            byteOut = new ByteArrayOutputStream();
            out = new ObjectOutputStream(byteOut);
            out.writeObject(srcList);
            ByteArrayInputStream byteInput = new ByteArrayInputStream(byteOut.toByteArray());
            in = new ObjectInputStream(byteInput);
            destList = (List)in.readObject();
        }
        catch (IOException e) {
            LOGGER.error("***[copy deeply list IO error]***", e);
            StreamUtils.closeStream((OutputStream)out, in);
        }
        catch (ClassNotFoundException e2) {
            LOGGER.error("***[copy deeply list class not found error]***", e2);
            {
                catch (Throwable throwable) {
                    StreamUtils.closeStream(out, in);
                    throw throwable;
                }
            }
            StreamUtils.closeStream((OutputStream)out, in);
        }
        StreamUtils.closeStream((OutputStream)out, (InputStream)in);
        return destList;
    }

    public static boolean checkStroageNeedAddOracle() {
        List allDevNodes = DefaultNodeProviderImpl.getInstance().getNodeList();
        for (com.huawei.ism.tool.obase.entity.DevNode devNode : allDevNodes) {
            String deviceType = devNode.getDeviceType().toString();
            if (deviceType.toLowerCase(Locale.ENGLISH).contains("dorado") || devNode.getProductVersion().compareToIgnoreCase("V300R003C00") >= 0) continue;
            HostEvalContext.setNeedAddOracleDatabase(true);
            return true;
        }
        HostEvalContext.setNeedAddOracleDatabase(true);
        return true;
    }

    public static List<String> removeDuplicateWithOrder(List<String> lists) {
        HashSet<String> hashSet = new HashSet<String>(lists);
        lists.clear();
        lists.addAll(hashSet);
        Collections.sort(lists);
        return lists;
    }
}

