/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.util;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.OemUtils;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class HtmlResUtils {
    private static final String HTMLLANGUAGERESOURCE = "config/upgradeevalu/html/htmlresource";

    private HtmlResUtils() {
    }

    public static String getString(String key) {
        ResourceBundle resource = ResourceBundle.getBundle(HTMLLANGUAGERESOURCE, EvaluContext.getInstance().getLoc());
        String value = null;
        try {
            value = resource.getString(key);
        }
        catch (MissingResourceException e) {
            ToolLoggerFactory.getLogger(ResourceUtil.class).error("Can not find resource:" + key);
        }
        return null == value ? "--" : value;
    }

    public static String getStringWithParam(String key, Object ... param) {
        String msg = HtmlResUtils.getString(key);
        return StringUtils.fillValues((String)msg, (Object[])param);
    }

    public static String getOEMString(String key) {
        return HtmlResUtils.getString(key + "." + OemUtils.getVender().toLowerCase(Locale.ENGLISH));
    }
}

