/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.util;

import com.huawei.ism.tool.base.utils.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ItemProgressUpdateUtil {
    public static final ItemProgressUpdateUtil INS = new ItemProgressUpdateUtil();
    private Map<String, ProgressHolder> data = new ConcurrentHashMap<String, ProgressHolder>();

    private ItemProgressUpdateUtil() {
    }

    public void clear(String devId) {
        this.setProgress(devId, -1, "");
    }

    public void setProgress(String devId, int progress, String timeLeft) {
        if (StringUtils.isNULLStr((String)devId)) {
            return;
        }
        ProgressHolder holder = this.data.get(devId);
        if (null == holder) {
            this.data.put(devId, new ProgressHolder(progress, timeLeft));
        } else {
            holder.setProgress(progress);
            holder.setTimeLeft(timeLeft);
        }
    }

    public int getProgress(String devId) {
        if (StringUtils.isNULLStr((String)devId)) {
            return -1;
        }
        ProgressHolder holder = this.data.get(devId);
        if (holder == null) {
            return -1;
        }
        return holder.getProgress();
    }

    public String getTimeLeft(String devId) {
        if (StringUtils.isNULLStr((String)devId)) {
            return "";
        }
        ProgressHolder holder = this.data.get(devId);
        if (null == holder || StringUtils.isNULLStr((String)holder.getTimeLeft())) {
            return "";
        }
        return holder.getTimeLeft();
    }

    private static class ProgressHolder {
        private static final int MAX = 100;
        private static final int MIN = -1;
        private int progress = -1;
        private String timeLeft = "";

        public ProgressHolder(int progress, String timeLeft) {
            this.setProgress(progress);
            this.setTimeLeft(timeLeft);
        }

        public int getProgress() {
            return this.progress;
        }

        public void setProgress(int progress) {
            this.progress = Math.min(100, Math.max(-1, progress));
        }

        public String getTimeLeft() {
            return this.timeLeft;
        }

        public void setTimeLeft(String timeLeft) {
            this.timeLeft = timeLeft == null ? this.timeLeft : timeLeft;
        }
    }
}

