/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.util;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.upgradeevalu.util.FileAssistant;
import com.huawei.ism.tool.upgradeevalu.util.FileUtil;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PackageUtils.class);
    private static final String HELP_CASE = "helpCase";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deCompressPackage(String packagePath, String[] pwds) {
        Class<FileAssistant> clazz = FileAssistant.class;
        synchronized (FileAssistant.class) {
            File originalFile = new File(packagePath);
            if (!originalFile.exists()) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return "";
            }
            String dir = originalFile.getName();
            String collectPath = originalFile.getParent() + File.separator + dir.substring(0, dir.lastIndexOf("."));
            File dataCollectFile = new File(collectPath);
            if (!dataCollectFile.exists() && !dataCollectFile.mkdir()) {
                LOGGER.error("Create dir error.file path: " + collectPath);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return "";
            }
            FileAssistant.deCopmressTotalZipFile(collectPath, packagePath, pwds);
            this.deCompressAllFilesRecu(dataCollectFile, pwds);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return collectPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compressPackage(String collectPath) {
        Class<FileAssistant> clazz = FileAssistant.class;
        synchronized (FileAssistant.class) {
            File file = new File(collectPath);
            if (!file.exists()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return "";
            }
            String z7ResultFile = collectPath + ".7z";
            FileAssistant.compressFile7z(z7ResultFile, collectPath);
            File z7Result = new File(z7ResultFile);
            if (z7Result.exists()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return z7Result.getName();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return "";
        }
    }

    private void deCompressAllFilesRecu(File dataCollectFile, String[] pwds) {
        File[] files = dataCollectFile.listFiles();
        if (null == files || 0 == files.length) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) continue;
            this.validAndDeCompress(file, pwds);
        }
        files = dataCollectFile.listFiles();
        if (null == files || 0 == files.length) {
            return;
        }
        for (File file : files) {
            if (!file.isDirectory()) continue;
            this.deCompressAllFilesRecu(file, pwds);
        }
    }

    private void validAndDeCompress(File tarFilePath, String[] pwds) {
        String suffix = FilePathUtils.getCanonicalPath((File)tarFilePath);
        if (suffix.endsWith(".tar.bz2")) {
            FileAssistant.deCompressTarbz2File(tarFilePath.getParent(), suffix);
            if (!FileAssistant.delFile(suffix)) {
                LOGGER.error("Delete zip file error.Dir path : " + tarFilePath.getName());
            }
        } else if (suffix.endsWith(".tgz") || suffix.endsWith(".zip") || suffix.endsWith(".rar") || suffix.endsWith(".bz2") || suffix.endsWith(".tar")) {
            this.deCompressFile(tarFilePath, pwds);
        }
    }

    private void deCompressFile(File tarFilePath, String[] pwds) {
        String tmpFileStr;
        if (null == tarFilePath) {
            return;
        }
        String dir = tarFilePath.getName();
        String collectPath = tarFilePath.getParent() + File.separator + dir.substring(0, dir.lastIndexOf("."));
        File tmpFile = null;
        if (FilePathUtils.getCanonicalPath((File)tarFilePath).endsWith(".tgz") && !(tmpFile = new File(tmpFileStr = collectPath + "_tmp")).exists() && !tmpFile.mkdir()) {
            LOGGER.error("Create dir error.file path: " + collectPath);
            return;
        }
        File dataCollectFile = new File(collectPath);
        if (!dataCollectFile.exists() && !dataCollectFile.mkdir()) {
            LOGGER.error("Create dir error.file path: " + collectPath);
            return;
        }
        if (tmpFile != null) {
            this.deCopmressTmpFile(tarFilePath, pwds, collectPath, tmpFile);
        } else {
            FileAssistant.deCopmressTotalZipFile(collectPath, FileUtil.getCanonicalPath(tarFilePath), pwds);
        }
        boolean succ = false;
        try {
            succ = tarFilePath.delete();
        }
        catch (Exception e) {
            LOGGER.error("delete File error", e);
        }
        if (!succ) {
            LOGGER.error("Delete file " + tarFilePath.getName() + " error");
        }
    }

    private void deCopmressTmpFile(File tarFilePath, String[] pwds, String collectPath, File tmpFile) {
        if (null == tmpFile) {
            return;
        }
        FileAssistant.deCopmressTotalZipFile(FileUtil.getCanonicalPath(tmpFile), FileUtil.getCanonicalPath(tarFilePath), pwds);
        File[] files = tmpFile.listFiles();
        if (null == files || 0 == files.length) {
            return;
        }
        if (1 == files.length) {
            String fileName = files[0].getName();
            if (!files[0].isDirectory() && tarFilePath.getName().contains(fileName.substring(0, fileName.lastIndexOf(".")))) {
                FileAssistant.deCopmressTotalZipFile(collectPath, FileUtil.getCanonicalPath(files[0]), pwds);
                if (!files[0].delete()) {
                    LOGGER.error("Delete file " + files[0].getName() + " error");
                }
            } else {
                FileUtils.copyDir((String)FileUtil.getCanonicalPath(tmpFile), (String)collectPath);
                FileUtils.deleteAllInFolder((String)FileUtil.getCanonicalPath(tmpFile));
            }
        } else {
            FileUtils.copyDir((String)FileUtil.getCanonicalPath(tmpFile), (String)collectPath);
            FileUtils.deleteAllInFolder((String)FileUtil.getCanonicalPath(tmpFile));
        }
        boolean succ = false;
        try {
            succ = tmpFile.delete();
        }
        catch (Exception e) {
            LOGGER.error("delete File error", e);
        }
        if (!succ) {
            LOGGER.error("Delete file " + tmpFile.getName() + " error");
        }
    }

    public static void deCompressResourceFile(String scriptPath, boolean isDel) {
        try {
            File resourceZip;
            String resourcePath = scriptPath + File.separator + HELP_CASE;
            File resourceFile = new File(resourcePath);
            if (isDel && resourceFile.exists()) {
                FileAssistant.delFile(resourcePath);
            }
            if (!resourceFile.exists() && (resourceZip = new File(resourcePath + ".zip")).exists()) {
                FileAssistant.unZip(resourcePath, FileUtil.getCanonicalPath(resourceZip));
            }
        }
        catch (Exception e) {
            LOGGER.error("decompression helpCase.zip error", e);
        }
    }
}

