/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.util;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.upgradeevalu.config.ProductParser;
import com.huawei.ism.tool.upgradeevalu.entity.CrossVersionType;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import com.huawei.ism.tool.upgradeevalu.entity.ProductCfg;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluService;
import com.huawei.ism.tool.upgradeevalu.evalu.PythonEngine;
import com.huawei.ism.tool.upgradeevalu.exception.JythonException;
import com.huawei.ism.tool.upgradeevalu.util.EvaluContext;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;

public class QueryContainerVersion {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(QueryContainerVersion.class);

    public static List<EvaluDevNode> query(List<EvaluDevNode> devNodes) {
        List fsList = AsyncExcutor.execute((Window)EvaluContext.getInstance().getWizDialog(), (Callable[])new Callable[]{() -> QueryContainerVersion.queryInner(devNodes)});
        return (List)fsList.get(0);
    }

    private static List<EvaluDevNode> queryInner(List<EvaluDevNode> devNodes) {
        ArrayList<Future<EvaluDevNode>> allQueryFus = new ArrayList<Future<EvaluDevNode>>();
        devNodes.forEach(node -> {
            try {
                Future future = ThreadPoolManager.getInstance().submit((Callable)new QueryDevVersion((EvaluDevNode)((Object)node)));
                allQueryFus.add(future);
            }
            catch (Exception exception) {
                LOGGER.error("Node {} get upgrade product failed:", (Object)node.getIp(), (Object)exception);
            }
        });
        return QueryContainerVersion.checkQueryResult(allQueryFus);
    }

    private static List<EvaluDevNode> checkQueryResult(List<Future<EvaluDevNode>> allQueryFus) {
        ArrayList<EvaluDevNode> failedDevs = new ArrayList<EvaluDevNode>();
        for (Future<EvaluDevNode> future : allQueryFus) {
            try {
                EvaluDevNode dev = future.get();
                if (dev == null) continue;
                failedDevs.add(dev);
            }
            catch (Exception e) {
                LOGGER.error("wait query dev version error!!!", e);
            }
        }
        return failedDevs;
    }

    private static class QueryDevVersion
    implements Callable<EvaluDevNode> {
        private static final String GET_CONTAINER_VERSION = "getContainerVersion.py";
        private static final String COMMON = "common";
        private EvaluDevNode dev;
        private Map<String, Object> dic;
        private PythonEngine pyEngine;

        public QueryDevVersion(EvaluDevNode devNode) {
            this.dev = devNode;
        }

        @Override
        public EvaluDevNode call() {
            try {
                this.dic = EvaluService.getInstance().createPYDic(this.dev, true);
                this.dic.put("upgradeMode", (Object)this.dev.getUpgradeMode());
                this.dic.put("evaluDev", (Object)this.dev);
                List<File> clssPath = this.dev.getClssPath();
                clssPath.add(ProductParser.getCommonPackagePath());
                this.pyEngine = new PythonEngine(clssPath, this.dic);
                this.queryContainerVersion();
            }
            catch (Exception ex) {
                ToolLoggerFactory.getLogger(this.getClass()).error("query dev version error.", ex);
                return this.dev;
            }
            return null;
        }

        private void queryContainerVersion() throws IOException, JythonException {
            List<Object> rets;
            KeyOrderedHashMap<CrossVersionType, ProductCfg> products = this.dev.getProducts();
            ProductCfg prod = (ProductCfg)products.get((Object)CrossVersionType.INNERVERSION);
            File dir = prod.getProductDir();
            String getContainerVerisonPath = dir.getCanonicalPath() + File.separator + COMMON + File.separator + GET_CONTAINER_VERSION;
            File python = new File(getContainerVerisonPath);
            if (!python.exists()) {
                LOGGER.error("python script " + python + " is not exist.");
            }
            if (((Boolean)(rets = this.pyEngine.execute(python)).get(0)).booleanValue()) {
                String containerVerison = StringUtils.toString((Object)rets.get(1));
                this.dev.setContainerVersion(containerVerison);
            }
        }
    }
}

