/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public abstract class ReportGenerateTaskHelper {
    private static final Logger LOGGER = Logger.getLogger(ReportGenerateTaskHelper.class);
    private static ExecutorService reportThreadPool = new ThreadPoolExecutor(2, 16, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new TaskThreadFactory());
    private static ExecutorService synchronousQueueThreadPool = new ThreadPoolExecutor(4, 16, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new TaskThreadFactory());

    public static <T> Future<T> submit(Callable<T> task) {
        try {
            return reportThreadPool.submit(task);
        }
        catch (Exception e) {
            LOGGER.error("***[execute error: " + e.getMessage() + "]***");
            return null;
        }
    }

    public static void execute(Runnable task) {
        try {
            synchronousQueueThreadPool.submit(task);
        }
        catch (Exception e) {
            LOGGER.error("***[execute error: " + e.getMessage() + "]***");
        }
    }

    public static void shutdown() {
        try {
            LOGGER.info("***[terminate task execute]***");
            synchronousQueueThreadPool.shutdown();
            reportThreadPool.shutdown();
        }
        catch (Exception e) {
            LOGGER.error("***[task terminate exception , " + e.getMessage() + "]***");
        }
    }

    private static class TaskThreadFactory
    implements ThreadFactory {
        private static final String THREAD_NAME_PREFIX = "VALUATION_THREAD_";
        private final AtomicInteger threadNum = new AtomicInteger(0);

        private TaskThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread taskThread = new Thread(runnable);
            taskThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable throwable) {
                    LOGGER.error(thread.getName() + " : " + throwable.getMessage());
                }
            });
            String threadName = THREAD_NAME_PREFIX + this.threadNum.incrementAndGet();
            taskThread.setName(threadName);
            return taskThread;
        }
    }
}

