/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.util;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.utils.LicenseFeatureQueryUtil;
import com.huawei.ism.tool.framework.pubservice.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.upgradeevalu.entity.EvaluDevNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SecondaryUpgradeUtils {
    public static final List<String> OCEAN_PROTECT_X_SERIES = Collections.unmodifiableList(Arrays.asList("OceanProtect X8000", "OceanProtect X6000", "OceanProtect X8000K", "OceanProtect X3000", "OceanProtect X9000", "OceanProtect X9000K", "OceanProtect E8000"));
    public static List<String> secondaryUpgradeProducts = Arrays.asList("OceanProtect A8000");
    private static List<DevNode> needMappingNodeList = new ArrayList<DevNode>();
    private static Map<String, String> secondaryPkgMapping = new HashMap<String, String>();
    private static final long LONG1024 = 1024L;

    public static boolean isSupportSecondaryUpgrade(EvaluDevNode devNode) {
        String deviceType = devNode.getDeviceType().toString();
        if (secondaryUpgradeProducts.contains(deviceType)) {
            return true;
        }
        return !StringUtils.isNULLStr((String)deviceType) && OCEAN_PROTECT_X_SERIES.contains(deviceType.split("_")[0]) && LicenseFeatureQueryUtil.hasSupportedContainerFeature((DevNode)EntityUtils.toOldDev((com.huawei.ism.tool.framework.pubservice.entity.DevNode)devNode));
    }

    public static boolean isSupportSecondaryUpgrade(String deviceType) {
        return secondaryUpgradeProducts.contains(deviceType);
    }

    public static List<DevNode> getNeedMappingNodeList() {
        return needMappingNodeList;
    }

    public static void setUpgradeLevel2Type(EvaluDevNode evaluDevNode, boolean isContainer) {
        if (evaluDevNode.isSecondaryUpgrade()) {
            String upgradeLevel2Type = isContainer ? "containerMode" : "doradoMode";
            evaluDevNode.setDevTypeLevel2(DeviceType.valueOf((String)upgradeLevel2Type));
        }
    }

    static {
        secondaryPkgMapping.put("A8000", "DoradoV6");
    }
}

