/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.util;

import com.alibaba.fastjson.JSON;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.StorageInfo;
import com.huawei.ism.tool.obase.entity.UpgradeHostInfo;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.refresh.listenner.IProgressCallback;
import com.huawei.ism.tool.obase.utils.NetUtil;
import com.huawei.ism.tool.upgradeevalu.evalu.EvaluService;
import com.huawei.ism.tool.upgradeevalu.ui.HostEvaluMainDialog;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalContext;
import com.huawei.ism.tool.upgradeevalu.util.HostEvalUtils;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class StorageInfoQryTask
implements Callable<StorageInfo> {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(StorageInfoQryTask.class);
    private final DevNode devNode;
    private IProgressCallback callback;

    public StorageInfoQryTask(DevNode devNode, IProgressCallback callback) {
        this.devNode = devNode;
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public StorageInfo call() throws Exception {
        jsonString = null;
        storageInfo = null;
        isMaximum = false;
        portTlv = 8080;
        portRest = 8088;
        try {
            jsonString = EvaluService.getInstance().queryStorageInfo4HostEvalu(EntityUtils.toNewDev((DevNode)this.devNode), this.callback);
            if (StringUtils.isBlank(jsonString)) {
                ToolLoggerFactory.getLogger(HostEvalUtils.class).info("jsonString is blank");
                throw new ToolException("query storage info error");
            }
            if ("cli.connetnum.reachmax".equals(jsonString)) {
                isMaximum = true;
                throw new ToolException("cli.connetnum.reachmax");
            }
            StorageInfoQryTask.LOGGER.info("Strage jsonString is:{}", (Object)jsonString);
            storageInfo = JSON.parseObject(jsonString, StorageInfo.class);
            storageInfo.setStorageName(this.devNode.getDeviceName());
            hostDevs = HostEvalContext.getHostDevs();
            HostEvaluMainDialog.getInstance().checkStorageHostsAssociation(storageInfo, hostDevs);
            StorageInfoQryTask.LOGGER.info("storageInfo conversion success:{}", (Object)storageInfo);
            hostList = storageInfo.getHostList();
            this.filterHost(hostList);
            ** if (storageInfo == null) goto lbl-1000
        }
        catch (Exception e) {
            try {
                ToolLoggerFactory.getLogger(HostEvalUtils.class).error("An error occurred when jspn converted object,jsonString:" + jsonString, e);
                storageInfo = new StorageInfo();
                storageInfo.setErrorCode(-1);
                storageInfo.setStorageSn(this.devNode.getDeviceSerialNumber());
                storageInfo.setStorageIp(this.devNode.getIp());
                if (isMaximum) {
                    storageInfo.setErrorMsg(e.getMessage());
                } else if (NetUtil.isPortCannotReach((String)this.devNode.getIp(), (int)portTlv) && NetUtil.isPortCannotReach((String)this.devNode.getIp(), (int)portRest)) {
                    storageInfo.setErrorMsg("failed.query.storage.connect.port");
                } else {
                    storageInfo.setErrorMsg("failed.query.storage.host.configs");
                }
                ** if (storageInfo == null) goto lbl-1000
            }
            catch (Throwable var8_9) {
                if (storageInfo != null) {
                    this.callback.finsh(storageInfo);
                }
                throw var8_9;
            }
lbl-1000:
            // 1 sources

            {
                this.callback.finsh((Object)storageInfo);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            this.callback.finsh((Object)storageInfo);
        }
lbl-1000:
        // 2 sources

        {
        }
        storageInfo.setProductVersion(this.devNode.getDeviceType().toString());
        return storageInfo;
    }

    private void filterHost(List<UpgradeHostInfo> hostList) {
        if (null != hostList) {
            Iterator<UpgradeHostInfo> iterator = hostList.iterator();
            while (iterator.hasNext()) {
                UpgradeHostInfo upgradeHostInfo = iterator.next();
                String lunNum = upgradeHostInfo.getLunNum();
                if (!StringUtils.isBlank(lunNum) && !StringUtils.equals(lunNum, "0")) continue;
                LOGGER.info("remove host success:{}", (Object)upgradeHostInfo);
                iterator.remove();
            }
        }
    }
}

