/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.utils;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.upgradeevalu.model.EvalItemResult;
import com.huawei.ism.tool.upgradeevalu.model.ItemInfo;
import com.huawei.ism.tool.upgradeevalu.utils.CompatibilityContants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonUtils.class);
    private static final String VERSION_KEY = "toolkit.app.zh.version";

    public static boolean isNoHbaInfo(ItemInfo itemInfo) {
        int n = 0;
        String[] hbaStrArray = itemInfo.getHbaName().split(";");
        String[] stringArray = hbaStrArray;
        int n2 = stringArray.length;
        if (n < n2) {
            String hbaStr = stringArray[n];
            return hbaStr.equals("No HBA card type info.") || hbaStr.contains("\n") || hbaStr.equals("NA") || StringUtils.isNULLStr((String)hbaStr);
        }
        return false;
    }

    public static boolean isNoOSInfo(ItemInfo itemInfo) {
        String os = itemInfo.getOsName();
        boolean isNull = StringUtils.isNULLStr((String)os);
        return isNull;
    }

    public static boolean isNoCluster(ItemInfo itemInfo) {
        return itemInfo.getClusterName().equals("No cluster info.") || itemInfo.getClusterName().equals("NA");
    }

    public static String fixPath(String xPath) {
        return xPath.replace("/", File.separator);
    }

    public static Integer calcTotalProcessNumber(List<EvalItemResult> currListItems) {
        Integer startNumber = currListItems.size();
        return startNumber;
    }

    public static boolean isCommandExecError(String cmdReplay) {
        if (org.apache.commons.lang3.StringUtils.isBlank(cmdReplay)) {
            return true;
        }
        for (String marker : CompatibilityContants.getCmdNotSupport()) {
            if (!cmdReplay.contains(marker)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getSingleStrVersion(List<String> storageVersionList) {
        HashSet<String> versionSet = new HashSet<String>();
        for (String eleStr : storageVersionList) {
            String[] strs = eleStr.split("/|,");
            if (strs.length > 1) {
                for (String singleEle : strs) {
                    versionSet.add(singleEle);
                }
                continue;
            }
            versionSet.add(eleStr);
        }
        ArrayList<String> versionList = new ArrayList<String>(versionSet);
        Collections.sort(versionList);
        return versionList;
    }

    public static Map<String, String> evalResultParaMap(boolean result, String reason) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("result", String.valueOf(result));
        resultMap.put("reason", reason);
        return resultMap;
    }

    public static String getCanonicalFilePath(File file) {
        if (file == null) {
            return "";
        }
        String canonicalPath = "";
        try {
            canonicalPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(CommonUtils.class).error("get file path error");
        }
        return canonicalPath;
    }

    public static String getCanonicalFilePath(String filePath) {
        String strPath = Normalizer.normalize(filePath, Normalizer.Form.NFKC);
        File file = new File(strPath);
        return CommonUtils.getCanonicalFilePath(file);
    }

    public static File getCanonicalFile(String filePath) {
        String strPath = Normalizer.normalize(filePath, Normalizer.Form.NFKC);
        File file = new File(strPath);
        File canonicalFile = null;
        try {
            canonicalFile = file.getCanonicalFile();
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(CommonUtils.class).error("get Canonical file error");
        }
        return canonicalFile;
    }

    public static void logEvalResultDetails(String details) {
        LOGGER.info(String.format(Locale.ENGLISH, "evalResultDetails:\r\n%s\r\n", details));
    }

    public static String getNotSupportMessage(String deviceType) {
        String tips = ResourceUtil.getString((String)("evalu.ui.component.detailListRenderer.result.not.support.dev.tips." + deviceType));
        return tips;
    }

    public static boolean copyRight(File srcFile, File destFile) {
        if (!srcFile.exists()) {
            LOGGER.info("src file is not exists.");
            return false;
        }
        if (!destFile.exists() && !destFile.mkdirs()) {
            LOGGER.info("make destFile failed.");
            return false;
        }
        if (!destFile.canWrite()) {
            LOGGER.info("the file can not write.");
            return false;
        }
        if (!CommonUtils.checkDiskFull(srcFile, destFile)) {
            LOGGER.info("the diskspace is not enough");
            return false;
        }
        return true;
    }

    public static boolean checkUploadRight() {
        return Boolean.valueOf(System.getenv(VERSION_KEY));
    }

    public static boolean checkDiskFull(File srcFile, File destFile) {
        return destFile.getFreeSpace() - srcFile.length() > 0xA00000L;
    }

    public static File copyFile(File targetFile, File copyToDir, String targetFileName) {
        if (null == targetFile) {
            return null;
        }
        File result = null;
        if (!copyToDir.exists() && !copyToDir.mkdirs()) {
            return null;
        }
        String newFile = FilePathUtils.checkFile((String)(copyToDir + File.separator + targetFileName));
        if (targetFile.isDirectory()) {
            if (!new File(newFile).mkdirs()) {
                return null;
            }
        } else {
            try (FileInputStream tfin = new FileInputStream(targetFile);
                 FileOutputStream nfout = new FileOutputStream(newFile);){
                CommonUtils.transferChannel(tfin, nfout);
                result = new File(newFile);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Exception: target file {} or new file {} not found.", (Object)targetFile.getName(), (Object)new File(newFile).getName());
            }
            catch (IOException e) {
                LOGGER.error("transfer data from ", targetFile.getName(), " fail.", e.getMessage());
            }
        }
        return result;
    }

    private static void transferChannel(FileInputStream tfin, FileOutputStream nfout) throws IOException {
        FileChannel targetChannel = tfin.getChannel();
        FileChannel newChannel = nfout.getChannel();
        try {
            newChannel.transferFrom(targetChannel, 0L, targetChannel.size());
        }
        catch (IOException e) {
            LOGGER.error("Transfer channel failed");
            throw e;
        }
        finally {
            CommonUtils.closeChannel(targetChannel, newChannel);
        }
    }

    private static void closeChannel(FileChannel targetChannel, FileChannel newChannel) {
        try {
            if (targetChannel != null) {
                targetChannel.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("IOException", e);
        }
        try {
            if (newChannel != null) {
                newChannel.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("IOException", e);
        }
    }

    public static boolean checkScenario(String scenario) {
        if (StringUtils.isNULLStr((String)scenario)) {
            return false;
        }
        if (0 != CompatibilityContants.getScenarioUpgradeLimit().length) {
            for (String limitScenario : CompatibilityContants.getScenarioUpgradeLimit()) {
                if (!scenario.contains(limitScenario)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean checkStrContainList(String str, String[] list) {
        for (String listStr : list) {
            if (!str.contains(listStr)) continue;
            return true;
        }
        return false;
    }

    public static boolean compareVersionInRange(String version, String[] range) {
        if (range.length == 2) {
            return CommonUtils.compareVersion(version, range[0]) > 0 && CommonUtils.compareVersion(version, range[1]) < 0;
        }
        return false;
    }

    public static int compareVersion(String version1, String version2) {
        String[] versionArray1 = version1.split("\\.");
        String[] versionArray2 = version2.split("\\.");
        int minLength = Math.min(versionArray1.length, versionArray2.length);
        int diff = 0;
        for (int i = 0; i < minLength && (diff = Integer.valueOf(versionArray1[i].trim()) - Integer.valueOf(versionArray2[i].trim())) == 0; ++i) {
        }
        diff = diff != 0 ? diff : versionArray1.length - versionArray2.length;
        return diff;
    }

    public static void deleteFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File everyFile : files = file.listFiles()) {
                CommonUtils.deleteFile(everyFile);
            }
        }
        if (file.delete()) {
            LOGGER.info(String.format(Locale.ENGLISH, "%s delete success.", file.getName()));
        } else {
            LOGGER.error(file.getName() + " delete failed.");
        }
    }
}

