/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.upgradeevalu.utils;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.utils.excel.POIUtils;
import com.huawei.ism.tool.upgradeevalu.enums.ItCompatFeautureEnum;
import com.huawei.ism.tool.upgradeevalu.enums.ItemResultEnum;
import com.huawei.ism.tool.upgradeevalu.model.EvalFeatureResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalItemResult;
import com.huawei.ism.tool.upgradeevalu.model.EvalTaskResult;
import com.huawei.ism.tool.upgradeevalu.service.XlsWriter;
import com.huawei.ism.tool.upgradeevalu.utils.CommonUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import utils.FilesUtil;

public class ExcelCreater {
    private static ExcelCreater instance = null;
    private ZipEntry excelEntry;
    private InputStream in;
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportCampabilityReport(EvalTaskResult etr, String excelPath) throws ToolException {
        Object object = this.lock;
        synchronized (object) {
            if (this.checkFolderPermission(etr, excelPath)) {
                Map<String, List<List<String>>> devType2ListMap = new ExcelCreater().getAllExcelContent(etr.getTaskInfo().getTaskUrl());
                if (devType2ListMap.isEmpty()) {
                    throw new ToolException("devType2ListMap is empty");
                }
                this.buildExcelReport(etr, devType2ListMap, excelPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildCampabilityReport(EvalTaskResult etr, String excelPath) throws ToolException {
        Object object = this.lock;
        synchronized (object) {
            if (this.checkFolderPermission(etr, excelPath)) {
                LinkedHashMap<String, List<List<String>>> devType2ListMap = new LinkedHashMap<String, List<List<String>>>();
                for (EvalItemResult itemResult : etr.getEvalItemList()) {
                    if (ItDeviceType.Host.equals((Object)itemResult.getEvalDevNode().getItDeviceType())) {
                        this.addExcelDataToMap("HostReport", devType2ListMap, itemResult);
                        continue;
                    }
                    if (!ItDeviceType.Database.equals((Object)itemResult.getEvalDevNode().getItDeviceType())) continue;
                    this.addExcelDataToMap("DatabaseReport", devType2ListMap, itemResult);
                }
                this.buildExcelReport(etr, devType2ListMap, excelPath);
            }
        }
    }

    public void addExcelDataToMap(String reportType, Map<String, List<List<String>>> devType2ListMap, EvalItemResult itemResult) {
        List<List<String>> devList = devType2ListMap.get(reportType);
        if (devList == null) {
            devList = new LinkedList<List<String>>();
            devType2ListMap.put(reportType, devList);
            List<Object> titles = null == itemResult.getItemInfo().getConbineHeaderList() ? new ArrayList() : itemResult.getItemInfo().getConbineHeaderList();
            devList.add(titles);
        }
        if (devList.get(0).size() == 0 && null != itemResult.getItemInfo().getConbineHeaderList()) {
            devList.set(0, itemResult.getItemInfo().getConbineHeaderList());
        }
        if (null != itemResult.getItemInfo().getConbineDataList()) {
            devList.add(itemResult.getItemInfo().getConbineDataList());
        } else {
            int maxCell = devList.get(0).size();
            ArrayList<String> makeUpErrLine = new ArrayList<String>();
            makeUpErrLine.add(itemResult.getItemInfo().getIp());
            makeUpErrLine.add(itemResult.getItemInfo().getDeviceName());
            for (int i = 0; i < maxCell - 2; ++i) {
                makeUpErrLine.add("null");
            }
            makeUpErrLine.add(itemResult.getFailedReason());
            devList.add(makeUpErrLine);
        }
    }

    public void buildExcelReport(EvalTaskResult etr, Map<String, List<List<String>>> devType2ListMap, String excelPath) {
        this.addXlsModelList(devType2ListMap);
        List<EvalItemResult> eva = etr.getEvalItemList();
        int indexDB = 0;
        int indexSwitch = 0;
        int indexHost = 0;
        for (EvalItemResult eir : eva) {
            if (eir.getItemInfo().getDeviceType().equals((Object)ItDeviceType.Host)) {
                this.addXlsItemList(eir, devType2ListMap, "HostReport", indexHost, 23);
                ++indexHost;
                continue;
            }
            if (eir.getItemInfo().getDeviceType().equals((Object)ItDeviceType.Switch)) {
                this.addXlsItemList(eir, devType2ListMap, "SwitchReport", indexSwitch, 5);
                ++indexSwitch;
                continue;
            }
            if (!eir.getItemInfo().getDeviceType().equals((Object)ItDeviceType.Database)) continue;
            this.addXlsItemList(eir, devType2ListMap, "DatabaseReport", indexDB, 6);
            ++indexDB;
        }
        File xlsFile = new File(excelPath);
        try {
            XlsWriter.getInstance().saveXlsReport(xlsFile, devType2ListMap);
        }
        catch (RuntimeException e) {
            if (!xlsFile.exists()) {
                etr.setCheckFile(false);
            }
            ToolLoggerFactory.getLogger(ExcelCreater.class).error("RuntimeException", e);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(ExcelCreater.class).error("something not catch .", e);
        }
    }

    private boolean checkFolderPermission(EvalTaskResult etr, String excelPath) throws ToolException {
        File file = new File(excelPath);
        String parentPath = FilesUtil.getCanonicalPath((File)file.getParentFile());
        File checkFile = new File(parentPath + File.separator + "CheckFile");
        boolean checkSucc = checkFile.mkdirs();
        if (!checkSucc) {
            throw new ToolException("disk permission check failed");
        }
        boolean deleteResult = checkFile.delete();
        ToolLoggerFactory.getLogger(ExcelCreater.class).error("the result of delete the file is: " + deleteResult);
        etr.setCheckFile(true);
        return true;
    }

    private void addXlsModelList(Map<String, List<List<String>>> devType2ListMap) {
        if (null == devType2ListMap) {
            devType2ListMap = new HashMap<String, List<List<String>>>();
        }
        String[] keyList = new String[]{"HostReport", "SwitchReport", "DatabaseReport"};
        for (int poi = 0; poi < keyList.length; ++poi) {
            if (!devType2ListMap.containsKey(keyList[poi])) continue;
            int notNullPoi = -1;
            for (int j = 0; j < devType2ListMap.get(keyList[poi]).size(); ++j) {
                if (null == devType2ListMap.get(keyList[poi]).get(j)) continue;
                notNullPoi = j;
                break;
            }
            if (notNullPoi < 0) continue;
            List<List<String>> single = devType2ListMap.get(keyList[poi]);
            single.get(notNullPoi).add(ResourceUtil.getString((String)"cloudservice.compatibility.compat.exportxls.result"));
            single.get(notNullPoi).add(ResourceUtil.getString((String)"cloudservice.compatibility.compat.exportxls.reason"));
        }
    }

    private void addXlsItemList(EvalItemResult evalItem, Map<String, List<List<String>>> devType2ListMap, String reportModel, int index, int scenarioIndex) {
        List<String> itemList = this.fillDevItemList(evalItem);
        List<List<String>> single = devType2ListMap.get(reportModel);
        for (int i = index; i < single.size(); ++i) {
            if (null == single.get(i) || single.get(i).size() < scenarioIndex + 1) continue;
            String scenario = single.get(i).get(scenarioIndex).trim();
            if (!single.get(i).get(0).trim().equals(evalItem.getItemInfo().getIp()) || !CommonUtils.checkScenario(scenario)) continue;
            single.get(i).add(itemList.get(0));
            single.get(i).add(itemList.get(1));
            break;
        }
    }

    public List<String> fillDevItemList(EvalItemResult evalItem) {
        LinkedList<String> itemList = new LinkedList<String>();
        String resultStr = "Pass";
        switch (evalItem.getItemResultEnum()) {
            case PASS: {
                resultStr = ResourceUtil.getString((String)"host.comp.eval.device.eval.pass");
                break;
            }
            case NOTPASS: {
                resultStr = ResourceUtil.getString((String)"host.comp.eval.device.eval.not.pass");
                break;
            }
            case OPTIM_RECOMD: {
                resultStr = ResourceUtil.getString((String)"host.comp.eval.device.eval.optimization.recommended");
                break;
            }
            case NOTSUPPORT: {
                String deviceType = evalItem.getItemInfo().getDevInfo().toLowerCase(Locale.ENGLISH);
                if (StringUtils.isNULLStr((String)deviceType)) {
                    deviceType = evalItem.getItemInfo().getOsName().toLowerCase(Locale.ENGLISH);
                }
                String tips = CommonUtils.getNotSupportMessage(deviceType);
                resultStr = ResourceUtil.getString((String)"host.comp.eval.device.eval.cannot.eval");
                itemList.add(resultStr);
                itemList.add(tips);
                return itemList;
            }
            default: {
                resultStr = ResourceUtil.getString((String)"host.comp.eval.device.eval.cannot.eval");
            }
        }
        StringBuffer reasonStr = new StringBuffer();
        itemList.add(resultStr);
        for (EvalFeatureResult fea : evalItem.getFeatureResultList()) {
            reasonStr.append(ResourceUtil.getString((String)("evalu.ui.resultInfoDialog.dev.table.assess." + fea.getFeatureId())) + ":  ").append(this.getFeatureEvalResult(fea));
            String failDesc = fea.getFailDesc();
            if (!StringUtils.isNULLStr((String)failDesc) && !ItemResultEnum.PASS.equals((Object)fea.getItemResult())) {
                reasonStr.append(", " + failDesc);
            }
            if (ItCompatFeautureEnum.BASE_CONNECTIVITY.toString().equals(fea.getFeatureId()) && !StringUtils.isNULLStr((String)evalItem.getItemInfo().getMissingHBAparamWWPNs())) {
                reasonStr.append('(');
                reasonStr.append(ResourceUtil.getStringWithParams((String)"cloudservice.compatibility.compat.baseConnectivity.not.update.all.hba.warning", (Object[])new Object[]{evalItem.getItemInfo().getMissingHBAparamWWPNs()}));
                reasonStr.append(')');
            }
            reasonStr.append('\n');
        }
        itemList.add(reasonStr.toString());
        return itemList;
    }

    private String getFeatureEvalResult(EvalFeatureResult fea) {
        String result = null;
        switch (fea.getItemResult()) {
            case PASS: {
                result = ResourceUtil.getString((String)"host.comp.eval.device.eval.pass");
                break;
            }
            case NOTPASS: {
                result = ResourceUtil.getString((String)"host.comp.eval.device.eval.not.pass");
                break;
            }
            case OPTIM_RECOMD: {
                result = ResourceUtil.getString((String)"host.comp.eval.device.eval.optimization.recommended");
                break;
            }
            default: {
                result = ResourceUtil.getString((String)"host.comp.eval.device.eval.cannot.eval");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<List<String>>> getAllExcelContent(String zipFileDir) {
        ZipFile zf = null;
        try {
            zf = new ZipFile(zipFileDir);
            Enumeration<? extends ZipEntry> zipEntrys = zf.entries();
            while (zipEntrys.hasMoreElements()) {
                ZipEntry zipEntry = zipEntrys.nextElement();
                if (!zipEntry.getName().endsWith(".xls")) continue;
                this.excelEntry = zipEntry;
            }
            if (null != this.excelEntry) {
                this.in = zf.getInputStream(this.excelEntry);
            }
            Map<String, List<List<String>>> map = this.getXlsInfo();
            return map;
        }
        catch (IOException e) {
            Map<String, List<List<String>>> map = Collections.emptyMap();
            return map;
        }
        finally {
            StreamUtils.closeResource(null, (Closeable)zf);
            StreamUtils.closeResource(null, (Closeable)this.in);
        }
    }

    private Map<String, List<List<String>>> getXlsInfo() {
        Map<String, List<List<String>>> allXlsInfo = this.parseElementXls(this.in);
        return allXlsInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<List<String>>> parseElementXls(InputStream inStr) {
        HSSFWorkbook workbook = null;
        HashMap<String, List<List<String>>> xlsInfoMap = new HashMap<String, List<List<String>>>();
        try {
            workbook = new HSSFWorkbook(inStr);
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                HSSFSheet devInfoSheet = workbook.getSheetAt(i);
                ArrayList<List<String>> singleList = new ArrayList<List<String>>();
                int rows = devInfoSheet.getLastRowNum() + 1;
                for (int startLine = 0; startLine < rows; ++startLine) {
                    List<String> lineInfoList = ExcelCreater.parseElementLine(devInfoSheet, startLine);
                    singleList.add(lineInfoList);
                }
                xlsInfoMap.put(devInfoSheet.getSheetName(), singleList);
            }
            HashMap<String, List<List<String>>> i = xlsInfoMap;
            return i;
        }
        catch (IOException e) {
            Map<String, List<List<String>>> map = Collections.emptyMap();
            return map;
        }
        finally {
            StreamUtils.closeResource(null, (Closeable)workbook);
        }
    }

    private static List<String> parseElementLine(Sheet devInfoSheet, int lineNum) {
        LinkedList<String> singleLineList = new LinkedList<String>();
        Row row = devInfoSheet.getRow(lineNum);
        for (int num = 0; num < row.getLastCellNum(); ++num) {
            singleLineList.add(POIUtils.getStringCellValue((Cell)row.getCell(num)));
        }
        return singleLineList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExcelCreater getInstance() {
        Class<ExcelCreater> clazz = ExcelCreater.class;
        synchronized (ExcelCreater.class) {
            if (instance == null) {
                instance = new ExcelCreater();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void setInstance(ExcelCreater instance) {
        ExcelCreater.instance = instance;
    }
}

