/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import java.nio.charset.Charset;
import java.util.Arrays;

public final class BitUtils {
    private static final String PK2 = "473f";

    private BitUtils() {
    }

    public static byte[] short2ByteArray(short val) {
        byte[] b = new byte[]{(byte)(val >>> 0), (byte)(val >>> 8)};
        return b;
    }

    public static String getSecondPk() {
        return PK2;
    }

    public static String getSecondRsaKey() {
        StringBuffer rsaKey = new StringBuffer();
        rsaKey.append("4Oz4Mgi3NVlp65sMgs7EMU+J1aKDqcZU0texULMnahyq/4kdnaCdfNvJZiC1sbapgOxbNffH");
        rsaKey.append("/C8yR/XEglDSq8TYOGKQ2IVUOfgOxhyFW0vqHyy2VIJvKE6rHijOmpjsyLHQGc0VLMZIezYrb");
        return rsaKey.toString();
    }

    public static byte[] float2ByteArray(float val) {
        byte[] b = new byte[4];
        int i = Float.floatToIntBits(val);
        b[0] = (byte)(i >>> 0);
        b[1] = (byte)(i >>> 8);
        b[2] = (byte)(i >>> 16);
        b[3] = (byte)(i >>> 24);
        return b;
    }

    public static byte[] long2ByteArray(long val) {
        byte[] b = new byte[]{(byte)(val >>> 0), (byte)(val >>> 8), (byte)(val >>> 16), (byte)(val >>> 24), (byte)(val >>> 32), (byte)(val >>> 40), (byte)(val >>> 48), (byte)(val >>> 56)};
        return b;
    }

    public static short getShort(byte[] b, int off) {
        return (short)(((b[off + 0] & 0xFF) << 0) + ((b[off + 1] & 0xFF) << 8));
    }

    public static int getShortToInt(byte[] b, int off) {
        return ((b[off + 0] & 0xFF) << 0) + ((b[off + 1] & 0xFF) << 8);
    }

    public static int getInt(byte[] b, int off) {
        return ((b[off + 0] & 0xFF) << 0) + ((b[off + 1] & 0xFF) << 8) + ((b[off + 2] & 0xFF) << 16) + ((b[off + 3] & 0xFF) << 24);
    }

    public static byte[] int2ByteArray(int val) {
        byte[] b = new byte[]{(byte)(val >>> 0), (byte)(val >>> 8), (byte)(val >>> 16), (byte)(val >>> 24)};
        return b;
    }

    public static byte[] stringToByteArray(String str, int maxStringLength) {
        if (str == null) {
            return new byte[maxStringLength];
        }
        return Arrays.copyOf(str.getBytes(Charset.forName("UTF-8")), maxStringLength);
    }

    public static String byteArrayToString(byte[] b, int length, int offset) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (int iterOffset = offset; i < length && iterOffset < b.length; ++iterOffset, ++i) {
            if (b[iterOffset] == 0) continue;
            sb.append((char)b[iterOffset]);
        }
        if (sb.length() == 0) {
            return "--";
        }
        return sb.toString();
    }

    public static String getString(byte[] data, int off, int len) {
        return BitUtils.byteArrayToString(data, len, off);
    }

    public static String getUnicodeString(byte[] data, int off, int len) {
        return new String(data, off, len, Charset.forName("UTF-8")).trim();
    }

    public static int bytesToInt(byte bytes) {
        int num = bytes & 0xFF;
        return num;
    }
}

