/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.File;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class UnZipLimit {
    private final long maxSize;
    private final long maxNum;
    private long fileNum;
    private long fileSize;

    public UnZipLimit() {
        this.maxSize = ApplicationContext.getInstance().getMaxUnzipFileSize();
        this.maxNum = ApplicationContext.getInstance().getMaxUnzipFileNum();
    }

    public UnZipLimit(long maxSize, long maxNum) {
        this.maxSize = maxSize;
        this.maxNum = maxNum;
    }

    public void increaseOneFileNum() {
        ++this.fileNum;
    }

    public void increaseFileSize(long incrementSize) {
        this.fileSize += incrementSize;
    }

    public boolean isFileSizeOverLimit() {
        return this.maxSize != 0L && this.fileSize >= this.maxSize;
    }

    public boolean isFileNumOverLimit() {
        return this.maxNum != 0L && this.fileNum >= this.maxNum;
    }

    public boolean isTargetFileUsableSizeOverFileSize(File tagertFile) {
        return this.fileSize >= tagertFile.getUsableSpace();
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public long getMaxNum() {
        return this.maxNum;
    }
}

