/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.platform.common.data;

import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.framework.platform.common.data.ToolUserRole;
import com.huawei.json.JSONObject;

public class ToolLoginUser {
    private static final String ANONYMIZED_USER_ACCOUNT = "******";
    private String userAccount;
    private ToolUserRole userRole;
    private ToolUserRole userRunRole;
    private long authStartTime;
    private long authEndTime;
    private boolean isOverTime;
    private boolean isInTrial;
    private double leftDays = -1.0;
    private boolean isBuildInUser;

    public ToolLoginUser(String userAccount, ToolUserRole userRole, ToolUserRole userRunRole) {
        this.userAccount = userAccount;
        this.userRole = userRole;
        this.userRunRole = userRunRole;
    }

    public boolean isBuildInUser() {
        return this.isBuildInUser;
    }

    public void setBuildInUser(boolean buildInUser) {
        this.isBuildInUser = buildInUser;
    }

    public ToolLoginUser() {
    }

    public boolean isOverTime() {
        return this.isOverTime;
    }

    public double getLeftDays() {
        return this.leftDays;
    }

    public void setLeftDays(double leftDays) {
        this.leftDays = leftDays;
    }

    public boolean isGuest() {
        return this.userRunRole != null && ToolUserRole.GUEST.getCode() == this.userRunRole.getCode();
    }

    public boolean isTrueGuest() {
        return this.userRole != null && ToolUserRole.GUEST.getCode() == this.userRole.getCode();
    }

    public boolean isInTrial() {
        return this.isInTrial;
    }

    public void setInTrial(boolean inTrial) {
        this.isInTrial = inTrial;
    }

    public void setOverTime(boolean overTime) {
        this.isInTrial = this.userRole != null && ToolUserRole.GUEST.getCode() == this.userRole.getCode() && !overTime;
        this.isOverTime = overTime;
    }

    public String getUserAccount() {
        return this.userAccount;
    }

    public void setUserAccount(String userAccount) {
        this.userAccount = userAccount;
    }

    public ToolUserRole getUserRole() {
        return this.userRole;
    }

    public void setUserRole(ToolUserRole userRole) {
        this.userRole = userRole;
    }

    public long getAuthStartTime() {
        return this.authStartTime;
    }

    public ToolUserRole getUserRunRole() {
        return this.userRunRole;
    }

    public void setUserRunRole(ToolUserRole userRunRole) {
        this.userRunRole = userRunRole;
    }

    public void setAuthStartTime(JSONObject certObj, JSONObject recordTimeObj) throws Exception {
        this.authStartTime = DateUtil.convertStringToDate("yyyy-MM-dd HH:mm:ss", recordTimeObj.getString("startTime")).getTime();
    }

    public long getAuthEndTime() {
        return this.authEndTime;
    }

    public void setAuthEndTime(long authEndTime) {
        this.authEndTime = authEndTime;
    }

    public String toString() {
        return "ToolLoginUser [userAccount=******, userRole=" + (Object)((Object)this.userRole) + ", authStartTime=" + this.authStartTime + ", authEndTime=" + this.authEndTime + ", isOverTime=" + this.isOverTime + ", isInTrial=" + this.isInTrial + ", leftDays=" + this.leftDays + "]";
    }

    public boolean isGoingOverTime() {
        if (this.isGuest()) {
            return this.leftDays <= 5.0 && this.leftDays > 0.0;
        }
        return this.leftDays <= 45.0 && this.leftDays > 0.0;
    }
}

