/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice;

import com.huawei.ism.tool.framework.platform.plugin.AbstractPlugin;
import com.huawei.ism.tool.framework.platform.plugin.PluginManager;
import com.huawei.ism.tool.framework.platform.pubservice.IServiceCenter;
import com.huawei.ism.tool.framework.platform.pubservice.IServiceTracker;
import com.huawei.ism.tool.framework.platform.runtime.AbstractRuntime;
import com.huawei.ism.tool.framework.pubservice.common.AbstractPublicService;
import com.huawei.ism.tool.framework.pubservice.common.IPublicService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class PublicServiceManage
implements IServiceCenter {
    private static PublicServiceManage singleton = new PublicServiceManage();
    private AbstractRuntime runtime = null;
    private boolean inited = false;
    private Map<String, IPublicService> servicesMap = new HashMap<String, IPublicService>();
    private Map<String, List<IServiceTracker>> trackersMap = new HashMap<String, List<IServiceTracker>>();

    public static synchronized PublicServiceManage getInstance() {
        return singleton;
    }

    @Override
    public void doInit(AbstractRuntime abRuntime) {
        if (this.inited) {
            return;
        }
        this.runtime = abRuntime;
        this.inited = true;
    }

    @Override
    public Collection<Class<?>> trackServices(IServiceTracker tracker, Collection<Class<?>> servicesNeeded) {
        HashSet unsup = new HashSet();
        for (Class<?> serviceIf : servicesNeeded) {
            String serviceName = serviceIf.getName();
            if (!this.servicesMap.containsKey(serviceName)) {
                unsup.add(serviceIf);
                continue;
            }
            List<IServiceTracker> trackers = this.trackersMap.get(serviceName);
            if (null == trackers) {
                trackers = new ArrayList<IServiceTracker>();
                this.trackersMap.put(serviceName, trackers);
            }
            trackers.add(tracker);
        }
        return unsup;
    }

    public AbstractRuntime getRuntime() {
        return this.runtime;
    }

    public boolean existsService(Class<?> serviceIf) {
        return this.servicesMap.containsKey(serviceIf.getName());
    }

    public void addService(Class<?> serviceIf, IPublicService service) {
        this.servicesMap.put(serviceIf.getName(), service);
    }

    @Override
    public void registerServicePlugin(AbstractPlugin plugin) {
        if (!(plugin instanceof AbstractPublicService)) {
            return;
        }
        AbstractPublicService servicePlugin = (AbstractPublicService)plugin;
        if (!servicePlugin.doInit(this.runtime)) {
            servicePlugin.registerFailed(servicePlugin.getId());
            return;
        }
        PluginManager.getInstance().savePlugin(plugin);
        for (IPublicService service : servicePlugin.getImplementedServices()) {
            Class<?> serviceInf = this.getServiceInf(service.getClass());
            if (null != serviceInf && !this.existsService(serviceInf)) {
                this.addService(serviceInf, service);
                servicePlugin.registerSuccess(serviceInf.getName());
                continue;
            }
            servicePlugin.registerFailed(service.getClass().getName());
        }
    }

    public void removeService(Class<?> serviceIf) {
        String serviceName = serviceIf.getName();
        this.servicesMap.remove(serviceName);
        List<IServiceTracker> trackers = this.trackersMap.get(serviceName);
        if (null != trackers) {
            HashSet serviceIfs = new HashSet();
            serviceIfs.add(serviceIf);
            for (IServiceTracker tracker : trackers) {
                tracker.fireServiceUnavailable(serviceIfs);
            }
        }
    }

    public <T> T getService(Class<T> serviceIf) {
        String serviceName = serviceIf.getName();
        return (T)this.servicesMap.get(serviceName);
    }

    private Class<?> getServiceInf(Class<? extends IPublicService> implClazz) {
        Class<?>[] infArr;
        Class<?> serviceInf = null;
        Class<?>[] classArray = infArr = implClazz.getInterfaces();
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            Class<?> inf;
            Class<?> tmpInf = inf = classArray[i];
            Class<?>[] superInfs = tmpInf.getInterfaces();
            while (superInfs.length > 0 && !IPublicService.class.equals(superInfs[0])) {
                tmpInf = superInfs[0];
                superInfs = tmpInf.getInterfaces();
            }
            if (superInfs.length <= 0 || !IPublicService.class.equals(superInfs[0])) continue;
            serviceInf = tmpInf;
            break;
        }
        return serviceInf;
    }

    private PublicServiceManage() {
    }
}

