/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.impl;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.tool.framework.pubservice.service.IUserOpDataServ;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Paths;
import org.slf4j.Logger;

public abstract class AbstractUserOpDataSev
implements IUserOpDataServ {
    private static final String READ_WAY = "rw";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AbstractUserOpDataSev.class);
    public static final String LOG_DIR = "log";
    public static final String BACK_UP_LOG_DIR = "backup";
    public static final String LOG_FILE = "all.log";
    static final String CONN_CHAR = "\"";
    static final String DEFAULT_STR_VAL = "\"\"";
    static final String JSNO_END = "}\r\n";
    static final char JSON_START = '{';
    static final char ATTR_CONN_SPER = ',';
    static final char JSON_SPER = ':';
    static final int TOO_LESS_SPACE = 0x6400000;
    static final int EQUAL = 0;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeToFile(String fileToSave, String logStr) {
        RandomAccessFile out = null;
        FileLock lock = null;
        FileChannel fcOut = null;
        try {
            File file = new File(fileToSave);
            out = new RandomAccessFile(file, READ_WAY);
            lock = FileUtils.getFileLock(file, out);
            fcOut = out.getChannel();
            if (lock == null) {
                throw new EncapsulatedRuntimeException("please check whether the file is writeable!");
            }
            this.doWrite(logStr, fcOut);
        }
        catch (RuntimeException e) {
            try {
                LOGGER.error("write log to file error!", (Throwable)e);
                throw new EncapsulatedRuntimeException("write log to file error!", e);
                catch (Exception e2) {
                    LOGGER.error("write log to file error!", (Throwable)e2);
                    throw new EncapsulatedRuntimeException("write log to file error!", e2);
                }
            }
            catch (Throwable throwable) {
                this.releaseResource(out, lock, fcOut);
                throw throwable;
            }
        }
        this.releaseResource(out, lock, fcOut);
    }

    private void releaseResource(RandomAccessFile out, FileLock lock, FileChannel fcOut) {
        FileUtils.releaseFileLock(lock);
        StreamUtils.closeResource(null, fcOut);
        StreamUtils.closeResource(null, out);
    }

    private void doWrite(String logStr, FileChannel fcOut) throws UnsupportedEncodingException, IOException {
        ByteBuffer buf = ByteBuffer.wrap(logStr.getBytes("UTF-8"));
        fcOut.position(fcOut.size());
        fcOut.write(buf);
    }

    @Override
    public boolean preSaveCheck(Object obj) {
        if (null == obj) {
            LOGGER.warn("param cannot be null");
            return false;
        }
        if (ApplicationContext.getInstance().isSpecificDeviceMode() || LocalHostUtil.isRunInV3LaterSvp()) {
            LOGGER.warn("High-End dev needn't to log.");
            return false;
        }
        if (!FileUtils.isDiskFull(UserOpDataSaveUtil.getOpDataUploadPath(), 0x6400000L)) {
            LOGGER.warn("disk space is less than expected");
            return false;
        }
        return true;
    }

    @Override
    public boolean postSaveAction() {
        return false;
    }

    public static void copyLogInfo(File resultFolder) {
        try {
            File sourceFile = Paths.get(ApplicationContext.getInstance().getWorkPath(), LOG_DIR, LOG_FILE).toFile();
            File allLogFile = Paths.get(resultFolder.getCanonicalPath(), LOG_FILE).toFile();
            File targetLogPath = resultFolder;
            if (!resultFolder.getCanonicalPath().endsWith(LOG_DIR)) {
                targetLogPath = Paths.get(resultFolder.getCanonicalPath(), LOG_DIR).toFile();
                LOGGER.warn("the log folder does not exist, create new:targetLogPath:", (Object)targetLogPath);
                FileUtils.createDir(targetLogPath);
                allLogFile = Paths.get(targetLogPath.getCanonicalPath(), LOG_FILE).toFile();
            }
            if (!sourceFile.exists()) {
                LOGGER.warn("the log file does not exist.");
                return;
            }
            LOGGER.info("start to copy log result File, sourceFile{}, allLogFile{}", (Object)sourceFile.getCanonicalPath(), (Object)allLogFile.getCanonicalPath());
            StreamUtils.copyFile(sourceFile, allLogFile);
            File backUpFolder = Paths.get(ApplicationContext.getInstance().getWorkPath(), LOG_DIR, BACK_UP_LOG_DIR).toFile();
            if (backUpFolder.exists()) {
                File backUpTargetFolder = Paths.get(targetLogPath.getCanonicalPath(), BACK_UP_LOG_DIR).toFile();
                LOGGER.info("start to copy back up result File");
                FileUtils.copyDir(backUpFolder.getCanonicalPath(), backUpTargetFolder.getCanonicalPath());
            }
        }
        catch (IOException e) {
            LOGGER.error("copy log result File error. ", (Throwable)e);
        }
    }

    public static boolean isSourceLogExists() {
        return Paths.get(ApplicationContext.getInstance().getWorkPath(), LOG_DIR, LOG_FILE).toFile().exists();
    }
}

