/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.collect.dstorage.service;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.ism.tool.service.collect.dstorage.ICollector;
import com.huawei.ism.tool.service.collect.dstorage.entity.CollectItem;
import com.huawei.ism.tool.service.collect.dstorage.entity.CollectModule;
import com.huawei.ism.tool.service.collect.dstorage.entity.SubTaskDetail;
import com.huawei.ism.tool.service.collect.dstorage.service.DownloadServer;
import com.huawei.ism.tool.service.common.server.RestWrapper;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingCollector
implements ICollector<TaskResult> {
    private static final Logger log = LoggerFactory.getLogger(PollingCollector.class);
    private static final int MAX_PRO = 100;
    private static final int QUERY_PIO = 8000;
    private static final String START_ERROR = "collect.task.start.error";
    private static final String SUB_TASK_START_ERROR = "collect.task.subTask.start.error";
    private static final String QUERY_SUBTASK_ERROR = "collect.task.subTask.query.error";

    @Override
    public TaskResult doCollect(DevNode devNode, CollectModule module) throws ToolException {
        RestWrapper restWrapper = new RestWrapper(devNode);
        String taskId = this.startCollectTask(restWrapper, module);
        module.getDetail().setId(taskId);
        new File(module.getResultDir()).mkdirs();
        List<CompletableFuture<TaskResult>> results = this.pollingSubTaskAndSubmitDownTask(restWrapper, this.querySubTask(restWrapper, module));
        CompletableFuture.allOf(results.toArray(new CompletableFuture[0])).join();
        this.deleteTask(devNode, taskId);
        return TaskResult.success((Object)"");
    }

    private String startCollectTask(RestWrapper restWrapper, CollectModule module) throws ToolException {
        DevNode devNode = restWrapper.getDevNode();
        String uri = RestUtil.getInfoCollectUri((DevNode)devNode);
        ResponseInfo resp = restWrapper.errMsg(START_ERROR, new String[0]).execPost(uri, this.buildParams(devNode, module));
        JSONObject data = (JSONObject)resp.getContentMap().get("data");
        String taskId = data.getStringOrDefault("task_id", "");
        if (StringUtils.isNULLStr((String)taskId)) {
            throw new ToolException(START_ERROR);
        }
        return taskId;
    }

    private List<SubTaskDetail> querySubTask(RestWrapper restWrapper, CollectModule module) throws ToolException {
        DevNode devNode = restWrapper.getDevNode();
        String taskId = module.getDetail().getId();
        String uri = RestUtil.getInfoCollectModuleTaskUri((DevNode)devNode, (String)taskId);
        ResponseInfo resp = restWrapper.errMsg(QUERY_SUBTASK_ERROR, new String[0]).execGet(uri);
        JSONObject taskData = (JSONObject)resp.getContentMap().get("data");
        JSONArray subTaskIdArray = taskData.getJSONArray("sub_tasks");
        ArrayList<SubTaskDetail> subTasks = new ArrayList<SubTaskDetail>(subTaskIdArray.length());
        for (int i = 0; i < subTaskIdArray.length(); ++i) {
            subTasks.add(this.buildSubTaskDetail(module, subTaskIdArray.getString(i)));
        }
        module.getDetail().setSubTasks(subTasks);
        return subTasks;
    }

    private SubTaskDetail buildSubTaskDetail(CollectModule module, String subTaskId) {
        SubTaskDetail detail = SubTaskDetail.builder().module(module).id(subTaskId).parentId(module.getDetail().getId()).localPath(module.getResultDir()).build();
        detail.addObserver(module.getDetail());
        return detail;
    }

    private List<CompletableFuture<TaskResult>> pollingSubTaskAndSubmitDownTask(RestWrapper restWrapper, List<SubTaskDetail> collectTask) {
        DevNode devNode = restWrapper.getDevNode();
        String url = RestUtil.getInfoCollectSubTaskUri((DevNode)devNode);
        return this.queryAndSubmitDownloadTask(restWrapper, collectTask, url);
    }

    private List<CompletableFuture<TaskResult>> queryAndSubmitDownloadTask(RestWrapper restWrapper, List<SubTaskDetail> subTasks, String url) {
        ArrayList<CompletableFuture<TaskResult>> downloadTasks = new ArrayList<CompletableFuture<TaskResult>>(subTasks.size());
        for (int i = 0; i < subTasks.size(); ++i) {
            SubTaskDetail subTask = subTasks.get(i);
            if (i != 0 && !this.startSubTask(restWrapper, url, subTask)) continue;
            while (this.continueQuery(restWrapper, url, subTask)) {
                this.sleep(8000L);
            }
            if (this.getItemIds(subTask).contains("Fd_ds_rule_date")) continue;
            CompletableFuture<TaskResult> result = DownloadServer.INS.supplyAsync(restWrapper.getDevNode(), subTask);
            downloadTasks.add(result);
            result.join();
        }
        return downloadTasks;
    }

    private String getItemIds(SubTaskDetail subTask) {
        return subTask.getModule().getItems().stream().map(CollectItem::getId).collect(Collectors.joining(","));
    }

    private boolean startSubTask(RestWrapper restWrapper, String url, SubTaskDetail subTask) {
        String startNextUrl = url + "?task_id=" + subTask.getParentId();
        try {
            restWrapper.execPut(startNextUrl, null);
        }
        catch (ToolException e) {
            log.error("Start subtask {} failed.", (Object)subTask, (Object)e);
            subTask.fail(e.getErrorLocaleDescription());
            return false;
        }
        catch (Exception e) {
            log.error("Start subtask {} failed.", (Object)subTask, (Object)e);
            subTask.fail(ResourceUtil.getStringWithParams(SUB_TASK_START_ERROR, subTask.getParentId(), subTask.getId()));
            return false;
        }
        return true;
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception ignored) {
            log.warn("Sleep error.", (Throwable)ignored);
        }
    }

    private boolean continueQuery(RestWrapper restWrapper, String url, SubTaskDetail subTask) {
        try {
            Thread.sleep(8000L);
            ResponseInfo resp = restWrapper.execGet(url, this.buildSubTaskReqParam(subTask));
            JSONObject taskData = (JSONObject)resp.getContentMap().get("data");
            subTask.updateCollectPro(taskData.getInt("progress"));
            subTask.setPacked(taskData.getBoolean("sub_task_result"));
            return subTask.getCollectPro() < 100;
        }
        catch (Exception e) {
            log.error("Query task info failed");
            return true;
        }
    }

    private Map<String, Object> buildSubTaskReqParam(SubTaskDetail subTask) {
        HashMap<String, Object> reqPara = new HashMap<String, Object>();
        reqPara.put("task_id", subTask.getParentId());
        reqPara.put("sub_task_id", subTask.getId());
        return reqPara;
    }

    private Map<String, Object> buildParams(DevNode devNode, CollectModule module) {
        HashMap<String, Object> reqParam = new HashMap<String, Object>();
        reqParam.put("type", module.getId());
        reqParam.put("micro_comp", module.buildMicroServe2ItemsIdMap());
        reqParam.put("nodes", this.getSelectNodeIds(devNode));
        if (module.collectByTime()) {
            reqParam.put("begin_time", module.getStartTime());
            reqParam.put("end_time", module.getEndTime());
        }
        return reqParam;
    }

    private List<Integer> getSelectNodeIds(DevNode devNode) {
        return devNode.getClusterNodes().stream().filter(ClusterNode::isSelected).map(ClusterNode::getId).collect(Collectors.toList());
    }

    private void deleteTask(DevNode devNode, String taskId) {
        String infoCollectModuleTaskUri = RestUtil.getInfoCollectModuleTaskUri((DevNode)devNode, (String)taskId);
        try {
            RestConnection conn = RestConnectionManager.getRestConnection((DevNode)devNode);
            Objects.requireNonNull(conn).execDelete(infoCollectModuleTaskUri);
        }
        catch (Exception e) {
            log.error("Delete task failed.", (Throwable)e);
        }
    }
}

