/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.patch.dstorage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.service.common.ServiceContext;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import com.huawei.ism.tool.service.patch.dstorage.service.BatchPatchImportImp;
import com.huawei.ism.tool.service.patch.dstorage.service.PatchConfigParseImp;
import com.huawei.ism.tool.service.patch.dstorage.service.PatchImportImp;
import com.huawei.ism.tool.service.patch.dstorage.service.RemovePatchImp;
import com.huawei.ism.tool.service.patch.service.IHandler;
import com.huawei.ism.tool.service.patch.service.IPatchImport;
import com.huawei.ism.util.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context
extends ServiceContext {
    private static final Logger log = LoggerFactory.getLogger(Context.class);
    public static final Context INS = new Context();
    private static final String JSON_SCENE = "jsonScene";
    private static final String PARTS_REPLACEMENT = "Parts Replacement";
    private static final String DISTRIBUTED_FRU = "Distributed FRU";
    private static final String TROUBLESHOOTING = "Troubleshooting";
    private static final String FAULT_DIAGNOSE = "FaultDiagnose";
    private final PatchConfigParseImp parse = new PatchConfigParseImp();
    private Map<DstoragePatchInfo.Type, List<DstoragePatchInfo>> recommendedPatchs = new HashMap<DstoragePatchInfo.Type, List<DstoragePatchInfo>>();
    private final Map<String, DstoragePatchInfo> autoImportPatch = new ConcurrentHashMap<String, DstoragePatchInfo>();
    private String packageRootPath = "";
    private final Map<DevNode, Boolean> supportUploadByNodeIdDevMap = new ConcurrentHashMap<DevNode, Boolean>();
    private final Map<DevNode, List<String>> sandboxClosedMap = new HashMap<DevNode, List<String>>();
    private boolean isNfvMode = false;

    private Context() {
    }

    public void initPatchConfig(String rootPath) {
        this.packageRootPath = rootPath;
        this.recommendedPatchs = this.parse.parse(rootPath + File.separator + "patchConfig.xml");
    }

    public void initPatchConfigs(String rootPath, List<String> patchConfigs) {
        this.packageRootPath = rootPath;
        patchConfigs.stream().map(this.parse::parse).forEach(this.recommendedPatchs::putAll);
    }

    public DstoragePatchInfo findBestMatchPatch(DevNode node, DstoragePatchInfo.Type type) {
        if (!this.recommendedPatchs.containsKey((Object)type)) {
            return null;
        }
        List<DstoragePatchInfo> patches = this.recommendedPatchs.get((Object)type);
        DstoragePatchInfo patch = this.findMatchOldParsePatch(node, patches);
        DstoragePatchInfo defaultPatch = this.findDefaultMatchParsePatch(node, patches);
        DstoragePatchInfo dstoragePatchInfo = patch = patch == null ? defaultPatch : patch;
        if (!VerifyUtil.isEmpty((Object)patch)) {
            patch.setNeedNfvSign(this.isNfvMode);
        }
        if (VerifyUtil.isEmpty((Object)patch) || StringUtils.isNULLStr((String)patch.getPatchPath())) {
            return null;
        }
        return patch;
    }

    public Map<DevNode, DstoragePatchInfo> findBestMatchPatch(List<DevNode> nodeList, DstoragePatchInfo.Type type) {
        HashMap<DevNode, DstoragePatchInfo> needImportPatch = new HashMap<DevNode, DstoragePatchInfo>();
        nodeList.forEach(node -> {
            DstoragePatchInfo patch = this.findBestMatchPatch((DevNode)node, type);
            if (patch != null) {
                needImportPatch.put((DevNode)node, patch);
            }
        });
        return needImportPatch;
    }

    public boolean hasMatchPatch(DevNode node, DstoragePatchInfo.Type type) {
        if (!this.recommendedPatchs.containsKey((Object)type)) {
            return false;
        }
        return this.findDefaultMatchParsePatch(node, this.recommendedPatchs.get((Object)type)) != null;
    }

    private DstoragePatchInfo findDefaultMatchParsePatch(DevNode node, List<DstoragePatchInfo> patches) {
        if (node.isFusionCube() && !this.isFaultDiagnose() && Objects.nonNull(node.getStorageVersionInfo())) {
            return this.findDistributeFusionDefaultMatchParsePatch(node, patches);
        }
        String devVer = node.getProductVersion();
        String devModel = this.getDevModel(node);
        return this.getDstoragePatchInfo(patches, devVer, devModel);
    }

    private DstoragePatchInfo getDstoragePatchInfo(List<DstoragePatchInfo> patches, String devVer, String devModel) {
        AtomicReference<Object> basicPatchInfo = new AtomicReference<Object>(null);
        AtomicReference<Integer> bestLength = new AtomicReference<Integer>(0);
        patches.stream().filter(patch -> patch.isSupportPatch(devModel, devVer)).forEach(patch -> patch.getSupportVersions().forEach(ver -> {
            if (devVer.contains((CharSequence)ver) && (Integer)bestLength.get() < ver.length()) {
                basicPatchInfo.set(patch);
                bestLength.set(ver.length());
            }
        }));
        return basicPatchInfo.get();
    }

    private DstoragePatchInfo findDistributeFusionDefaultMatchParsePatch(DevNode node, List<DstoragePatchInfo> patches) {
        String devVer = node.getStorageVersionInfo().getProductVersion();
        String devModel = this.getDistributedFruFusionCubeDevModel(node);
        return this.getDstoragePatchInfo(patches, devVer, devModel);
    }

    private boolean isDistributeFru() {
        String jsonScene = System.getenv(JSON_SCENE);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)jsonScene)) {
            JSONObject scene = JSON.parseObject((String)jsonScene);
            log.info("jsonScene : {}", (Object)scene);
            String mainScene = scene.getString("mainScene");
            String subScene = scene.getString("subScene");
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)mainScene, (CharSequence)PARTS_REPLACEMENT) && org.apache.commons.lang3.StringUtils.equals((CharSequence)subScene, (CharSequence)DISTRIBUTED_FRU)) {
                log.info("Scene is DISTRIBUTED_FRU");
                return true;
            }
        }
        log.info("Scene is not DISTRIBUTED_FRU");
        return false;
    }

    private boolean isFaultDiagnose() {
        String jsonScene = System.getenv(JSON_SCENE);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)jsonScene)) {
            JSONObject scene = JSON.parseObject((String)jsonScene);
            log.info("jsonScene : {}", (Object)scene);
            String mainScene = scene.getString("mainScene");
            String subScene = scene.getString("subScene");
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)mainScene, (CharSequence)TROUBLESHOOTING) && org.apache.commons.lang3.StringUtils.equals((CharSequence)subScene, (CharSequence)FAULT_DIAGNOSE)) {
                log.info("Scene is FAULT_DIAGNOSE");
                return true;
            }
        }
        log.info("Scene is not FAULT_DIAGNOSE");
        return false;
    }

    private DstoragePatchInfo findMatchOldParsePatch(DevNode node, List<DstoragePatchInfo> patches) {
        String devVer = node.getProductVersion();
        String devModel = this.getDevModel(node);
        for (DstoragePatchInfo patch : patches) {
            if (!patch.getSupportProductModel().equals(devModel) || !DstoragePatchInfo.ParseType.OLD.equals((Object)patch.getParseType()) || !patch.getSupportVersions().contains(devVer)) continue;
            return patch;
        }
        return null;
    }

    private String getDistributedFruFusionCubeDevModel(DevNode node) {
        String devModel = node.getDeviceType().toString();
        if (StringUtils.isNULLStr((String)node.getProductSubModel())) {
            return devModel;
        }
        if (node.isFusionCube() && Objects.nonNull(node.getStorageVersionInfo())) {
            devModel = node.getStorageVersionInfo().getDeviceType().toString();
        }
        String subVer = org.apache.commons.lang3.StringUtils.substring((String)node.getProductSubVersion(), (int)0, (int)1);
        StringBuilder modelBuilder = new StringBuilder(node.getProductSubModel());
        if (StringUtils.isNULLStr((String)subVer)) {
            modelBuilder.append("_").append(devModel);
        } else {
            modelBuilder.append("_").append(subVer).append("_").append(devModel);
        }
        return modelBuilder.toString();
    }

    private String getDevModel(DevNode node) {
        String devModel = node.getDeviceType().toString();
        if (StringUtils.isNULLStr((String)node.getProductSubModel())) {
            return devModel;
        }
        String subVer = org.apache.commons.lang3.StringUtils.substring((String)node.getProductSubVersion(), (int)0, (int)1);
        StringBuilder modelBuilder = new StringBuilder(node.getProductSubModel());
        if (StringUtils.isNULLStr((String)subVer)) {
            modelBuilder.append("_").append(devModel);
        } else {
            modelBuilder.append("_").append(subVer).append("_").append(devModel);
        }
        return modelBuilder.toString();
    }

    public String getPackageRootPath() {
        return this.packageRootPath;
    }

    public DstoragePatchInfo getAutoImportPatch(DevNode devNode, DstoragePatchInfo.Type patchType) {
        return this.autoImportPatch.get(this.getPatchImportKey(devNode, patchType));
    }

    public void registerPatch(String key, DstoragePatchInfo patchInfo) {
        this.autoImportPatch.put(key, patchInfo);
    }

    public void registerPatch(DevNode devNode, DstoragePatchInfo patchInfo) {
        this.registerPatch(this.getPatchImportKey(devNode, patchInfo.getPatchType()), patchInfo);
    }

    public String getPatchImportKey(DevNode devNode, DstoragePatchInfo.Type type) {
        return devNode.getIp() + "_" + type.name();
    }

    public void syncAutoPatchInstallStatus(List<TaskResult> resultList) {
        resultList.forEach(result -> {
            Pair pair;
            DevNode devNode;
            DstoragePatchInfo patch;
            Object resultObj = result.getResultObject();
            if (resultObj instanceof Pair && (patch = this.getAutoImportPatch(devNode = (DevNode)(pair = (Pair)resultObj).getKey(), ((DstoragePatchInfo)pair.getValue()).getPatchType())) != null && TaskResult.Result.SUCCESS.equals((Object)result.getResult())) {
                patch.updateDevInstalledStatus(devNode, DstoragePatchInfo.InstallStatus.INSTALLED);
            }
        });
    }

    public TaskResult syncAutoImport(DevNode devNode, DstoragePatchInfo patchInfo, IHandler<TaskResult> handler) {
        this.registerPatch(devNode, patchInfo);
        log.info("Start exec patch import for {} , patch : {}", (Object)devNode.getIp(), (Object)patchInfo.getPatchPath());
        TaskResult result = new PatchImportImp(devNode, patchInfo, handler).importPatch();
        this.syncAutoPatchInstallStatus(Arrays.asList(result));
        return result;
    }

    public List<TaskResult> autoImport(List<IPatchImport<Pair<DevNode, DstoragePatchInfo>, TaskResult>> tasks) {
        if (tasks.isEmpty()) {
            log.warn("Task list is empty");
            return Collections.emptyList();
        }
        log.info("Try to exec batch install task,task size {} .", (Object)tasks.size());
        try {
            BatchPatchImportImp batchPatchImportImp = new BatchPatchImportImp();
            List<TaskResult> resultList = batchPatchImportImp.batchImport(tasks);
            this.syncAutoPatchInstallStatus(resultList);
            return resultList;
        }
        catch (Exception e) {
            log.error("Batch import task failed.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public boolean uninstallAutoImportPatch(DevNode node, DstoragePatchInfo.Type patchType, IHandler<TaskResult> handler) {
        String key = this.getPatchImportKey(node, patchType);
        DstoragePatchInfo patchInfo = this.autoImportPatch.get(key);
        if (patchInfo == null || DstoragePatchInfo.InstallStatus.INSTALLED != patchInfo.queryInstalledStatus(node)) {
            return true;
        }
        boolean result = RemovePatchImp.removePatch(patchInfo, node, handler);
        if (result) {
            patchInfo.updateDevInstalledStatus(node, DstoragePatchInfo.InstallStatus.NONE);
        }
        log.info("Uninstall patch {} for {} result : {}", new Object[]{patchInfo.getPatchPath(), node.getIp(), result});
        return result;
    }

    public Map<DevNode, Boolean> getSupportUploadByNodeIdDevMap() {
        return this.supportUploadByNodeIdDevMap;
    }

    public void setNfvMode(boolean nfvMode) {
        this.isNfvMode = nfvMode;
    }

    public void recordSandboxClose(DevNode devNode, List<String> successIps) {
        INS.getSandboxClosedMap().computeIfAbsent(devNode, k -> new ArrayList()).addAll(successIps);
    }

    public void recordSandboxOpen(DevNode devNode, List<String> successIps) {
        ((List)INS.getSandboxClosedMap().getOrDefault(devNode, new ArrayList())).removeIf(successIps::contains);
    }

    public Map<DevNode, List<String>> getSandboxClosedMap() {
        return this.sandboxClosedMap;
    }
}

