/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.rest.service.device;

import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.service.common.entity.SshProxyNode;
import com.huawei.ism.tool.service.common.entity.SshProxySubNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class SshProxyConfigService {
    public static final SshProxyConfigService INS = new SshProxyConfigService();
    private final List<SshProxyNode> proxyNodes = new ArrayList<SshProxyNode>();

    public void addOrModifyNode(String uuid, String name) {
        Optional<SshProxyNode> nodeOptional = this.proxyNodes.stream().filter(proxyNode -> proxyNode.getNodeId().equals(uuid)).findFirst();
        if (nodeOptional.isPresent()) {
            nodeOptional.get().setName(name);
            return;
        }
        SshProxyNode node = new SshProxyNode();
        node.setNodeId(uuid);
        node.setName(name);
        this.proxyNodes.add(node);
    }

    public void deleteNode(String nodeId) {
        this.proxyNodes.removeIf(proxyNode -> proxyNode.getNodeId().equals(nodeId));
    }

    public void deleteSubNode(String nodeId, String subNodeId) {
        this.proxyNodes.stream().filter(sshNode -> sshNode.getNodeId().equals(nodeId)).forEach(sshNode -> this.removeSubNodeFromNode((SshProxyNode)sshNode, subNodeId));
    }

    private void removeSubNodeFromNode(SshProxyNode node, String subNodeId) {
        node.getSubNodeList().removeIf(subNode -> subNode.getNodeId().equals(subNodeId));
    }

    public void addOrModifySubNode(String uuid, SshProxySubNode node) {
        SshProxyNode jumpNode = this.getOrAddNode(uuid);
        for (int index = 0; index < jumpNode.getSubNodeList().size(); ++index) {
            SshProxySubNode currentNode = jumpNode.getSubNodeList().get(index);
            if (!currentNode.getNodeId().equals(node.getNodeId())) continue;
            if (!node.getPassword().equals(currentNode.getPassword())) {
                node.setEncryptedPassword(node.getPassword());
            }
            jumpNode.getSubNodeList().set(index, node);
            return;
        }
        node.setEncryptedPassword(node.getPassword());
        jumpNode.getSubNodeList().add(node);
    }

    private SshProxyNode getOrAddNode(String uuid) {
        return this.proxyNodes.stream().filter(sshNode -> sshNode.getNodeId().equals(uuid)).findFirst().orElseGet(() -> this.addNode(uuid));
    }

    private SshProxyNode addNode(String uuid) {
        SshProxyNode sshNode = new SshProxyNode(uuid, uuid);
        this.proxyNodes.add(sshNode);
        return sshNode;
    }

    public List<MultiRouteNode> getSSHRouteList(String nodeId) {
        return this.proxyNodes.stream().filter(s -> s.getNodeId().equals(nodeId)).findFirst().map(this::getSSHRouteList).orElse(Collections.emptyList());
    }

    private List<MultiRouteNode> getSSHRouteList(SshProxyNode sshProxyNode) {
        return sshProxyNode.getSubNodeList().stream().map(subNode -> new MultiRouteNode(subNode.getHost(), subNode.getPort(), subNode.getUsername(), subNode.getDecryptedPass())).collect(Collectors.toList());
    }

    private SshProxyConfigService() {
    }

    public List<SshProxyNode> getProxyNodes() {
        return this.proxyNodes;
    }
}

