/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.sdk.unified.log.filter.sensitive.throwable.rule;

import com.huawei.ism.tool.sdk.unified.log.filter.sensitive.throwable.rule.SensitiveThrowableRule;

public class SensitiveThrowable
extends Throwable {
    private SensitiveThrowable(String message, Throwable cause) {
        super(message, cause);
    }

    private static SensitiveThrowable copyFrom(Throwable throwable, SensitiveThrowableRule rule) {
        if (throwable == null) {
            return null;
        }
        String newMessage = rule.buildMessage(throwable);
        SensitiveThrowable result = new SensitiveThrowable(newMessage == null ? SensitiveThrowable.buildNormalMessage(throwable) : newMessage, SensitiveThrowable.copyFrom(throwable.getCause(), rule));
        result.setStackTrace(throwable.getStackTrace());
        return result;
    }

    public static String buildShieldedMessage(Throwable sensitive) {
        return "Shielded sensitive throwable message, original throwable type: " + sensitive.getClass().getName();
    }

    public static String buildNormalMessage(Throwable throwable) {
        String name = throwable.getClass().getName();
        String throwableMessage = throwable.getLocalizedMessage();
        return throwableMessage != null ? name + ": " + throwableMessage : name;
    }

    public static boolean containsSensitiveThrowable(Throwable throwable, SensitiveThrowableRule rule) {
        if (throwable == null) {
            return false;
        }
        if (rule.isSensitiveThrowable(throwable) || SensitiveThrowable.containsSensitiveThrowable(throwable.getCause(), rule)) {
            return true;
        }
        Throwable[] originalSuppressed = throwable.getSuppressed();
        if (originalSuppressed == null) {
            return false;
        }
        for (Throwable suppressed : originalSuppressed) {
            if (!SensitiveThrowable.containsSensitiveThrowable(suppressed, rule)) continue;
            return true;
        }
        return false;
    }

    public static Throwable replaceSensitiveThrowable(Throwable throwable, SensitiveThrowableRule rule) {
        SensitiveThrowable replaced = SensitiveThrowable.copyFrom(throwable, rule);
        Throwable[] originalSuppressed = throwable.getSuppressed();
        if (originalSuppressed != null) {
            for (Throwable suppressed : originalSuppressed) {
                replaced.addSuppressed(SensitiveThrowable.replaceSensitiveThrowable(suppressed, rule));
            }
        }
        return replaced;
    }
}

