/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service;

import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.util.NetUtil;
import java.text.Normalizer;
import org.slf4j.Logger;

public class VerSpcGainer {
    private static final int PER_SLEEP_TIME = 100;
    private static final int EXEC_TIME_OUT = 300;
    private static final String SOFTWARE_VERSION = "Software Version";
    private static final String SPC_VER_REGEX = "V\\d{3}R\\d{3}C\\d{2}SPC\\w{1,3}T{0,1}";
    private static final String DIGIT_VER_REGEX = "[\\d]{1,4}\\.[\\d]{1,4}\\.[a-zA-Z0-9]{1,14}(\\.[a-zA-Z0-9]{1,8})?(\\.[a-zA-Z0-9]{4})?";
    private static final String VER_REGEX = "V\\d{3}R\\d{3}C\\d{2}";
    private static final int DEFAULT_TIMEOUT = 130;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(VerSpcGainer.class);

    public String query(ICliConnection con) {
        try {
            String cliCurInfo;
            ICliConnection.CliRtnEntity cliInfoEntity = con.asyncExecReturnEntity("show upgrade package", 130);
            String verByKeys = this.getVerByKeys(cliInfoEntity);
            String externalVer = "";
            String cliInfo = null;
            if (verByKeys == null) {
                cliInfo = con.execCmdWithTimout("show upgrade package", 130);
                cliInfo = Normalizer.normalize(cliInfo, Normalizer.Form.NFKC);
                verByKeys = this.getVerByKeys(cliInfo);
            }
            String string = cliCurInfo = cliInfo != null ? cliInfo : cliInfoEntity.getCmdReutrn();
            if (StringUtils.isNULLStr((String)verByKeys) && !cliCurInfo.contains(SOFTWARE_VERSION) && !cliInfoEntity.getCmdReutrnTillDone().contains(SOFTWARE_VERSION)) {
                cliInfo = con.execCmdWithTimout("showupgradepkginfo -t 1", 130);
                String[] keys = new String[]{"Running", " A ", " B "};
                verByKeys = this.getStringByKeys(cliInfo, keys, SPC_VER_REGEX);
            }
            if (StringUtils.isNULLStr((String)verByKeys)) {
                cliInfo = con.execCmdWithTimout("cat /opt/huawei/deploy/package/version", 130);
                String[] vrcKeys = new String[]{"ProductVersion="};
                verByKeys = this.getStringByKeys(cliInfo, vrcKeys, SPC_VER_REGEX);
                String[] digitVerKeys = new String[]{"ExternalVersion="};
                externalVer = this.getStringByKeys(cliInfo, digitVerKeys, DIGIT_VER_REGEX);
            }
            if (!StringUtils.isNULLStr((String)externalVer)) {
                return externalVer;
            }
            if (!StringUtils.isNULLStr((String)verByKeys)) {
                return verByKeys;
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("query device spc version runtime exception.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("query device spc version error.");
        }
        return "";
    }

    private String getVerByKeys(ICliConnection.CliRtnEntity cliInfoEntity) {
        if (cliInfoEntity == null) {
            return "";
        }
        int checkTImes = 0;
        while (!cliInfoEntity.isCmdExecOver()) {
            String cliInfo = cliInfoEntity.getCmdReutrn();
            String[] lines = cliInfo.split("\\s+");
            for (int i = 0; i < lines.length; ++i) {
                String ver;
                if (!StringUtils.isFullIpAddress((String)lines[i]) && !NetUtil.isValidIPV6((String)lines[i]) || StringUtils.isNULLStr((String)(ver = lines[i + 1])) || !StringUtils.hasMatchStr((String)ver, (String)VER_REGEX)) continue;
                return StringUtils.findMatchStr((String)ver, (String)SPC_VER_REGEX, (int)0);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOGGER.error("exec error!", (Throwable)e);
            }
            if (checkTImes++ <= 300) continue;
            LOGGER.warn("exec time out times\uff1a" + checkTImes);
            return null;
        }
        return "";
    }

    private String getVerByKeys(String cliInfo) {
        String[] lines = cliInfo.split("\\s+");
        for (int i = 0; i < lines.length; ++i) {
            String ver;
            if (!StringUtils.isFullIpAddress((String)lines[i]) || StringUtils.isNULLStr((String)(ver = lines[i + 1])) || !StringUtils.hasMatchStr((String)ver, (String)VER_REGEX)) continue;
            return StringUtils.findMatchStr((String)ver, (String)SPC_VER_REGEX, (int)0);
        }
        return "";
    }

    private String getStringByKeys(String cliInfo, String[] keys, String regex) {
        String[] lines = Normalizer.normalize(cliInfo, Normalizer.Form.NFKC).split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (!this.containKeyword(line, keys) || !StringUtils.hasMatchStr((String)line, (String)regex)) continue;
            return StringUtils.findMatchStr((String)line, (String)regex, (int)0);
        }
        return "";
    }

    private boolean containKeyword(String lineStr, String[] keys) {
        if (null == keys || keys.length < 1) {
            return false;
        }
        for (String key : keys) {
            if (!lineStr.contains(key)) continue;
            return true;
        }
        return false;
    }
}

