/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.dev.infoqry;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.huawei.ism.tool.devicemanager.entity.fusioncube.DeviceInfoTo;
import com.huawei.ism.tool.devicemanager.entity.fusioncube.FsaInfo;
import com.huawei.ism.tool.devicemanager.entity.fusioncube.PageResponse;
import com.huawei.ism.tool.devicemanager.entity.fusioncube.ResultVo;
import com.huawei.ism.tool.devicemanager.entity.fusioncube.ServerInfo;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.INodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.dev.infoqry.DSstorageInfoQryServiceImpl;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.DeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.FsDevNode;
import com.huawei.ism.tool.obase.entity.VersionAndModelInfo;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.CliResolverUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.FusionCubeConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class FusionCubeInfoQryServiceImpl
implements INodeTypeQuery {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(FusionCubeInfoQryServiceImpl.class);
    private static final String QUERY_STANDBY_IP_CMD = "cat /opt/omm/oms/workspace/webapps/dsware/WEB-INF/manager-ha.properties | grep \"service_remote_ip\" | awk -F \"=\" '{print$2}'";
    private static final String CLI_FUSIONCUBE_6_X_VERSION = "cat /opt/goku/services/csm/utils/version/VERSION.inner | awk '{print $1}'";
    private static final String CLI_FUSIONCUBE_6_X_SCENARIO = "cat /opt/fc2/cfg/server_info.conf | grep scenario |awk -F = '{print $2}'";
    private static final String CLI_FUSIONCUBE_8_X_SHOW_SYS = "showSys";
    private static final String CLI_FUSIONCUBE_812SPC200_SHOW_SYS = "sh /opt/huawei/fce/runtime/base/*/showSys.sh";
    private static final String FS_SSO_STATUS = "cat /opt/omm/oms/workspace/webapps/dsware/WEB-INF/authconfig.properties | grep loginType | awk -F = '{print$2}'";
    private static final String PRODUCT_VERSION = "product_version";
    private static final String SCENARIO = "scenario";
    private static final String SEPARATOR_EQUAL = "=";
    private static final String FCV_CLUSTER_NODE_PREFIX = "FCV";
    private static final String CLI_FUSIONCUBE_HA_STATUS = "sh /opt/dfv/oam/oam-u/ha/ha/module/hacom/script/status_ha.sh";
    private INodeSupport nodeSupport = null;

    public void setNodeSupport(INodeSupport nodeSupport) {
        this.nodeSupport = nodeSupport;
    }

    @Override
    public TaskResult queryNodeInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, DeviceOpr opr) {
        return this.queryNodeInfo(devNode, opr, null);
    }

    @Override
    public TaskResult queryNodeInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, DeviceOpr opr, ProgressDialog progressDialog) {
        TaskResult cubeTaskResult = this.queryCubeExpandInfo(devNode, progressDialog);
        if (cubeTaskResult.getResult() == TaskResult.Result.FAILED) {
            return cubeTaskResult;
        }
        TaskResult fsTaskResult = this.queryDSstorageInfo(devNode, opr, progressDialog);
        if (fsTaskResult.getResult() == TaskResult.Result.FAILED) {
            return fsTaskResult;
        }
        devNode.setStorageVersionInfo(new VersionAndModelInfo(devNode.getDeviceType(), devNode.getProductVersion()));
        this.setFcvClusterNodeBmcIp(devNode);
        return this.mergeCubeResult(cubeTaskResult, fsTaskResult);
    }

    private TaskResult mergeCubeResult(TaskResult cubeTaskResult, TaskResult fsTaskResult) {
        com.huawei.ism.tool.obase.entity.DevNode cubeDevNode = (com.huawei.ism.tool.obase.entity.DevNode)cubeTaskResult.getResultObject();
        com.huawei.ism.tool.obase.entity.DevNode fsDevNode = (com.huawei.ism.tool.obase.entity.DevNode)fsTaskResult.getResultObject();
        fsDevNode.setProductSubVersion(cubeDevNode.getProductSubVersion());
        fsDevNode.setProductModel(ItDeviceType.FUSIONCUBE.getName());
        fsDevNode.setProductSubModel(ItDeviceType.FUSIONCUBE.getName());
        fsDevNode.setDeviceName(cubeDevNode.getDeviceName());
        fsDevNode.setScenarioInfo(cubeDevNode.getScenarioInfo());
        fsDevNode.setItDeviceType(ItDeviceType.FUSIONCUBE);
        if (!StringUtils.isNULLStr((String)cubeDevNode.getDeviceSerialNumber())) {
            fsDevNode.setDeviceSerialNumber(cubeDevNode.getDeviceSerialNumber());
        }
        fsDevNode.setDeviceType(com.huawei.ism.tool.obase.entity.DeviceType.valueOf((String)ItDeviceType.FUSIONCUBE.getName()));
        fsDevNode.setProductVersion(cubeDevNode.getProductVersion());
        fsTaskResult.setResultObject((Object)fsDevNode);
        return fsTaskResult;
    }

    private void setFcvClusterNodeBmcIp(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        devNode.getClusterNodes().stream().filter(clusterNode -> org.apache.commons.lang3.StringUtils.startsWith((CharSequence)clusterNode.getName(), (CharSequence)FCV_CLUSTER_NODE_PREFIX)).forEach(clusterNode -> {
            Optional<ClusterNode> storageNode = devNode.getClusterNodes().stream().filter(node -> node.isStorageNode() && org.apache.commons.lang3.StringUtils.equals((CharSequence)clusterNode.getSlotNumber(), (CharSequence)node.getSlotNumber())).findFirst();
            if (storageNode.isPresent()) {
                clusterNode.setBmcIp(storageNode.get().getBmcIp());
            }
        });
    }

    private TaskResult queryDSstorageInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, DeviceOpr opr, ProgressDialog progressDialog) {
        DSstorageInfoQryServiceImpl dSstorageInfoQryService = new DSstorageInfoQryServiceImpl();
        dSstorageInfoQryService.setNodeSupport(this.nodeSupport);
        return dSstorageInfoQryService.queryNodeInfo(devNode, opr, progressDialog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskResult queryCubeExpandInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, ProgressDialog progressDialog) {
        TaskResult taskResult = new TaskResult();
        try {
            com.huawei.ism.tool.obase.entity.DevNode fusionCubeDevNode = this.createFusionCubeSSHDevNode(devNode);
            ICliConnection ssh = SshConnectionManager.getSshConnection((com.huawei.ism.tool.obase.entity.DevNode)fusionCubeDevNode);
            String record = CliResolverUtils.executeCli((ICliConnection)ssh, (String)CLI_FUSIONCUBE_8_X_SHOW_SYS, (boolean)false);
            if (StringUtils.isNULLStr((String)record)) {
                record = CliResolverUtils.executeCli((ICliConnection)ssh, (String)CLI_FUSIONCUBE_812SPC200_SHOW_SYS, (boolean)false);
            }
            String version = CliResolverUtils.getCliInfoWithSeparator((String)record, (String)PRODUCT_VERSION, (String)SEPARATOR_EQUAL);
            String esn = "";
            if (!StringUtils.isNULLStr((String)version)) {
                version = version.replaceAll("\"", "");
                version = org.apache.commons.lang3.StringUtils.substringAfter((String)version, (String)"FusionCube ");
                esn = this.getCliFusionCube8XEsn(ssh);
            }
            String scenario = CliResolverUtils.getCliInfoWithSeparator((String)record, (String)SCENARIO, (String)SEPARATOR_EQUAL);
            if (StringUtils.isNULLStr((String)version)) {
                version = CliResolverUtils.executeCli((ICliConnection)ssh, (String)CLI_FUSIONCUBE_6_X_VERSION, (boolean)true);
                scenario = CliResolverUtils.executeCli((ICliConnection)ssh, (String)CLI_FUSIONCUBE_6_X_SCENARIO, (boolean)true);
                esn = this.getCliFusionCube6XEsn(ssh);
            }
            this.checkFusionCubeVersionSupport(devNode, taskResult, version, scenario, esn);
            this.checkSSOStatus(devNode, ssh, taskResult, version);
            this.queryStandbyNode(ssh, devNode, progressDialog);
        }
        catch (ToolException e) {
            LOGGER.error("Query cube version error");
            String errDes = e.getDes();
            String errorId = e.getErrorId();
            if (StringUtils.isNULLStr((String)errDes) || "--".equals(errDes)) {
                errDes = ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.query.version.failed");
                errorId = "devicemanager.layout.device.add.deviceadddialog.fusioncube.query.version.failed";
            }
            this.updateTaskResultError(taskResult, errDes, errorId, devNode);
        }
        finally {
            SshConnectionManager.releaseConnection((com.huawei.ism.tool.obase.entity.DevNode)devNode);
        }
        return taskResult;
    }

    private void queryStandbyNode(ICliConnection ssh, com.huawei.ism.tool.obase.entity.DevNode devNode, ProgressDialog progressDialog) throws ToolException {
        if (!(devNode instanceof FsDevNode)) {
            return;
        }
        if (Objects.nonNull(progressDialog)) {
            progressDialog.setCustMizeMsg(ResourceUtil.getString((String)"query.standby.node"));
        }
        this.queryStandbyNodeInfo(ssh, (FsDevNode)devNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryStandbyNodeInfo(ICliConnection ssh, FsDevNode devNode) throws ToolException {
        FsDevNode standbyDevNode = devNode.getStandbyDevNode();
        if (Objects.isNull(standbyDevNode)) {
            return;
        }
        String standByIp = this.queryStandbyNodeIp(ssh);
        try {
            standbyDevNode.setIp(standByIp);
            standbyDevNode.setProductModel(devNode.getProductModel());
            standbyDevNode.setProductVersion(devNode.getProductVersion());
            SshConnectionManager.getSshConnection((com.huawei.ism.tool.obase.entity.DevNode)standbyDevNode);
        }
        finally {
            SshConnectionManager.releaseConnection((com.huawei.ism.tool.obase.entity.DevNode)devNode.getStandbyDevNode());
        }
    }

    private String queryStandbyNodeIp(ICliConnection sshConnection) throws ToolException {
        String ipString = sshConnection.execCmd(QUERY_STANDBY_IP_CMD);
        String ip = com.huawei.ism.tool.base.utils.StringUtils.parseIpFromStr((String)ipString);
        if (com.huawei.ism.tool.base.utils.StringUtils.isNULLStr((String)ip)) {
            throw new ToolException("query.standby.node.error");
        }
        return ip;
    }

    private void checkSSOStatus(com.huawei.ism.tool.obase.entity.DevNode devNode, ICliConnection ssh, TaskResult taskResult, String version) throws ToolException {
        if (version.startsWith("6.") && "1".equals(CliResolverUtils.executeCli((ICliConnection)ssh, (String)FS_SSO_STATUS, (boolean)true))) {
            String errDes = ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.sso.failed");
            String errId = "devicemanager.layout.device.add.deviceadddialog.fusioncube.sso.failed";
            this.updateTaskResultError(taskResult, errDes, errId, devNode);
        }
    }

    private String getCliFusionCube6XEsn(ICliConnection ssh) throws ToolException {
        String gaussStatus = CliResolverUtils.executeCli((ICliConnection)ssh, (String)"sh /opt/dfv/oam/oam-u/ha/ha/module/hacom/script/status_ha.sh| grep fcc_gaus | grep Active_normal", (boolean)false);
        if (!org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)gaussStatus, (CharSequence)"fcc_gauss")) {
            return "";
        }
        String pass = CliResolverUtils.executeNoLogCli((ICliConnection)ssh, (String)"/usr/local/bin/pwswitch -d $(grep '^dbadmin:' /opt/goku/data/config/DBKey.cfg | sed \"s/^dbadmin://\")", (boolean)true);
        return CliResolverUtils.executeNoLogCli((ICliConnection)ssh, (String)("su - dbadmin -s /bin/bash -c 'zsql dbadmin/\"" + pass + "\"@127.0.0.1:\"6432\" -q -c \"select ESN from irm.tbl_fcc_license where id = 1;\"' | sed -n '8p'"), (boolean)true);
    }

    private String getCliFusionCube8XEsn(ICliConnection ssh) throws ToolException {
        String gaussStatus = CliResolverUtils.executeCli((ICliConnection)ssh, (String)"sh /opt/dfv/oam/oam-u/ha/ha/module/hacom/script/status_ha.sh| grep fce_gauss | grep Active_normal", (boolean)false);
        if (!org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)gaussStatus, (CharSequence)"fce_gaussdb")) {
            return "";
        }
        String pass = CliResolverUtils.executeNoLogCli((ICliConnection)ssh, (String)"python -c \"import kmc.kmc as K;import os;os.environ['KMC_DATA_USER']='gaussdba';print(K.API().decrypt(0,'$(cat /opt/huawei/fce/runtime/security/priv/gaussdb.conf | grep \"gaussdba\" | awk -F \"=\" '{print $2}')'))\"", (boolean)true);
        return CliResolverUtils.executeNoLogCli((ICliConnection)ssh, (String)("su - gaussdba -s /bin/bash -c 'zsql gaussdba/\"" + pass + "\"@127.0.0.1:\"1888\" -q -c \"select ESN from FRAMEWORK.LICENSE_T limit 0,1;\"' | sed -n '8p'"), (boolean)true);
    }

    private void checkFusionCubeVersionSupport(com.huawei.ism.tool.obase.entity.DevNode devNode, TaskResult taskResult, String version, String scenario, String esn) {
        if (this.isSupportedVersion(ItDeviceType.FUSIONCUBE.getName(), version, scenario)) {
            com.huawei.ism.tool.obase.entity.DevNode fusionCubeDevNode = new com.huawei.ism.tool.obase.entity.DevNode();
            this.buildFusionCubeInfo(fusionCubeDevNode, version, scenario, this.getFusionCubeEsn(devNode, esn));
            taskResult.setResult(TaskResult.Result.SUCCESS);
            taskResult.setErrorLocaleDescription("");
            taskResult.setResultObject((Object)fusionCubeDevNode);
        } else {
            this.updateTaskResultError(taskResult, ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.not.supported", (Object[])new Object[]{ItDeviceType.FUSIONCUBE.getName() + " " + version + " " + scenario}), "devicemanager.layout.device.add.deviceadddialog.fusioncube.not.supported", devNode);
        }
    }

    private String getFusionCubeEsn(com.huawei.ism.tool.obase.entity.DevNode devNode, String newEsn) {
        if (!devNode.getDeviceSerialNumber().isEmpty()) {
            return devNode.getDeviceSerialNumber();
        }
        return newEsn;
    }

    private void buildFusionCubeInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, String version, String scenario, String esn) {
        devNode.setProductSubVersion(version);
        devNode.setDeviceName(scenario);
        devNode.setScenarioInfo(scenario);
        devNode.setDeviceSerialNumber(esn);
        devNode.setProductVersion(version);
    }

    private com.huawei.ism.tool.obase.entity.DevNode createFusionCubeSSHDevNode(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        com.huawei.ism.tool.obase.entity.DevNode fusionCubeDevNode = new com.huawei.ism.tool.obase.entity.DevNode();
        fusionCubeDevNode.setLoginUser(devNode.getFusionCubeLoginUser());
        fusionCubeDevNode.setRootUser(devNode.getRootUser());
        fusionCubeDevNode.setPriKey(devNode.getPriKey());
        fusionCubeDevNode.setDevKey(devNode.getDevKey());
        fusionCubeDevNode.setPort(devNode.getFusionCubeSSHPort());
        fusionCubeDevNode.setIp(devNode.getIp());
        fusionCubeDevNode.setDeviceSerialNumber("fusioncube" + System.currentTimeMillis());
        fusionCubeDevNode.setDeviceType(com.huawei.ism.tool.obase.entity.DeviceType.valueOf((String)ItDeviceType.FUSIONCUBE.getName()));
        return fusionCubeDevNode;
    }

    private boolean isSupportedVersion(String deviceType, String version) {
        DevNode newDevNode = new DevNode();
        newDevNode.setDeviceType(DeviceType.valueOf((String)deviceType));
        newDevNode.setItDeviceType(ItDeviceType.FUSIONCUBE);
        newDevNode.setProductVersion(version);
        return this.nodeSupport.isNodeSupport(newDevNode);
    }

    private boolean isSupportedVersion(String deviceType, String version, String scenarioInfo) {
        if (Objects.isNull(this.nodeSupport)) {
            return true;
        }
        DevNode newDevNode = new DevNode();
        newDevNode.setDeviceType(DeviceType.valueOf((String)deviceType));
        newDevNode.setItDeviceType(ItDeviceType.FUSIONCUBE);
        newDevNode.setProductVersion(version);
        newDevNode.setScenarioInfo(scenarioInfo);
        return this.nodeSupport.isNodeSupport(newDevNode);
    }

    private void updateTaskResultError(TaskResult result, String errorDesc, String errorId, com.huawei.ism.tool.obase.entity.DevNode devNode) {
        try {
            if (DefaultNodeProviderImpl.getInstance().isContainsNode(devNode)) {
                DefaultNodeProviderImpl.getInstance().removeNode(devNode);
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.error("[remove device >> {}][success]", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)devNode.toString()));
            }
        }
        catch (ToolException toolException) {
            LOGGER.error("[remove device >> {}][exception]", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)devNode.toString()));
        }
        if (result != null && result.getResult() == TaskResult.Result.SUCCESS) {
            result.setResult(TaskResult.Result.FAILED);
            result.setErrorId(errorId);
            result.setErrorLocaleDescription(errorDesc);
        } else if (LOGGER.isInfoEnabled()) {
            LOGGER.info("No need to change the result");
        }
    }

    public TaskResult queryBmcInfo(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        if (!devNode.isFusionCube()) {
            return new TaskResult(TaskResult.Result.SUCCESS);
        }
        if (this.isFusionCube6(devNode)) {
            return this.query6XBmcInfo(devNode);
        }
        return this.query8XBmcInfo(devNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskResult query8XBmcInfo(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        TaskResult taskResult = new TaskResult(TaskResult.Result.SUCCESS);
        try {
            com.huawei.ism.tool.obase.entity.DevNode fusionCubeDevNode = this.createFusionCubeRestDevNode(devNode);
            FusionCubeConnection connection = RestConnectionManager.getFusionCubeRestConnection(fusionCubeDevNode);
            if (Objects.isNull(connection) || !connection.isLogin()) {
                String errorId = "devicemanager.layout.device.add.deviceadddialog.deviceconnecterror";
                String errDes = ResourceUtil.getStringWithParams((String)errorId, (Object[])new Object[]{devNode.getIp()});
                this.updateTaskResultError(taskResult, errDes, errorId, devNode);
                TaskResult taskResult2 = taskResult;
                return taskResult2;
            }
            JSONObject params = new JSONObject();
            params.put("filterChildDevice", (Object)0);
            params.put("appendFeature", (Object)1);
            params.put("deviceTypes", Arrays.asList("server", "fsa"));
            ResponseInfo responseInfo = connection.execPost(connection.getDeviceListUrl(), params.toJSONString());
            if (!responseInfo.isSuccess() || !org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)responseInfo.getContent())) {
                LOGGER.error("query fusionCube bmc info error");
                String errorId = "devicemanager.query.fusioncube.bmc.info.fail";
                String errDes = ResourceUtil.getStringWithParams((String)errorId, (Object[])new Object[]{devNode.getIp()});
                this.updateTaskResultError(taskResult, errDes, errorId, devNode);
                TaskResult taskResult3 = taskResult;
                return taskResult3;
            }
            ResultVo resultVo = (ResultVo)JSONObject.parseObject((String)responseInfo.getContent(), (TypeReference)new TypeReference<ResultVo<PageResponse<DeviceInfoTo>>>(){}, (Feature[])new Feature[0]);
            if (!resultVo.isSuccess() || ((PageResponse)resultVo.getData()).getTotal() <= 0) {
                LOGGER.error("query fusionCube bmc devciceinfo error");
                String errorId = "devicemanager.query.fusioncube.bmc.info.fail";
                String errDes = ResourceUtil.getStringWithParams((String)errorId, (Object[])new Object[]{devNode.getIp()});
                this.updateTaskResultError(taskResult, errDes, errorId, devNode);
                TaskResult taskResult4 = taskResult;
                return taskResult4;
            }
            Map<String, String> storageIp2BmcIpMap = this.parseStorageIp2BmcIpMap(((PageResponse)resultVo.getData()).getDataList());
            this.setBmcIp(devNode, storageIp2BmcIpMap);
        }
        catch (ToolException e) {
            LOGGER.error("query8XBmcInfo error : ", (Throwable)e);
            String errDes = e.getDes();
            String errorId = e.getErrorId();
            this.updateTaskResultError(taskResult, errDes, errorId, devNode);
        }
        finally {
            RestConnectionManager.releaseFusionCubeConnection(devNode);
        }
        return taskResult;
    }

    private com.huawei.ism.tool.obase.entity.DevNode createFusionCubeRestDevNode(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        com.huawei.ism.tool.obase.entity.DevNode fusionCubeNode = new com.huawei.ism.tool.obase.entity.DevNode();
        fusionCubeNode.setItDeviceType(ItDeviceType.FUSIONCUBE);
        fusionCubeNode.setLoginUser(devNode.getFusionCubeUser());
        fusionCubeNode.setIp(devNode.getIp());
        fusionCubeNode.setDeviceSerialNumber(devNode.getDeviceSerialNumber());
        return fusionCubeNode;
    }

    private void setBmcIp(com.huawei.ism.tool.obase.entity.DevNode devNode, Map<String, String> storageIp2BmcIpMap) {
        devNode.getClusterNodes().forEach(node -> {
            String bmcIp = storageIp2BmcIpMap.getOrDefault(node.getManagementIp(), "");
            node.setBmcIp(bmcIp);
            com.huawei.ism.tool.obase.entity.DevNode bmcNode = node.getBmcNode();
            if (bmcNode == null) {
                bmcNode = new com.huawei.ism.tool.obase.entity.DevNode();
                node.setBmcNode(bmcNode);
            }
            bmcNode.setIp(bmcIp);
        });
    }

    private Map<String, String> parseStorageIp2BmcIpMap(List<DeviceInfoTo> dataList) {
        List servers = dataList.stream().filter(dev -> org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)dev.getDeviceType(), (CharSequence)"server")).collect(Collectors.toList());
        List fsaDevices = dataList.stream().filter(dev -> org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)dev.getDeviceType(), (CharSequence)"fsa")).collect(Collectors.toList());
        HashMap<String, String> storageIp2BmcIpMap = new HashMap<String, String>();
        block0: for (DeviceInfoTo server : servers) {
            for (DeviceInfoTo fsaDevice : fsaDevices) {
                String fsaSn;
                String serverSn = server.getExtValueBykey("serialNumber");
                if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)serverSn, (CharSequence)(fsaSn = fsaDevice.getExtValueBykey("serialNumber")))) continue;
                storageIp2BmcIpMap.put(fsaDevice.getDeviceIp(), server.getDeviceIp());
                continue block0;
            }
        }
        return storageIp2BmcIpMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskResult query6XBmcInfo(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        TaskResult taskResult = new TaskResult(TaskResult.Result.SUCCESS);
        try {
            com.huawei.ism.tool.obase.entity.DevNode fusionCubeDevNode = this.createFusionCubeSSHDevNode(devNode);
            ICliConnection ssh = SshConnectionManager.getSshConnection((com.huawei.ism.tool.obase.entity.DevNode)fusionCubeDevNode);
            String command = "export LD_LIBRARY_PATH=/opt/goku/gaussdb/app/lib:/opt/goku/gaussdb/app/add-ons";
            ssh.execCmd(command);
            String command1 = "export PYTHONPATH='/usr/lib/python2.7/site-packages/pyzenith'";
            ssh.execCmd(command1);
            String sqlCmdPrefix = "python /opt/goku/services/common/install/safe_sql.py ";
            String serverSql = "\"select serversn, bmcIp from irm.tbl_serverdevice\"";
            String fsaSql = "\"select hostname,vmmgntip from irm.tbl_controlvminfo where vmtype in ('VMWARE-CVM', 'CVM-FCM-FSM')\"";
            String serverInfo = CliResolverUtils.executeCli((ICliConnection)ssh, (String)(sqlCmdPrefix + serverSql), (boolean)true);
            List<ServerInfo> serverInfos = ServerInfo.generateServerInfos(serverInfo);
            String fsaInfo = CliResolverUtils.executeCli((ICliConnection)ssh, (String)(sqlCmdPrefix + fsaSql), (boolean)true);
            List<FsaInfo> fasInfos = FsaInfo.generateFasInfos(fsaInfo);
            Map<String, String> storageIp2BmcIpMap = this.parse6xStorageIp2BmcIpMap(serverInfos, fasInfos);
            this.setBmcIp(devNode, storageIp2BmcIpMap);
        }
        catch (ToolException e) {
            LOGGER.error("query6XBmcInfo error.", (Throwable)e);
            String errDes = e.getDes();
            String errorId = e.getErrorId();
            if (StringUtils.isNULLStr((String)errDes) || "--".equals(errDes)) {
                errDes = ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.fusioncube.query.version.failed");
                errorId = "devicemanager.layout.device.add.deviceadddialog.fusioncube.query.version.failed";
            }
            this.updateTaskResultError(taskResult, errDes, errorId, devNode);
        }
        finally {
            SshConnectionManager.releaseConnection((com.huawei.ism.tool.obase.entity.DevNode)devNode);
        }
        return taskResult;
    }

    private Map<String, String> parse6xStorageIp2BmcIpMap(List<ServerInfo> serverInfos, List<FsaInfo> fasInfos) {
        HashMap<String, String> storageIp2BmcIpMap = new HashMap<String, String>();
        block0: for (FsaInfo fasInfo : fasInfos) {
            for (ServerInfo serverInfo : serverInfos) {
                if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)fasInfo.getSn(), (CharSequence)serverInfo.getServerSn())) continue;
                storageIp2BmcIpMap.put(fasInfo.getIp(), serverInfo.getBmcIp());
                continue block0;
            }
        }
        return storageIp2BmcIpMap;
    }

    private boolean isFusionCube6(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        return org.apache.commons.lang3.StringUtils.startsWith((CharSequence)devNode.getProductVersion(), (CharSequence)"6.");
    }
}

