/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.implement;

import com.huawei.ism.tool.devicemanager.service.IExecuter;
import com.huawei.ism.tool.devicemanager.service.implement.ExecuterCallable;
import com.huawei.ism.tool.obase.entity.CheckDevNode;
import com.huawei.ism.tool.obase.entity.ResultDevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.threadpool.ThreadPoolHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class BaseExecuter
implements IExecuter {
    private String language;
    private List<CheckDevNode> checkDevNodes;

    public BaseExecuter(String language, List<CheckDevNode> checkNodes) {
        this.checkDevNodes = checkNodes;
        this.language = language;
    }

    @Override
    public Map<String, ResultDevNode> queryDevStatus() {
        ArrayList<ExecuterCallable> executerCallables = new ArrayList<ExecuterCallable>();
        if (null == this.checkDevNodes || this.checkDevNodes.isEmpty()) {
            return new HashMap<String, ResultDevNode>();
        }
        for (CheckDevNode checkDevNode : this.checkDevNodes) {
            ExecuterCallable call = new ExecuterCallable();
            call.setThreadName(checkDevNode);
            call.initValue(checkDevNode, this.language);
            executerCallables.add(call);
        }
        return this.traversalInspects(executerCallables);
    }

    private Map<String, ResultDevNode> traversalInspects(List<ExecuterCallable> executerCallables) {
        ArrayList<Future<Object>> fus = new ArrayList<Future<Object>>();
        HashMap<String, ResultDevNode> resultMap = new HashMap<String, ResultDevNode>();
        ExecutorService taskExecutor = ThreadPoolHelper.getFixedNumThreadPool((int)10, (String)"query_Node_status");
        for (ExecuterCallable executerCallable : executerCallables) {
            Future<Object> f = taskExecutor.submit(executerCallable);
            fus.add(f);
        }
        for (Future future : fus) {
            try {
                ResultDevNode resultDevNode = (ResultDevNode)future.get();
                resultMap.put(resultDevNode.getIp(), resultDevNode);
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("invokeAll InterruptedException error.", (Throwable)e);
            }
        }
        return resultMap;
    }
}

