/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.implement;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.devicemanager.service.DefaultNodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.ShowSysConstans;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import java.util.ArrayList;
import java.util.concurrent.Callable;

public class DevQueryTask
implements Callable<DevNode> {
    private String ip = "";
    private String username = "";
    private String pwsd = "";

    public DevQueryTask(String ip, String username, String password) {
        this.ip = ip;
        this.username = username;
        this.setPwd(password);
    }

    @Override
    public DevNode call() {
        ArrayList<DeviceType> supportDevTypes = new ArrayList<DeviceType>();
        supportDevTypes.add(DeviceType.ALL);
        DefaultNodeTypeQuery nodeTypeQuery = new DefaultNodeTypeQuery(supportDevTypes, ShowSysConstans.getShowSysCmds());
        DevNode devNode = new DevNode();
        devNode.setIp(this.ip);
        devNode.setLoginUser(new User(this.username, this.getPwd()));
        TaskResult result = nodeTypeQuery.queryNodeInfo(devNode, DeviceOpr.IMPORT);
        Object ret = result.getResultObject();
        return (DevNode)ret;
    }

    public String toString() {
        return "DevQueryTask [ip=" + this.ip + ", password=*****, username=" + this.username + "]";
    }

    public String getIP() {
        return this.ip;
    }

    private String getPwd() {
        return AESEncrypt.decrypt((String)this.pwsd);
    }

    private void setPwd(String pwd) {
        this.pwsd = AESEncrypt.encrypt((String)pwd);
    }
}

