/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.task;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.devicemanager.service.DeviceManageService;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.dev.newinfoquery.DmeNodeQueryImpl;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.entity.MultiTaskResultMsg;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.entity.NodeMsg;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.service.OmLoginService;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.util.AsyncBatchAuthUtil;
import com.huawei.ism.tool.obase.entity.A800Node;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DmeNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiNodeUpdateTask
implements Callable<TaskResult> {
    private static final Logger log = LoggerFactory.getLogger(AiNodeUpdateTask.class);
    private final ProgressDialog progressDialog;
    private final List<AiDevNode> updateNodes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskResult call() throws Exception {
        TaskResult result = new TaskResult(TaskResult.Result.SUCCESS);
        try {
            List<NodeMsg> results = this.batchUpdate();
            if (results.isEmpty()) {
                TaskResult taskResult = result;
                return taskResult;
            }
            result.setResult(TaskResult.Result.FAILED);
            result.setResultObject((Object)new MultiTaskResultMsg(results));
            TaskResult taskResult = result;
            return taskResult;
        }
        finally {
            this.progressDialog.dispose();
        }
    }

    private List<NodeMsg> batchUpdate() throws ToolException {
        ArrayList<NodeMsg> results = new ArrayList<NodeMsg>();
        for (AiDevNode updateNode : this.updateNodes) {
            if (!(this.updateDme(updateNode) && this.updateA800(updateNode) && this.updateOm(updateNode))) {
                results.add(new NodeMsg(false, updateNode.getIp(), ResourceUtil.getString((String)"device.config.changed")));
                continue;
            }
            DefaultNodeProviderImpl.getInstance().modifyDevice((DevNode)updateNode);
        }
        return results;
    }

    private boolean updateOm(AiDevNode updateNode) {
        List omNodes = updateNode.getOmNodes();
        if (this.hasNoUser(omNodes)) {
            return true;
        }
        Future submit = AsyncExcutor.submit((Callable)new OmLoginService(null, omNodes, null));
        return this.waitResult(submit);
    }

    private boolean waitResult(Future<TaskResult> submit) {
        try {
            TaskResult taskResult = submit.get();
            return TaskResult.Result.SUCCESS.equals((Object)taskResult.getResult());
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("get batch update om result failed", (Throwable)e);
            return false;
        }
    }

    private boolean updateA800(AiDevNode updateNode) {
        for (A800Node a800Node : updateNode.getA800Nodes()) {
            List zones = a800Node.getZones();
            if (this.hasNoUser(zones)) continue;
            TaskResult taskResult = AsyncBatchAuthUtil.batchAsyncAuth(zones, this::doAuth);
            Object resultObject = taskResult.getResultObject();
            if (AiNodeUpdateTask.hasFailedNode(resultObject)) {
                return false;
            }
            a800Node.setProductVersion(((DmeNode)zones.get(0)).getProductVersion());
        }
        return true;
    }

    private static boolean hasFailedNode(Object resultObject) {
        return resultObject instanceof MultiTaskResultMsg && ((MultiTaskResultMsg)resultObject).getResults().stream().anyMatch(nodeResult -> !nodeResult.isSuccess());
    }

    private TaskResult doAuth(DevNode zone) {
        return new DeviceManageService().addDeviceParallel(this.progressDialog, zone, true);
    }

    private boolean hasNoUser(List<DmeNode> zones) {
        return zones.stream().noneMatch(node -> node.getLoginUser() != null);
    }

    private boolean updateDme(AiDevNode oldNode) {
        AiDevNode newNode = new AiDevNode();
        newNode.setIp(oldNode.getIp());
        newNode.setPort(oldNode.getPort());
        newNode.setLoginUser(oldNode.getLoginUser());
        TaskResult taskResult = new DmeNodeQueryImpl().queryNodeInfo((DevNode)newNode, DeviceOpr.ADD);
        if (TaskResult.Result.SUCCESS.equals((Object)taskResult.getResult())) {
            this.updateProperties(oldNode, newNode);
            if (this.hasA800Changed(oldNode, newNode)) {
                return false;
            }
            return !this.haOmChanged(oldNode, newNode);
        }
        return false;
    }

    private void updateProperties(AiDevNode oldNode, AiDevNode newNode) {
        this.updateA800(oldNode, newNode);
    }

    private void updateA800(AiDevNode oldNode, AiDevNode newNode) {
        Map idNodeMap = newNode.getA800Nodes().stream().collect(Collectors.toMap(DevNode::getUuid, Function.identity()));
        for (A800Node a800Node : oldNode.getA800Nodes()) {
            A800Node newA800 = (A800Node)idNodeMap.get(a800Node.getUuid());
            if (Objects.isNull(newA800)) {
                log.warn("newA800 node :{} sn :{} id:{} not found in new dme", new Object[]{a800Node.getIp(), a800Node.getDeviceSerialNumber(), a800Node.getUuid()});
                continue;
            }
            this.copyA800Properties(a800Node, newA800);
        }
    }

    private void copyA800Properties(A800Node a800Node, A800Node newA800) {
        AiNodeUpdateTask.copyProperties((DevNode)a800Node, (DevNode)newA800);
        Map idNodeMap = newA800.getZones().stream().collect(Collectors.toMap(DevNode::getUuid, Function.identity()));
        for (DmeNode zone : a800Node.getZones()) {
            DmeNode newZone = (DmeNode)idNodeMap.get(zone.getUuid());
            if (Objects.isNull(newZone)) {
                log.warn("zone node :{} sn :{} id:{} not found in new dme", new Object[]{zone.getIp(), zone.getDeviceSerialNumber(), zone.getUuid()});
                continue;
            }
            AiNodeUpdateTask.copyProperties((DevNode)zone, (DevNode)newZone);
        }
    }

    private static void copyProperties(DevNode oldNode, DevNode newNode) {
        oldNode.setProductModel(newNode.getProductModel());
        oldNode.setProductVersion(newNode.getProductVersion());
        oldNode.setProductSubVersion(newNode.getProductSubVersion());
        oldNode.setDeviceSerialNumber(newNode.getDeviceSerialNumber());
    }

    private boolean haOmChanged(AiDevNode oldNode, AiDevNode newNode) {
        return newNode.getOmNodes().stream().map(DevNode::getUuid).collect(Collectors.toSet()).size() != oldNode.getOmNodes().stream().map(DevNode::getUuid).collect(Collectors.toSet()).size();
    }

    private boolean hasA800Changed(AiDevNode oldNode, AiDevNode newNode) {
        return !this.checkA800Match(newNode, oldNode) && !this.checkZoneMatch(oldNode, newNode);
    }

    private boolean checkZoneMatch(AiDevNode oldNode, AiDevNode newNode) {
        Map idNodeMap = newNode.getA800Nodes().stream().collect(Collectors.toMap(DevNode::getUuid, Function.identity()));
        for (A800Node a800Node : oldNode.getA800Nodes()) {
            A800Node newA800 = (A800Node)idNodeMap.get(a800Node.getUuid());
            if (!Objects.isNull(newA800) && this.checkZoneMatch(a800Node, newA800)) continue;
            return false;
        }
        return true;
    }

    private boolean checkZoneMatch(A800Node a800Node, A800Node newA800) {
        return a800Node.getZones().stream().map(DevNode::getDeviceSerialNumber).collect(Collectors.toSet()).size() == newA800.getZones().stream().map(DevNode::getDeviceSerialNumber).collect(Collectors.toSet()).size();
    }

    private boolean checkA800Match(AiDevNode newNode, AiDevNode oldNode) {
        return newNode.getA800Nodes().stream().map(DevNode::getDeviceSerialNumber).collect(Collectors.toSet()).size() == oldNode.getA800Nodes().stream().map(DevNode::getDeviceSerialNumber).collect(Collectors.toSet()).size();
    }

    public AiNodeUpdateTask(ProgressDialog progressDialog, List<AiDevNode> updateNodes) {
        this.progressDialog = progressDialog;
        this.updateNodes = updateNodes;
    }
}

