/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.action;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.devicemanager.utils.LogUtils;
import com.huawei.ism.tool.framework.platform.util.XmlEnums;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DeviceListExportOperator {
    public static final String ROOT_NODE = "devicelist";
    public static final String DEVICE_NODE = "device";
    public static final String DEVICE_TYPE_NODE = "deviceType";
    public static final String DEVICE_NAME_NODE = "deviceName";
    public static final String DEVICE_IPADDRESS_NODE = "ipAddress";
    public static final String DEVICE_SERIALNUMBER_NODE = "serialNumber";
    public static final String DEVICE_USERNAME_NODE = "username";
    public static final String DEVICE_PASSWORD_NODE = "password";
    public static final String PRODUCT_VERSION_NODE = "productVersion";
    public static final String DEVICE_PORT_NODE = "port";
    public static final String DEVICE_DEVELOPER_PWD = "developer";
    public static final String SOCKS5_NODE = "socks5Proxy";
    public static final String SOCKS5_NAME_NODE = "socks5name";
    public static final String SOCKS5_USER_NODE = "socks5user";
    public static final String SOCKS5_PASS_NODE = "socks5pass";
    public static final String SOCKS5_PORT_NODE = "socks5port";
    public static final String SOCKS5SERVICEIP_NODE = "socks5serviceip";
    public static final String SSHS_NODE = "sshForwardList";
    public static final String SSH_NODE = "sshForward";
    public static final String SSH_HOST_NODE = "sshhost";
    public static final String SSH_USER_NODE = "sshuser";
    public static final String SSH_PASS_NODE = "sshpass";
    public static final String SSH_PORT_NODE = "sshport";
    public static final String SSH_NAME = "sshname";
    private static DocumentBuilder builder;
    private Document doc;
    private String exportPath;
    private Collection<DevNode> deviceList;

    public DeviceListExportOperator(String exportPath, Collection<DevNode> deviceList) {
        this.exportPath = exportPath;
        this.deviceList = deviceList;
        this.doc = builder.newDocument();
    }

    public DeviceListExportOperator(Document docment) {
        this.doc = docment;
    }

    public boolean export() {
        Element root = this.doc.createElement(ROOT_NODE);
        for (DevNode device : this.deviceList) {
            Element deviceNode = this.device2Element(device);
            root.appendChild(deviceNode);
            LogUtils.addOperaLog("operalog.name.expdevice", device, "");
        }
        this.doc.appendChild(root);
        this.saveDocument(this.exportPath);
        return true;
    }

    public Element device2Element(DevNode device) {
        Element deviceNode = this.doc.createElement(DEVICE_NODE);
        Element deviceType = this.doc.createElement(DEVICE_TYPE_NODE);
        Element productVersion = this.doc.createElement(PRODUCT_VERSION_NODE);
        Element deviceName = this.doc.createElement(DEVICE_NAME_NODE);
        Element ipAddress = this.doc.createElement(DEVICE_IPADDRESS_NODE);
        Element serailNumber = this.doc.createElement(DEVICE_SERIALNUMBER_NODE);
        Element username = this.doc.createElement(DEVICE_USERNAME_NODE);
        Element password = this.doc.createElement(DEVICE_PASSWORD_NODE);
        Element port = this.doc.createElement(DEVICE_PORT_NODE);
        Element developerPwd = this.doc.createElement(DEVICE_DEVELOPER_PWD);
        Element socks5 = this.doc.createElement(SOCKS5_NODE);
        Element socks5Name = this.doc.createElement(SOCKS5_NAME_NODE);
        Element socks5User = this.doc.createElement(SOCKS5_USER_NODE);
        Element socks5Pass = this.doc.createElement(SOCKS5_PASS_NODE);
        Element socks5Port = this.doc.createElement(SOCKS5_PORT_NODE);
        Element socks5ServiceIP = this.doc.createElement(SOCKS5SERVICEIP_NODE);
        Element sshs = this.doc.createElement(SSHS_NODE);
        deviceName.setTextContent(device.getDeviceName());
        deviceType.setTextContent(device.getDeviceType().toString());
        productVersion.setTextContent(device.getProductVersion());
        ipAddress.setTextContent(device.getIp());
        serailNumber.setTextContent(device.getDeviceSerialNumber());
        username.setTextContent(device.getLoginUser().getUserName());
        String encodePassword = this.getEncodePass(device.getLoginUser().getPassword());
        String debugPwd = device.getDeveloperPwd();
        String encodeDeveloperPwd = this.getEncodePass(debugPwd);
        this.encodeAndXML(device, password, port, developerPwd, socks5, socks5Name, socks5User, socks5Pass, socks5Port, socks5ServiceIP, encodePassword, encodeDeveloperPwd);
        this.sshJump(device, deviceNode, deviceType, productVersion, deviceName, ipAddress, serailNumber, username, password, port, developerPwd, socks5, sshs);
        return deviceNode;
    }

    private void encodeAndXML(DevNode device, Element password, Element port, Element developerPwd, Element socks5, Element socks5Name, Element socks5User, Element socks5Pass, Element socks5Port, Element socks5ServiceIP, String encodePassword, String encodeDeveloperPwd) {
        developerPwd.setTextContent(encodeDeveloperPwd);
        password.setTextContent(encodePassword);
        port.setTextContent(String.valueOf(device.getPort()));
        if (null != device.getSocks5Proxy()) {
            String socks5Password = this.getEncodePass(device.getSocks5Proxy().getPass());
            socks5Name.setTextContent(device.getSocks5Proxy().getName());
            socks5Pass.setTextContent(socks5Password);
            socks5User.setTextContent(device.getSocks5Proxy().getUser());
            socks5Port.setTextContent(device.getSocks5Proxy().getPort());
            socks5ServiceIP.setTextContent(device.getSocks5Proxy().getServerIp());
            socks5.appendChild(socks5Name);
            socks5.appendChild(socks5Pass);
            socks5.appendChild(socks5User);
            socks5.appendChild(socks5Port);
            socks5.appendChild(socks5ServiceIP);
        }
    }

    private void sshJump(DevNode device, Element deviceNode, Element deviceType, Element productVersion, Element deviceName, Element ipAddress, Element serailNumber, Element username, Element password, Element port, Element developerPwd, Element socks5, Element sshs) {
        if (null != device.getSshForwardList()) {
            for (MultiRouteNode sshForward : device.getSshForwardList()) {
                String pwd = sshForward.getPwd();
                Element ssh = this.doc.createElement(SSH_NODE);
                Element sshHost = this.doc.createElement(SSH_HOST_NODE);
                Element sshUser = this.doc.createElement(SSH_USER_NODE);
                Element sshPass = this.doc.createElement(SSH_PASS_NODE);
                Element sshPort = this.doc.createElement(SSH_PORT_NODE);
                sshHost.setTextContent(sshForward.getHost());
                sshUser.setTextContent(sshForward.getUname());
                sshPass.setTextContent(this.getEncodePass(pwd));
                sshPort.setTextContent(String.valueOf(sshForward.getPort()));
                ssh.appendChild(sshHost);
                ssh.appendChild(sshUser);
                ssh.appendChild(sshPass);
                ssh.appendChild(sshPort);
                sshs.appendChild(ssh);
                pwd = null;
            }
            Element sshName = this.doc.createElement(SSH_NAME);
            sshName.setTextContent(device.getSshName());
            sshs.appendChild(sshName);
        }
        deviceNode.appendChild(deviceType);
        deviceNode.appendChild(productVersion);
        deviceNode.appendChild(deviceName);
        deviceNode.appendChild(ipAddress);
        deviceNode.appendChild(serailNumber);
        deviceNode.appendChild(username);
        deviceNode.appendChild(password);
        deviceNode.appendChild(port);
        deviceNode.appendChild(developerPwd);
        deviceNode.appendChild(socks5);
        deviceNode.appendChild(sshs);
    }

    private String getEncodePass(String pass) {
        String encodePassW = "";
        if (StringUtils.isNULLStr((String)pass)) {
            return "";
        }
        try {
            encodePassW = AESEncrypt.encrypt((String)pass);
            return encodePassW;
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("", (Throwable)e);
            return encodePassW;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveDocument(String filePath) {
        FileOutputStream file = null;
        try {
            Transformer transformer = XmlUtils.newTransformer();
            DOMSource source = new DOMSource(this.doc);
            transformer.setOutputProperty("{" + XmlEnums.XSLT.getResourceValue() + "}indent-amount", "2");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("standalone", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(buf);
            transformer.transform(source, result);
            file = new FileOutputStream(filePath);
            file.write(buf.toByteArray());
            transformer.transform(source, result);
        }
        catch (TransformerException mye) {
            LoggerFactory.getLogger(this.getClass()).error("", (Throwable)mye);
        }
        catch (IOException exp) {
            LoggerFactory.getLogger(this.getClass()).error("", (Throwable)exp);
        }
        finally {
            try {
                if (null != file) {
                    file.close();
                }
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("", (Throwable)e);
            }
        }
    }

    static {
        DocumentBuilderFactory factory = XmlUtils.getIgnoreWhitespaceDocBuilderFactory();
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LoggerFactory.getLogger(DeviceListExportOperator.class).error("Init dom builder error.", (Throwable)e);
        }
    }
}

