/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.action;

import com.huawei.ism.tool.devicemanager.utils.DeviceContext;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.JComboBox;
import org.slf4j.Logger;

public class SelKeyAction
implements ActionListener {
    private Window parent;
    private JComboBox<String> box;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SelKeyAction.class);

    public SelKeyAction(Window parent, JComboBox<String> box) {
        this.parent = parent;
        this.box = box;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.selKeyFile();
    }

    private void selKeyFile() {
        HashMap<String, String> extParams = new HashMap<String, String>();
        extParams.put("title", ResourceUtil.getString((String)"device.adddialog.key.select"));
        extParams.put("PathId", "select_keyfile_id");
        extParams.put("description", " ");
        File keyfile = ToolFileChooser.selectFile((Window)this.parent, (String[])new String[]{""}, (int)0, (boolean)true, extParams);
        if (keyfile == null) {
            return;
        }
        if (keyfile.length() > 10240L) {
            DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"device.adddialog.key.select.error"));
            return;
        }
        String name = keyfile.getName();
        boolean overWrite = false;
        if (DeviceContext.getInstance().getKeyNames().containsKey(name)) {
            WarningDialog warningDialog = DialogUtils.showYesNoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"device.adddialog.key.select.exist"));
            if (0 != warningDialog.getValue()) {
                return;
            }
            overWrite = true;
        }
        if (!overWrite) {
            this.box.addItem(name);
        }
        this.box.setSelectedItem(name);
        try {
            DeviceContext.getInstance().saveKeyName(keyfile.getName(), keyfile.getCanonicalPath());
        }
        catch (IOException e) {
            LOGGER.error("get path error.", (Throwable)e);
        }
    }
}

