/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog;

import com.huawei.ism.tool.devicemanager.enums.LoginStep;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.dialog.AiStorageAddDialog;
import com.huawei.ism.tool.devicemanager.ui.dialog.layout.AbstractAddDeviceLayout;
import com.huawei.ism.tool.devicemanager.ui.dialog.layout.AbstractLoginPanel;
import com.huawei.ism.tool.devicemanager.ui.dialog.layout.aistorage.DmeLoginPanel;
import com.huawei.ism.tool.devicemanager.ui.dialog.layout.aistorage.OmLoginPanel;
import com.huawei.ism.tool.devicemanager.ui.dialog.layout.aistorage.ZoneLoginPanel;
import com.huawei.ism.tool.devicemanager.ui.dialog.listener.NextBtnActionListener;
import com.huawei.ism.tool.devicemanager.ui.former.DeviceSaveServiceFactory;
import com.huawei.ism.tool.devicemanager.ui.listener.verify.VerifyResult;
import com.huawei.ism.tool.devicemanager.utils.LogUtils;
import com.huawei.ism.tool.obase.entity.A800Node;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DmeNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiStorageAddLayout
extends AbstractAddDeviceLayout {
    private static final Logger log = LoggerFactory.getLogger(AiStorageAddLayout.class);
    private final DmeLoginPanel dmeLoginPanel = new DmeLoginPanel();
    private final ZoneLoginPanel a800LoginPanel = new ZoneLoginPanel();
    private final OmLoginPanel omLoginPanel = new OmLoginPanel();
    private final Map<LoginStep, AbstractLoginPanel> stepShowPanel = new HashMap<LoginStep, AbstractLoginPanel>();
    private final JButton previousBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.lastbtn"), (char)'P');
    private final JButton nextBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.nextbtn"), (char)'N');
    private final JButton cancelBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.cancelbtn"), (char)'C');
    private final JPanel viewPanel = new JPanel();
    private final AiStorageAddDialog parent;
    private final List<LoginStep> bakTotalStep;
    private List<LoginStep> totalStep;
    private LoginStep currentStep;

    public AiStorageAddLayout(AiStorageAddDialog parent) {
        this(parent, Arrays.asList(LoginStep.values()));
    }

    public AiStorageAddLayout(AiStorageAddDialog parent, List<LoginStep> totalStep) {
        this.totalStep = totalStep;
        this.bakTotalStep = new ArrayList<LoginStep>(totalStep);
        this.currentStep = totalStep.get(0);
        this.cacheStepWithPanel();
        this.parent = parent;
        this.initUi();
        this.previousBtn.setVisible(false);
        this.updateTitle();
    }

    private void cacheStepWithPanel() {
        this.stepShowPanel.put(LoginStep.DME_LOGIN, this.dmeLoginPanel);
        this.stepShowPanel.put(LoginStep.ZONE_LOGIN, this.a800LoginPanel);
        this.stepShowPanel.put(LoginStep.OM_LOGIN, this.omLoginPanel);
    }

    private void initUi() {
        this.updateNextBtn();
        JComponent btnPan = UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildHBoxRight((Component[])new Component[]{this.previousBtn, this.nextBtn, this.cancelBtn, Box.createHorizontalStrut(0)}), Box.createHorizontalStrut(0)});
        this.setLayout(new BorderLayout());
        this.viewPanel.add(this.stepShowPanel.get((Object)this.currentStep));
        this.add((Component)this.viewPanel, "Center");
        this.add((Component)btnPan, "South");
        UiMethod.setComponentSize((Dimension)new Dimension(415, 460), (Component[])new Component[]{this.dmeLoginPanel, this.a800LoginPanel, this.omLoginPanel});
    }

    @Override
    public JButton getDefaultButton() {
        return this.nextBtn;
    }

    @Override
    public void bindListener() {
        this.nextBtn.addActionListener(new NextBtnActionListener(this));
        this.previousBtn.addActionListener(event -> {
            Object source = event.getSource();
            if (source instanceof JButton) {
                log.info("click previous button");
                this.updateViewByAction((JButton)source);
            }
        });
        this.cancelBtn.addActionListener(e -> this.parent.dispose());
        this.a800LoginPanel.bindListener(this.parent);
        this.omLoginPanel.bindListener(this.parent);
    }

    public void updateViewByAction(JButton source) {
        if (this.nextBtn.equals(source) && this.isLastStep()) {
            if (this.verifyNodeAddFailed(this.dmeLoginPanel.getDevNode())) {
                return;
            }
            this.cacheNode();
            this.parent.dispose();
            return;
        }
        this.updateShowPanel(source);
        this.updateNextBtn();
        this.updateTitle();
    }

    private void cacheNode() {
        AiDevNode devNode = this.dmeLoginPanel.getDevNode();
        try {
            if (devNode == null) {
                log.info("finish node login, node not from dmeLoginPanel");
                return;
            }
            if (this.isRepeatAdd(devNode)) {
                throw new ToolException("devicemanager.layout.device.add.deviceadddialog.deviceduplicate", new Object[]{devNode.getIp(), devNode.getDeviceSerialNumber()});
            }
            LogUtils.addOperaLog("operalog.name.adddevice", (DevNode)devNode, "");
            devNode.getA800Nodes().stream().filter(a800Node -> !CollectionUtil.isEmpty((Collection)a800Node.getZones())).forEach(a800Node -> a800Node.setProductVersion(((DmeNode)a800Node.getZones().get(0)).getProductVersion()));
            DefaultNodeProviderImpl.getInstance().addNode((DevNode)devNode);
            log.info("finish node login, node from dmeLoginPanel");
        }
        catch (ToolException e) {
            TaskResult taskResult = new TaskResult(TaskResult.Result.FAILED);
            taskResult.setErrorLocaleDescription(e.getErrorLocaleDescription());
            LogUtils.addOperaLog("operalog.name.adddevice", (DevNode)devNode, taskResult);
            DialogUtils.showErrorDialog((JDialog)this.parent, (String)e.getErrorLocaleDescription());
        }
    }

    private boolean isRepeatAdd(AiDevNode devNode) {
        return DefaultNodeProviderImpl.getInstance().isContainsNode((DevNode)devNode);
    }

    private void updateTitle() {
        this.parent.setTitle(ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.step.title", (Object[])new Object[]{this.totalStep.size(), this.totalStep.indexOf((Object)this.currentStep) + 1, this.currentStep.getDesc()}));
    }

    private void updateShowPanel(JButton source) {
        if (source.equals(this.nextBtn)) {
            this.toNextStep();
        }
        if (source.equals(this.previousBtn)) {
            this.toPreviousStep();
        }
    }

    private void updateNextBtn() {
        if (this.isLastStep()) {
            this.nextBtn.setText(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.okbtn"));
            this.nextBtn.setMnemonic('F');
        } else {
            this.nextBtn.setText(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.nextbtn"));
            this.nextBtn.setMnemonic('N');
        }
    }

    private boolean isLastStep() {
        return this.totalStep.indexOf((Object)this.currentStep) == this.totalStep.size() - 1;
    }

    private void toNextStep() {
        this.currentStep = this.findNextStep();
        this.showCurrentStep();
        if (!this.previousBtn.isVisible()) {
            this.previousBtn.setVisible(true);
        }
    }

    private LoginStep findNextStep() {
        if (this.totalStep.indexOf((Object)this.currentStep) >= this.totalStep.size() - 1) {
            return this.currentStep;
        }
        return this.totalStep.get(this.totalStep.indexOf((Object)this.currentStep) + 1);
    }

    private void toPreviousStep() {
        this.currentStep = this.findPreviousStep();
        this.showCurrentStep();
        if (this.isFirstStep() && this.previousBtn.isVisible()) {
            this.previousBtn.setVisible(false);
        }
    }

    private boolean isFirstStep() {
        return this.totalStep.indexOf((Object)this.currentStep) == 0;
    }

    private LoginStep findPreviousStep() {
        if (this.totalStep.indexOf((Object)this.currentStep) == 0) {
            return this.currentStep;
        }
        return this.totalStep.get(this.totalStep.indexOf((Object)this.currentStep) - 1);
    }

    private void showCurrentStep() {
        this.stepShowPanel.values().forEach(this.viewPanel::remove);
        this.viewPanel.add(this.stepShowPanel.get((Object)this.currentStep));
        this.repaint();
    }

    public boolean process() {
        AbstractLoginPanel abstractLoginPanel = this.stepShowPanel.get((Object)this.currentStep);
        boolean process = abstractLoginPanel.process(this.parent);
        if (abstractLoginPanel instanceof DmeLoginPanel && process) {
            AiDevNode devNode = ((DmeLoginPanel)abstractLoginPanel).getDevNode();
            List<LoginStep> newSteps = this.buildTotalSteps(devNode);
            if (!CollectionUtil.isEmpty((Collection)devNode.getA800Nodes())) {
                this.a800LoginPanel.setShowData(devNode.getA800Nodes());
            }
            if (!CollectionUtil.isEmpty((Collection)devNode.getOmNodes())) {
                this.omLoginPanel.setShowData(devNode.getOmNodes());
            }
            this.setTotalStep(newSteps);
        }
        return process;
    }

    @NotNull
    private List<LoginStep> buildTotalSteps(AiDevNode devNode) {
        ArrayList<LoginStep> newSteps = new ArrayList<LoginStep>(this.bakTotalStep);
        if (CollectionUtil.isEmpty((Collection)devNode.getA800Nodes())) {
            newSteps.remove((Object)LoginStep.ZONE_LOGIN);
        }
        if (CollectionUtil.isEmpty((Collection)devNode.getOmNodes())) {
            newSteps.remove((Object)LoginStep.OM_LOGIN);
        }
        return newSteps;
    }

    private boolean verifyNodeAddFailed(AiDevNode devNode) {
        if (devNode == null) {
            return false;
        }
        VerifyResult result = DeviceSaveServiceFactory.buildServiceByScene().map(service -> service.verifyNodeAdd((DevNode)devNode)).orElse(new VerifyResult());
        if (result.isVerifySuccess()) {
            return false;
        }
        TaskResult taskResult = new TaskResult(TaskResult.Result.FAILED);
        taskResult.setErrorLocaleDescription(result.getMsg());
        if (result.isUserConfirm()) {
            WarningDialog warningDialog = DialogUtils.showWarnConfirmDialog((Window)this.parent, (String)result.getMsg(), (String)ResourceUtil.getString((String)"confirm.message"));
            log.info("verify failed, user confirm for value :{}", (Object)warningDialog.getValue());
            if (warningDialog.getValue() != 0) {
                LogUtils.addOperaLog("operalog.name.adddevice", (DevNode)devNode, taskResult);
                return true;
            }
            return false;
        }
        LogUtils.addOperaLog("operalog.name.adddevice", (DevNode)devNode, taskResult);
        DialogUtils.showInfoDialog((JDialog)this.parent, (String)result.getMsg());
        return true;
    }

    public void setZoneData(List<A800Node> a800Nodes) {
        this.a800LoginPanel.setShowData(a800Nodes);
    }

    public void setOmData(List<DmeNode> omNodes) {
        this.omLoginPanel.setShowData(omNodes);
    }

    public void setTotalStep(List<LoginStep> totalStep) {
        this.totalStep = totalStep;
    }

    public LoginStep getCurrentStep() {
        return this.currentStep;
    }
}

