/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.ui.context.DeviceSceneContext;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;

public class HyperMetroDevTipsDialog
extends IsmDialog {
    private static final Logger LOG = ToolLoggerFactory.getLogger(HyperMetroDevTipsDialog.class);
    private static final long serialVersionUID = -2587908427263722274L;
    private DefaultTableModel topModel = null;
    private DefaultTableModel topModel4Nas = null;
    private IsmTable topTable = null;
    private IsmTable topTable4Nas = null;
    private JButton oKButton;
    private JButton cancelButton;
    private boolean okPerformed = false;
    private JComponent content;
    private JComponent topDescPane;
    private JComponent midDescPane;
    private TableScrollPane topScrollPane;
    private TableScrollPane topScrollPane4Nas;
    private String msg = ResourceUtil.getString((String)"hypermetrodevtipsdialog.message");
    private String msg4Nas = ResourceUtil.getString((String)"hypermetrodevtipsdialog.message4nas");
    private String btnInfo = ResourceUtil.getString((String)"hypermetrodevtipsdialog.button.info");
    private String[] tableTitles = new String[]{ResourceUtil.getString((String)"hypermetrodevtipsdialog.table.header.name"), ResourceUtil.getString((String)"hypermetrodevtipsdialog.table.header.ip"), ResourceUtil.getString((String)"hypermetrodevtipsdialog.table.header.sn"), ResourceUtil.getString((String)"hypermetrodevtipsdialog.table.header.result")};
    private String[] tableTitles4Nas = new String[]{ResourceUtil.getString((String)"hypermetrodevtipsdialog.table.header.tip.ip"), ResourceUtil.getString((String)"hypermetrodevtipsdialog.table.header.tip.devicetype"), ResourceUtil.getString((String)"hypermetrodevtipsdialog.table.header.tip.sn"), ResourceUtil.getString((String)"hypermetrodevtipsdialog.table.header.tip.retip"), ResourceUtil.getString((String)"hypermetrodevtipsdialog.table.header.tip.retdevicetype"), ResourceUtil.getString((String)"hypermetrodevtipsdialog.table.header.tip.retsn")};

    public HyperMetroDevTipsDialog(Window parent, Map<DevNode, String> result, Map<DevNode, List<List<String>>> result4Nas) {
        super(parent);
        this.setModal(true);
        this.setTitle(ResourceUtil.getString((String)"hypermetrodevtipsdialog.title"));
        this.doLayoutPane(result, result4Nas);
        this.initData(result, result4Nas);
        this.addListener();
        this.toFront();
        this.setResizable(false);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)((Object)this));
        this.setIconImage(ResourceManager.DEFAULT_ICON.getImage());
        this.pack();
        SwingUtil.putParentCenter((Window)((Object)this), (Window)parent);
    }

    private void initData(Map<DevNode, String> result, Map<DevNode, List<List<String>>> result4Nas) {
        DefaultTableRow tableRows;
        if (result.isEmpty() && result4Nas.isEmpty()) {
            return;
        }
        if (!result.isEmpty()) {
            ArrayList datas = new ArrayList();
            for (Map.Entry<DevNode, String> entry : result.entrySet()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                DevNode dev = entry.getKey();
                arrayList.add(dev.getDeviceName());
                arrayList.add(dev.getIp());
                arrayList.add(dev.getDeviceSerialNumber());
                arrayList.add(entry.getValue());
                datas.add(arrayList);
            }
            ArrayList tableDatas = new ArrayList();
            for (List list : datas) {
                tableRows = new DefaultTableRow(4, (Object)"", (Object)StringUtils.getNoStripUUID());
                tableRows.setValues(list);
                tableDatas.add(tableRows);
            }
            this.getTopModel().setTableData(tableDatas.toArray(new TableRow[tableDatas.size()]));
        }
        if (!result4Nas.isEmpty()) {
            ArrayList datas4Nas = new ArrayList();
            for (Map.Entry entry : result4Nas.entrySet()) {
                DevNode devNode = (DevNode)entry.getKey();
                for (List snipList : (List)entry.getValue()) {
                    ArrayList<String> data = new ArrayList<String>();
                    data.add(devNode.getIp());
                    data.add(devNode.getDeviceType().toString());
                    data.add(devNode.getDeviceSerialNumber());
                    data.add((String)snipList.get(0));
                    data.add((String)snipList.get(1));
                    data.add((String)snipList.get(2));
                    datas4Nas.add(data);
                }
            }
            ArrayList<DefaultTableRow> tableDatas4Nas = new ArrayList<DefaultTableRow>();
            for (List list : datas4Nas) {
                tableRows = new DefaultTableRow(6, (Object)"", (Object)StringUtils.getNoStripUUID());
                tableRows.setValues(list);
                tableDatas4Nas.add(tableRows);
            }
            this.getTopModel4().setTableData(tableDatas4Nas.toArray(new TableRow[tableDatas4Nas.size()]));
        }
    }

    private void addListener() {
        this.oKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HyperMetroDevTipsDialog.this.okPerformed = true;
                HyperMetroDevTipsDialog.this.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HyperMetroDevTipsDialog.this.okPerformed = false;
                HyperMetroDevTipsDialog.this.dispose();
            }
        });
    }

    private JComponent buildDescArea(String ... errMsgs) {
        Box contentArea = Box.createVerticalBox();
        for (String errMsg : errMsgs) {
            Box line = Box.createHorizontalBox();
            line.add(new JLabel(errMsg));
            line.add(Box.createHorizontalGlue());
            contentArea.add(line);
        }
        return contentArea;
    }

    private void doLayoutPane(Map<DevNode, String> result, Map<DevNode, List<List<String>>> result4Nas) {
        this.topModel = new DefaultTableModel(this.tableTitles, new int[0]);
        this.topTable = new IsmTable((TableModel)this.topModel);
        this.topScrollPane = TableScrollPane.createTablePane((IsmTable)this.topTable, (boolean)false, (TableScrollPane.CountArea)TableScrollPane.CountArea.NONE, (TableScrollPane.FilterArea)TableScrollPane.FilterArea.NONE, (TableScrollPane.ButtonArea)TableScrollPane.ButtonArea.NONE);
        this.topTable.getColumnModel().getColumn(0).setPreferredWidth(160);
        this.topTable.getColumnModel().getColumn(1).setPreferredWidth(160);
        this.topTable.getColumnModel().getColumn(2).setPreferredWidth(180);
        this.topTable.getColumnModel().getColumn(3).setPreferredWidth(300);
        this.topScrollPane.setPreferredSize(new Dimension(800, 200));
        this.topModel4Nas = new DefaultTableModel(this.tableTitles4Nas, new int[0]);
        this.topTable4Nas = new IsmTable((TableModel)this.topModel4Nas);
        this.topScrollPane4Nas = TableScrollPane.createTablePane((IsmTable)this.topTable4Nas, (boolean)false, (TableScrollPane.CountArea)TableScrollPane.CountArea.NONE, (TableScrollPane.FilterArea)TableScrollPane.FilterArea.NONE, (TableScrollPane.ButtonArea)TableScrollPane.ButtonArea.NONE);
        this.topTable4Nas.getColumnModel().getColumn(0).setPreferredWidth(115);
        this.topTable4Nas.getColumnModel().getColumn(1).setPreferredWidth(115);
        this.topTable4Nas.getColumnModel().getColumn(2).setPreferredWidth(170);
        this.topTable4Nas.getColumnModel().getColumn(3).setPreferredWidth(115);
        this.topTable4Nas.getColumnModel().getColumn(4).setPreferredWidth(115);
        this.topTable4Nas.getColumnModel().getColumn(5).setPreferredWidth(170);
        this.topScrollPane4Nas.setPreferredSize(new Dimension(800, 200));
        if (Collections.singletonList("ReplacingCertificates").equals(DeviceSceneContext.getInstance().getToolList())) {
            this.msg = ResourceUtil.getString((String)"hypermetrodevtipsdialog.replaceCert.message");
        }
        JComponent helpInfoPane = this.buildDescArea(this.btnInfo);
        this.topDescPane = this.buildDescArea(this.msg);
        this.midDescPane = this.buildDescArea(this.msg4Nas);
        if (!result.isEmpty() && result4Nas.isEmpty()) {
            this.content = UCD.buildVerticalBox(null, (Component[])new Component[]{this.topDescPane, this.topScrollPane, helpInfoPane});
        }
        if (result.isEmpty() && !result4Nas.isEmpty()) {
            this.content = UCD.buildVerticalBox(null, (Component[])new Component[]{this.midDescPane, this.topScrollPane4Nas, helpInfoPane});
        }
        if (!result.isEmpty() && !result4Nas.isEmpty()) {
            this.content = UCD.buildVerticalBox(null, (Component[])new Component[]{this.topDescPane, this.topScrollPane, this.midDescPane, this.topScrollPane4Nas, helpInfoPane});
        }
        this.content = UiMethod.buildFrameSpace((JComponent)this.content, (int)12);
        this.getContentPane().add(this.content);
        this.oKButton = UCD.createButton((String)ResourceUtil.getString((String)"hypermetrodevtipsdialog.button.ok"), (char)'I');
        this.cancelButton = UCD.createButton((String)ResourceUtil.getString((String)"hypermetrodevtipsdialog.button.cancel"), (char)'B');
        JComponent btnArea = UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalGlue(), this.oKButton, this.cancelButton});
        this.getSouthBox().add(btnArea);
    }

    public DefaultTableModel getTopModel() {
        return this.topModel;
    }

    public DefaultTableModel getTopModel4() {
        return this.topModel4Nas;
    }

    public boolean isOkPerformed() {
        return this.okPerformed;
    }
}

