/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.ui.dialog.ScenePreparedMainJDialog;
import com.huawei.ism.tool.devicemanager.ui.former.DeviceSaveServiceFactory;
import com.huawei.ism.tool.devicemanager.ui.former.service.NodeSceneOptionService;
import com.huawei.ism.tool.devicemanager.utils.SceneParser;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.ISceneService;
import com.huawei.ism.tool.framework.pubservice.scenedata.ScenePrepareProxyRequest;
import com.huawei.ism.tool.framework.pubservice.scenedata.ScenePrepareProxyResponse;
import com.huawei.ism.tool.obase.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.util.SwingUtil;
import java.awt.Window;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import javax.swing.JDialog;
import org.slf4j.Logger;

public class ScenePreparedDialogProxy {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ScenePreparedDialogProxy.class);
    private Window parent = null;
    private boolean isEdit = true;
    private static final int INT900 = 900;
    private static final int INT450 = 450;
    private static final String TOOLKIT_PATH = ApplicationContext.getInstance().getWorkPath();

    public ScenePreparedDialogProxy(Window parent, boolean isEdit) {
        this.parent = parent;
        this.isEdit = isEdit;
    }

    public void openDialog() {
        try {
            String mainSceneID = SceneParser.getInstance().getMainScene();
            String sceneID = SceneParser.getInstance().getSubScene();
            if ("Upgrade".equals(mainSceneID) && "Upgrade".equals(sceneID)) {
                this.openUpgradeSceneSettingDialog();
            } else if ("Upgrade".equals(mainSceneID) && "Upgrade Check".equals(sceneID)) {
                this.openPreUpgradeSceneSettingDialog();
            } else if ("Upgrade".equals(mainSceneID) && "Upgrade_FSFW".equals(sceneID)) {
                this.openDsFWUpgSceneSettingDialog();
            } else {
                this.openCommonSettingDialog();
            }
        }
        catch (Exception e) {
            LOGGER.error("init overview dialog exception", (Throwable)e);
        }
        finally {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("the after toolkit path=" + TOOLKIT_PATH);
            }
            System.setProperty("user.dir", TOOLKIT_PATH);
            System.setProperty("tool.log.dir", "");
        }
    }

    private void openCommonSettingDialog() {
        LOGGER.info("enter openCommonSettingDialog");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("init toolkit path=" + TOOLKIT_PATH);
        }
        ScenePreparedMainJDialog dialog = new ScenePreparedMainJDialog(this.parent, this.isEdit);
        dialog.setSize(900, 450);
        SwingUtil.putScreenCenter((Window)dialog);
        dialog.setHelpActionCallBack(new OpenHelpCallBack(dialog));
        dialog.setVisible(true);
    }

    private void openUpgradeSceneSettingDialog() {
        LOGGER.info("enter openUpgradeSceneSettingDialog");
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("init toolkit path=" + TOOLKIT_PATH);
            }
            StringBuilder workDir = new StringBuilder().append(TOOLKIT_PATH).append(File.separator).append("tools").append(File.separator).append("ArrayUpgrade").append(File.separator);
            String jarPath = this.getJarPath(workDir.toString() + File.separator + "plugins", "ArrayUpgrade.jar");
            URL url = new URL("jar:file:" + File.separator + jarPath + "!/");
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("jar jarpath=" + jarPath + "url=" + url);
            }
            this.uninstallJar(url);
            URLClassLoader urlLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Class<URLClassLoader> sysclass = URLClassLoader.class;
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)urlLoader, url);
            System.setProperty("user.dir", workDir.toString());
            System.setProperty("tool.log.dir", TOOLKIT_PATH + File.separator + "log" + File.separator + "arrayUpgrade");
            Class<?> upgradeSceneSetting = urlLoader.loadClass("com.huawei.ism.tool.arrayupgrade.scene.UpgradeSceneSettingStart");
            Method open = upgradeSceneSetting.getMethod("open", ScenePrepareProxyRequest.class);
            ScenePrepareProxyRequest request = new ScenePrepareProxyRequest();
            request.setParent(this.parent);
            request.setTaskInRuning(this.isEdit);
            ScenePrepareProxyResponse response = (ScenePrepareProxyResponse)open.invoke(upgradeSceneSetting.newInstance(), request);
            LOGGER.info("openUpgradeSceneSetting run over.");
            this.processResponse(response);
            this.uninstallJar(url);
        }
        catch (Exception e) {
            LOGGER.error("openUpgradeSceneSettingDialog occur exception.", (Throwable)e);
        }
    }

    private void openPreUpgradeSceneSettingDialog() {
        LOGGER.info("enter openPreUpgradeSceneSettingDialog");
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("init toolkit path=" + TOOLKIT_PATH);
            }
            StringBuilder workDir = new StringBuilder().append(TOOLKIT_PATH).append(File.separator).append("tools").append(File.separator).append("upgradeEvaluation").append(File.separator);
            String jarPath = this.getJarPath(workDir.toString() + File.separator + "plugins", "UpgradeEvaluation.jar");
            URL url = new URL("jar:file:" + File.separator + jarPath + "!/");
            this.uninstallJar(url);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("jar jarpath=" + jarPath + ", url=" + url);
            }
            ClassLoader urlLoader = ClassLoader.getSystemClassLoader();
            Class<URLClassLoader> sysclass = URLClassLoader.class;
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)urlLoader, url);
            method.setAccessible(false);
            System.setProperty("user.dir", workDir.toString());
            System.setProperty("tool.log.dir", TOOLKIT_PATH + File.separator + "log" + File.separator + "upgradeEvaluation");
            Class<?> upgradeSceneSetting = urlLoader.loadClass("com.huawei.ism.tool.upgradeevalu.scene.PreUpgradeSceneSettingStart");
            Method open = upgradeSceneSetting.getMethod("open", ScenePrepareProxyRequest.class);
            ScenePrepareProxyRequest request = new ScenePrepareProxyRequest();
            request.setParent(this.parent);
            request.setTaskInRuning(this.isEdit);
            ScenePrepareProxyResponse response = (ScenePrepareProxyResponse)open.invoke(upgradeSceneSetting.newInstance(), request);
            LOGGER.info("openPreUpgradeSceneSetting run over.");
            this.processResponse(response);
            this.uninstallJar(url);
        }
        catch (Exception e) {
            LOGGER.error("openPreUpgradeSceneSettingDialog occur exception.", (Throwable)e);
        }
    }

    private String getJarPath(String workDir, String jarName) {
        String sourceFile = workDir + File.separator + jarName;
        String targetFile = TOOLKIT_PATH + File.separator + "tmp" + File.separator + jarName;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("sourceFile=" + sourceFile + ",targetFile=" + targetFile);
        }
        StreamUtils.copyFile((File)new File(sourceFile), (File)new File(targetFile));
        if (new File(targetFile).exists()) {
            LOGGER.info("copy upgradeEvalu jar file success.");
            return targetFile;
        }
        return sourceFile;
    }

    private void processResponse(ScenePrepareProxyResponse response) {
        int selectedDevNum = response.getSelectedDevNum();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("processResponse begin selectedDevNum=" + selectedDevNum);
        }
        ISceneService getSceneContextService = (ISceneService)PublicServiceManage.getInstance().getService(ISceneService.class);
        if (selectedDevNum > 0) {
            getSceneContextService.setSuccessDevCount(selectedDevNum);
        }
        String reportPath = response.getReportPath();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("report path=" + reportPath);
        }
        if (!StringUtils.isNULLStr((String)reportPath)) {
            getSceneContextService.setReportPath(reportPath);
        }
    }

    private void uninstallJar(URL url) {
        try {
            LOGGER.info("begin to uninstall jar.");
            URLConnection uc = url.openConnection();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("actual type=" + uc.getClass().getName());
            }
            if (uc instanceof JarURLConnection) {
                LOGGER.info("is jarurlconnection.");
                uc.setUseCaches(true);
                ((JarURLConnection)uc).getManifest();
                ((JarURLConnection)uc).getJarFile().close();
            }
        }
        catch (Exception e) {
            LOGGER.error("uninstall jar error.", (Throwable)e);
        }
    }

    private void openDsFWUpgSceneSettingDialog() {
        LOGGER.info("enter openDsFWUpgSceneSettingDialog");
        try {
            LOGGER.info("init toolkit path{}", (Object)TOOLKIT_PATH);
            StringBuilder workDir = new StringBuilder().append(TOOLKIT_PATH).append(File.separator).append("tools").append(File.separator).append("DistributedFWUpgrade").append(File.separator);
            String jarPath = this.getJarPath(workDir.toString() + File.separator + "lib", "DistributedFWUpgrade.jar");
            URL url = new URL("jar:file:" + File.separator + jarPath + "!/");
            this.uninstallJar(url);
            LOGGER.info("jar jarpath={}, url={}", (Object)jarPath, (Object)url);
            ClassLoader urlLoader = ClassLoader.getSystemClassLoader();
            Class<URLClassLoader> sysclass = URLClassLoader.class;
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)urlLoader, url);
            method.setAccessible(false);
            System.setProperty("user.dir", workDir.toString());
            System.setProperty("tool.log.dir", TOOLKIT_PATH + File.separator + "log" + File.separator + "DistributedFWUpg");
            Class<?> upgradeSceneSetting = urlLoader.loadClass("com.huawei.ism.tool.distributedfwupg.ui.dialog.UpgradeSceneSettingStart");
            Method open = upgradeSceneSetting.getMethod("open", ScenePrepareProxyRequest.class);
            ScenePrepareProxyRequest request = new ScenePrepareProxyRequest();
            request.setParent(this.parent);
            request.setTaskInRuning(this.isEdit);
            Object obj = open.invoke(upgradeSceneSetting.newInstance(), request);
            if (!(obj instanceof ScenePrepareProxyResponse)) {
                return;
            }
            ScenePrepareProxyResponse response = (ScenePrepareProxyResponse)obj;
            LOGGER.info("openPreUpgradeSceneSetting run over.");
            this.processResponse(response);
            this.uninstallJar(url);
        }
        catch (MalformedURLException e) {
            LOGGER.error("openPreUpgradeSceneSettingDialog occur exception.", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("openPreUpgradeSceneSettingDialog occur exception.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("openPreUpgradeSceneSettingDialog occur exception.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("openPreUpgradeSceneSettingDialog occur exception.", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("openPreUpgradeSceneSettingDialog occur exception.", (Throwable)e);
        }
        catch (InstantiationException e) {
            LOGGER.error("openPreUpgradeSceneSettingDialog occur exception.", (Throwable)e);
        }
    }

    private static class OpenHelpCallBack
    implements IHelpActionCallBack {
        private JDialog parentDlg = null;

        public OpenHelpCallBack(JDialog dlg) {
            this.parentDlg = dlg;
        }

        public void doHelpActionWork() {
            String fileName = DeviceSaveServiceFactory.buildServiceByScene().map(NodeSceneOptionService::getPrepareHelpDocFileName).orElse("SencePrepare\\Prepare");
            FileUtils.openHelpFile((String)fileName, (Window)this.parentDlg, (String)".chm");
        }

        public String getListenerName() {
            return "Open SencePrepare help file";
        }
    }
}

