/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog.layout.server;

import com.huawei.ism.tool.devicemanager.ui.dialog.SceneDeviceAddDialog;
import com.huawei.ism.tool.devicemanager.ui.dialog.layout.AbstractAddDeviceLayout;
import com.huawei.ism.tool.devicemanager.ui.dialog.listener.ServerAddConfirmAction;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.config.validate.IpInputValidator;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.utils.Base64EncodeUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.text.IsmPasswordField;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.ui.swing.text.validator.InputValidator;
import com.huawei.ism.ui.swing.text.validator.NotEmptyInputValidator;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.jetbrains.annotations.NotNull;

public class ServiceAddDeviceLayout
extends AbstractAddDeviceLayout {
    private static final String SSH_PORT = "22";
    private final String usernameDesc = ResourceUtil.getString((String)"fusionstorage.eval.conn.basicinfo.portal.user.desc");
    private final String ipDesc = ResourceUtil.getString((String)"scene.remind.errormessage.ip");
    private final String sshPortDesc = ResourceUtil.getString((String)"fusion.compute.eval.ssh.port.desc");
    private final String pwdDesc = ResourceUtil.getString((String)"fusionstorage.eval.conn.pwd.desc");
    private final String rootPwdDesc = ResourceUtil.getString((String)"fusionstorage.eval.conn.root.pwd.desc");
    private final JComponent ipAddrLabel = UiMethod.createRequiredLabel((String)(this.ipDesc + ":"), (boolean)true);
    private final JComponent sshPortLabel = UiMethod.createRequiredLabel((String)(this.sshPortDesc + ":"), (boolean)true);
    private final JComponent sshUser = UiMethod.createRequiredLabel((String)(this.usernameDesc + ":"), (boolean)true);
    private final JComponent sshPwdLabel = UiMethod.createRequiredLabel((String)(this.pwdDesc + ":"), (boolean)true);
    private final JComponent rootPwdLabel = UiMethod.createRequiredLabel((String)(this.rootPwdDesc + ":"), (boolean)true);
    private final TitledBorder basicBorder = BorderFactory.createTitledBorder(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.middletitleborder"));
    private final IsmTextField ipAddrField = UiMethod.createIpv4v6TextField();
    private final IsmTextField sshPortField = UiMethod.getSshPortFiled();
    private final IsmTextField sshUserNameField = UiMethod.getUsernameFiled();
    private final IsmPasswordField sshPwdField = UiMethod.getPasswordFiled();
    private final IsmPasswordField rootPwdField = UiMethod.getPasswordFiled();
    private final JButton okBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.okbtn"), (char)'F');
    private final JButton cancelBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.cancelbtn"), (char)'C');

    public ServiceAddDeviceLayout(SceneDeviceAddDialog sceneDeviceAddDialog) {
        this.parentDialog = sceneDeviceAddDialog;
        this.initComponentInfo();
        this.initUi();
        this.initDefaultInput();
    }

    private void initDefaultInput() {
        this.sshPortField.setText(SSH_PORT);
    }

    private void initComponentInfo() {
        NotEmptyInputValidator notEmptyValidator = new NotEmptyInputValidator();
        this.ipAddrField.setInputValueName(this.ipDesc);
        this.ipAddrField.addInputValidator((InputValidator)notEmptyValidator);
        this.ipAddrField.addInputValidator((InputValidator)new IpInputValidator());
        this.sshPwdField.setInputValueName(this.pwdDesc);
        this.sshPwdField.addInputValidator((InputValidator)notEmptyValidator);
        this.sshUserNameField.setInputValueName(this.usernameDesc);
        this.sshUserNameField.addInputValidator((InputValidator)notEmptyValidator);
        this.sshPortField.setInputValueName(this.sshPortDesc);
        this.sshPortField.addInputValidator((InputValidator)notEmptyValidator);
        this.rootPwdField.setInputValueName(this.rootPwdDesc);
        this.rootPwdField.addInputValidator((InputValidator)notEmptyValidator);
    }

    private void initUi() {
        JComponent basicInfoUI = this.initBasicInfoUI();
        UCD.setSameWidth((int)180, (JComponent[])new JComponent[]{this.ipAddrLabel, this.sshPortLabel, this.sshUser, this.sshPwdLabel, this.rootPwdLabel});
        JComponent btnPan = UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildHBoxRight((Component[])new Component[]{this.okBtn, this.cancelBtn, Box.createHorizontalStrut(0)}), Box.createHorizontalStrut(0)});
        JComponent view = UCD.buildVerticalBox(null, (int)12, (Component[])new Component[]{basicInfoUI, btnPan});
        this.add((Component)view, "Center");
        this.setPreferredSize(new Dimension(415, view.getPreferredSize().height));
    }

    private JComponent initBasicInfoUI() {
        this.ipAddrField.addInputValidator((InputValidator)new NotEmptyInputValidator());
        Box ip = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(2), this.ipAddrLabel, this.ipAddrField, Box.createHorizontalStrut(10)});
        Box port = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(2), this.sshPortLabel, this.sshPortField, Box.createHorizontalStrut(10)});
        Box innerUser = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(2), this.sshUser, this.sshUserNameField, Box.createHorizontalStrut(10)});
        Box pwd = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(2), this.sshPwdLabel, this.sshPwdField, Box.createHorizontalStrut(10)});
        Box sshPort = UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(2), this.rootPwdLabel, this.rootPwdField, Box.createHorizontalStrut(10)});
        return UCD.buildVerticalBox((Border)this.basicBorder, (int)6, (Component[])new Component[]{Box.createVerticalStrut(2), ip, port, innerUser, pwd, sshPort, Box.createVerticalStrut(150)});
    }

    @Override
    public void bindListener() {
        this.cancelBtn.addActionListener(e -> this.parentDialog.dispose());
        this.okBtn.addActionListener(new ServerAddConfirmAction(this.parentDialog, this));
        this.sshUserNameField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                ServiceAddDeviceLayout.this.showNotRootTipJudge();
            }

            @Override
            public void keyPressed(KeyEvent e) {
                ServiceAddDeviceLayout.this.showNotRootTipJudge();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                ServiceAddDeviceLayout.this.showNotRootTipJudge();
            }
        });
        this.sshUserNameField.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                ServiceAddDeviceLayout.this.showNotRootTipJudge();
            }
        });
    }

    @Override
    public JButton getDefaultButton() {
        return this.okBtn;
    }

    private void showNotRootTipJudge() {
        this.shouldShowRootPwdComp();
    }

    private void shouldShowRootPwdComp() {
        this.rootPwdField.setVisible(!"root".equalsIgnoreCase(this.sshUserNameField.getText().toLowerCase(Locale.ENGLISH)));
        this.rootPwdLabel.setVisible(!"root".equalsIgnoreCase(this.sshUserNameField.getText().toLowerCase(Locale.ENGLISH)));
    }

    public DevNode creatDevNode() {
        DevNode devNode = new DevNode();
        devNode.setIp(this.ipAddrField.getText());
        devNode.setPort(Integer.parseInt(this.sshPortField.getText()));
        devNode.setItDeviceType(ItDeviceType.Server);
        devNode.setDeviceType(DeviceType.valueOf((String)"Server"));
        devNode.setLoginUser(this.getLoginUser());
        this.getRootUser().ifPresent(arg_0 -> ((DevNode)devNode).setRootUser(arg_0));
        return devNode;
    }

    private Optional<User> getRootUser() {
        String userName = this.sshUserNameField.getText();
        if (!this.isRootUser(userName)) {
            return Optional.of(new User("root", Base64EncodeUtils.encode((String)String.valueOf(this.rootPwdField.getPassword()))));
        }
        return Optional.empty();
    }

    @NotNull
    private User getLoginUser() {
        return new User(this.sshUserNameField.getText(), String.valueOf(this.sshPwdField.getPassword()));
    }

    private boolean isRootUser(String userName) {
        return "root".equals(userName);
    }

    public boolean validInput() {
        List<IsmTextField> inputField = Arrays.asList(this.ipAddrField, this.sshUserNameField, this.sshPortField);
        if (!SwingUtil.validateInput(inputField, (Window)this.parentDialog)) {
            return false;
        }
        List<IsmPasswordField> pwdInput = Arrays.asList(this.sshPwdField, this.rootPwdField);
        return SwingUtil.validatePwdInput(pwdInput, (Window)this.parentDialog);
    }

    public JButton getOkBtn() {
        return this.okBtn;
    }

    public JButton getCancelBtn() {
        return this.cancelBtn;
    }
}

