/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog.nodeauth.ui;

import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.FsClusterNode;
import com.huawei.ism.tool.devicemanager.ui.dialog.nodeauth.context.AuthContext;
import com.huawei.ism.tool.devicemanager.ui.dialog.nodeauth.enums.NodeAuthState;
import com.huawei.ism.tool.devicemanager.ui.dialog.nodeauth.ui.AuthNodesDialog;
import com.huawei.ism.tool.devicemanager.ui.dialog.nodeauth.ui.OsInfoInputDialog;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.FsDevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthNodesLayout
extends JPanel
implements Observer {
    private static final Logger log = LoggerFactory.getLogger(AuthNodesLayout.class);
    private final AuthNodesDialog parentDialog;
    private DefaultTableModel tableModel;
    private IsmTable deviceTable;
    private final JButton authBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.authenticate"), (char)'O');
    private final JButton okBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"dsfwupgrade.scene.button.ok"), (char)'L');

    public AuthNodesLayout(AuthNodesDialog authNodesDialog, DevNode node) {
        this.parentDialog = authNodesDialog;
        this.initAddUI();
        this.initData(node);
    }

    private void initData(DevNode node) {
        if (node.isFusionCube()) {
            this.initCubeLayout(node);
            return;
        }
        this.buildCluster(node);
    }

    private void initCubeLayout(DevNode node) {
        if (!(node instanceof FsDevNode) || !node.getProductVersion().startsWith("6.")) {
            this.buildCluster(node);
            return;
        }
        FsClusterNode fsClusterNode = new FsClusterNode();
        fsClusterNode.setManagementIp(node.getIp());
        fsClusterNode.getRoles().add(node.getMigrType());
        fsClusterNode.setName(node.getDeviceName());
        fsClusterNode.setOsNode(node);
        this.createRow(fsClusterNode);
        node.setClusterNodes(Collections.singletonList(fsClusterNode));
    }

    private void buildCluster(DevNode node) {
        node.getClusterNodes().stream().filter(FsClusterNode.class::isInstance).map(FsClusterNode.class::cast).forEach(this::createRow);
    }

    public void bindListener(JDialog parent) {
        this.authBtn.addActionListener(e -> this.showOsInputDialog(parent));
        this.okBtn.addActionListener(e -> this.disposePanel(parent));
    }

    private void disposePanel(JDialog parent) {
        WarningDialog warningDialog;
        if (AuthNodesLayout.checkAuthing(parent)) {
            return;
        }
        if (!this.hasAllAuthed() && 0 != (warningDialog = DialogUtils.createWarningDialog((JDialog)parent, (String)ResourceUtil.getString((String)"node.not.auth"))).getValue()) {
            return;
        }
        parent.dispose();
    }

    private boolean hasAllAuthed() {
        return this.deviceTable.getAllRows().stream().map(TableRow::getIdentifier).filter(Objects::nonNull).filter(FsClusterNode.class::isInstance).map(FsClusterNode.class::cast).allMatch(node -> node.getNodeAuthState().getAuthState() == NodeAuthState.SUCCESS);
    }

    private void showOsInputDialog(JDialog parent) {
        if (AuthNodesLayout.checkAuthing(parent)) {
            return;
        }
        List<FsClusterNode> selectNodes = this.getSelectNodes();
        if (selectNodes.isEmpty()) {
            DialogUtils.showErrorDialog((JDialog)parent, (String)ResourceUtil.getString((String)"select.nodes.empty"));
            return;
        }
        new OsInfoInputDialog((Window)parent, selectNodes, this).setVisible(true);
    }

    private static boolean checkAuthing(JDialog parent) {
        if (AuthContext.getInstance().hasAuthingNodes()) {
            DialogUtils.showInfoDialog((JDialog)parent, (String)ResourceUtil.getString((String)"node.authing"));
            return true;
        }
        return false;
    }

    private void initAddUI() {
        this.authBtn.setToolTipText(this.authBtn.getText());
        JLabel desc = new JLabel(ResourceUtil.getString((String)"dsfwupgrade.wizard.nodes.desc"));
        JComponent addDeviceSuggestion = UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{Box.createHorizontalStrut(12), desc});
        JComponent authButtonComponent = UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{Box.createHorizontalStrut(12), this.authBtn});
        JComponent okBtnComponent = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsRight((int)0, (Component[])new Component[]{this.okBtn, Box.createHorizontalStrut(12)}), UiMethod.buildCompsRight((int)0, (Component[])new Component[]{Box.createHorizontalStrut(12)})});
        JComponent deviceTableScroll = this.layoutTableScroll();
        JComponent viewJc = UCD.buildVerticalBox(null, (Component[])new Component[]{addDeviceSuggestion, authButtonComponent, deviceTableScroll, okBtnComponent});
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(630, 400));
        this.add((Component)viewJc, "Center");
    }

    private JComponent layoutTableScroll() {
        String[] headers = new String[]{ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.manageip"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.role"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.productname"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.state"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.suggestion"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.osOperation")};
        this.tableModel = new DefaultTableModel(headers, new int[0]);
        this.deviceTable = new IsmTable((TableModel)this.tableModel);
        return new TableScrollPane(this.deviceTable, false, false, true);
    }

    private void tableRowRender(TableRow row, FsClusterNode node) {
        int rowIndex = 0;
        row.setValueAt(rowIndex++, (Object)node.getManagementIp());
        row.setValueAt(rowIndex++, (Object)StringUtils.join((Iterable)node.getRoles(), (String)","));
        row.setValueAt(rowIndex++, (Object)node.getName());
        row.setValueAt(rowIndex++, (Object)node.getNodeAuthState().getAuthState().getDesc());
        if (NodeAuthState.FAIL.equals((Object)node.getNodeAuthState().getAuthState())) {
            row.setValueAt(rowIndex++, (Object)node.getNodeAuthState().getMsg());
        } else {
            row.setValueAt(rowIndex++, (Object)"");
        }
        IsmTableCell.HyperlinkCell osOperateCell = new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"dsfwupgrade.wizard.selectdevice.modify"), event -> this.showOsInputDialog(this.parentDialog));
        row.setValueAt(rowIndex, (Object)osOperateCell);
    }

    public void createRow(FsClusterNode fsDevNode) {
        DefaultTableRow row = new DefaultTableRow(this.tableModel.getAllColumnCount(), (Object)fsDevNode);
        this.tableRowRender((TableRow)row, fsDevNode);
        this.tableModel.addRow(new TableRow[]{row});
        if (fsDevNode.isSelected()) {
            this.deviceTable.markTableRow(new TableRow[]{row});
        }
    }

    public void updateTableRowData(FsClusterNode fsDevNode) {
        TableRow row = this.tableModel.getTableRowBy((Object)fsDevNode);
        this.tableRowRender(row, fsDevNode);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof FsClusterNode) {
            this.updateTableRowData((FsClusterNode)((Object)arg));
        }
    }

    public List<FsClusterNode> getSelectNodes() {
        List allSelectRows = this.deviceTable.getMarkedRows();
        ArrayList<FsClusterNode> fsDevNodes = new ArrayList<FsClusterNode>();
        for (TableRow row : allSelectRows) {
            Object rowObj = row.getIdentifier();
            if (!(rowObj instanceof FsClusterNode)) continue;
            fsDevNodes.add((FsClusterNode)((Object)rowObj));
        }
        return fsDevNodes;
    }

    public JButton getAuthBtn() {
        return this.authBtn;
    }
}

