/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.login;

import com.huawei.ism.common.bean.ProductModelType;
import com.huawei.ism.common.bean.User;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.connection.IConnection;
import com.huawei.ism.connection.TLVConnection;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.model.MOType;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tlv.bean.Record;
import com.huawei.ism.tool.devicemanager.entity.LoginInfoCfg;
import com.huawei.ism.tool.devicemanager.service.DevContext;
import com.huawei.ism.tool.devicemanager.service.VerSpcGainer;
import com.huawei.ism.tool.devicemanager.ui.context.DeviceSceneContext;
import com.huawei.ism.tool.devicemanager.ui.login.LoginLayout;
import com.huawei.ism.tool.framework.platform.context.IPropertiesManager;
import com.huawei.ism.tool.framework.platform.pwdSecurityResMgr.PwdSecurityResMgr;
import com.huawei.ism.tool.framework.platform.pwdSecurityResMgr.PwdSecurityType;
import com.huawei.ism.tool.framework.platform.pwdSecurityResMgr.PwdSecurityUserScene;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.platform.util.PropertiesManager;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IConnectionManage;
import com.huawei.ism.tool.framework.pubservice.common.IDeviceManage;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.DeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.enums.SVPModuleInfo;
import com.huawei.ism.tool.framework.pubui.common.ILoginUI;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionCreator;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ArrayUtils;
import com.huawei.ism.tool.obase.utils.CliResolverUtils;
import com.huawei.ism.tool.obase.utils.DeviceTypeUtil;
import com.huawei.ism.tool.obase.utils.OSCmdUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.slf4j.Logger;

public class LoginDialog
extends JDialog
implements ILoginUI {
    public static final int SEPARATOR_HEIGHT = 50;
    public static final int LINE_WIDTH = 230;
    public static final int SUB_LINE_WIDTH = 63;
    public static final int SUB_LINE_WIDTH_ZH = 63;
    public static final int LINE_HEIGHT = 21;
    public static final int BUTTON_SPACE = 12;
    public static final int LABEL_VALUE_SPACE = 5;
    public static final int LINE_SPACE = 15;
    private static final long serialVersionUID = 6841713441485106458L;
    private static final String PROPERTIES = "config.resource.languages.toolbox";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(LoginDialog.class);
    private static final int DIALOG_HEIGHT = 365;
    private static IPropertiesManager resource = new PropertiesManager("config.resource.languages.toolbox", com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getSupportedLans(), LoginDialog.class.getClassLoader());
    private Icon icon = ResourceUtil.getImage((String)"header.png");
    private LoginLayout layout = new LoginLayout();
    private boolean loginSuccess = false;
    private String errMsg = null;
    private boolean devStatusNormal = true;
    private DevNode loginDev = null;
    private transient Callable<Boolean> task = null;
    private boolean checkRoleOk = true;
    private static final int SUPERADMIN = 1;
    private static final int SYSTEMADMIN = 2;
    private static final int GUEST = 10;
    protected static final int MONITOR = 13;
    private static final String HOTPATCH_VERSION = "hotpatch version";
    private static final String SPH_VER_REGEX = "v\\d{3}r\\d{3}c\\d{2}sph\\w{1,3}";
    private static final String VER_REGEX = "v\\d{3}r\\d{3}c\\d{2}";

    private LoginDialog(Window owner) {
        super(owner);
        this.setLayout(new BorderLayout());
        this.add(this.layout);
        this.setResizable(false);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.setIconImage(ResourceUtil.getOEMImage((String)"toolbox.png").getImage());
        this.getRootPane().setUI(null);
        this.initUiLinstener();
        this.setMinimumSize(new Dimension(this.icon.getIconWidth(), 365));
        this.setPreferredSize(new Dimension(this.icon.getIconWidth(), 365));
        UiMethod.putScreenCenter((Window)this);
        this.task = new LoginTask();
    }

    public static LoginDialog getInstance() {
        return new LoginDialog(null);
    }

    public boolean isLoginSuccess() {
        return this.loginSuccess;
    }

    private void initUiLinstener() {
        JComboBox lanComboBox = this.layout.getLanComboBox();
        lanComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.setLocalLan();
            }
        });
        lanComboBox.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                LoginDialog.this.layout.getTextFieldUser().requestFocus();
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        JButton loginButton = this.layout.getLoginButton();
        loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.login();
            }
        });
        JButton cancelButton = this.layout.getCancelButton();
        cancelButton.addActionListener(new CancelActionListener());
        JTextField textFieldUser = this.layout.getTextFieldUser();
        textFieldUser.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    LoginDialog.this.layout.getTextFieldPass().requestFocus();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        JPasswordField textFieldPass = this.layout.getTextFieldPass();
        textFieldPass.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    LoginDialog.this.layout.getLoginButton().requestFocus();
                    LoginDialog.this.login();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
    }

    private void setLocalLan() {
        Object selectItem = this.layout.getLanComboBox().getSelectedItem();
        if (this.getString("toolbox.login.english.lan").equals(selectItem)) {
            LanguageManager.getInstance().setCurrentLanguage(Locale.ENGLISH);
            this.layout.getQuestionField().setToolTipText(ResourceUtil.getString((String)"login.input.account.type.tip", (Locale)Locale.ENGLISH));
        } else {
            LanguageManager.getInstance().setCurrentLanguage(Locale.SIMPLIFIED_CHINESE);
            this.layout.getQuestionField().setToolTipText(ResourceUtil.getString((String)"login.input.account.type.tip", (Locale)Locale.SIMPLIFIED_CHINESE));
        }
        this.layout.getBoxLanLabel().setPreferredSize(new Dimension(63, 21));
        this.layout.getBoxLanLabel().setMinimumSize(new Dimension(63, 21));
        this.layout.getLanComboBox().setPreferredSize(new Dimension(162, 21));
        this.layout.getLanComboBox().setMinimumSize(new Dimension(162, 21));
        this.layout.getBoxusernameLabel().setPreferredSize(new Dimension(63, 21));
        this.layout.getBoxusernameLabel().setMinimumSize(new Dimension(63, 21));
        this.layout.getBoxpasswordLabel().setPreferredSize(new Dimension(63, 21));
        this.layout.getBoxpasswordLabel().setMinimumSize(new Dimension(63, 21));
        this.layout.getLoginButton().setText(this.getString("toolbox.login.login"));
        this.layout.getCancelButton().setText(this.getString("toolbox.login.cancel"));
        this.layout.getLanLabel().setText(this.getString("toolbox.login.language") + ":");
        this.layout.getUsernameLabel().setText(this.getString("toolbox.login.username") + ":");
        this.layout.getPasswordLabel().setText(this.getString("toolbox.login.password") + ":");
    }

    private String getString(String key) {
        return resource.getString(LanguageManager.getInstance().getCurrentLanguage(), key);
    }

    private void login() {
        ApplicationContext.getInstance().setCurrentLanguage(LanguageManager.getInstance().getCurrentLanguage());
        ResourceManager.setLocale((Locale)LanguageManager.getInstance().getCurrentLanguage());
        IsmPlafUtils.setLocale((Locale)LanguageManager.getInstance().getCurrentLanguage());
        String username = this.layout.getTextFieldUser().getText();
        char[] pwd = this.layout.getTextFieldPass().getPassword();
        if (ArrayUtils.isEmpty((char[])pwd) || StringUtils.isNULLStr((String)username)) {
            DialogUtils.showInfoDialog((JDialog)this, (String)this.getString("toolbox.login.empty.login.information"));
            return;
        }
        this.loginDev = this.getDevNode(username, pwd);
        LOGGER.info("Toolframe dev before login ip:{}", (Object)this.loginDev.getIp());
        for (String ip : this.loginDev.getIpList()) {
            LOGGER.info("Toolframe dev before login innerip:{}", (Object)ip);
        }
        ArrayUtils.clearCharArray((char[])pwd);
        AsyncExcutor.execute((Window)this, (Callable[])new Callable[]{this.task});
        if (!this.checkRoleOk) {
            DialogUtils.showInfoDialog((JDialog)this, (String)this.errMsg);
            return;
        }
        if (this.loginSuccess) {
            this.setVisible(false);
            this.addCurDevice(this.loginDev);
            com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().setCurToolkitUser(this.loginDev.getLoginUser().getUserName());
            IDeviceManage deviceManage = (IDeviceManage)PublicServiceManage.getInstance().getService(IDeviceManage.class);
            deviceManage.addDevice(this.loginDev);
            DeviceSceneContext.getInstance().setCurSvpNode(this.loginDev);
            this.dispose();
        } else {
            String infoUrl = com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getAppConfig("app.specific.device.ism.info.collect");
            if (!this.devStatusNormal && !StringUtils.isNULLStr((String)infoUrl)) {
                WarningDialog wd = DialogUtils.createWarningDialog((JDialog)this, (String)ResourceUtil.getString((String)"device.ism.info.collect"));
                if (0 == wd.getValue()) {
                    this.infoUrlSplit(infoUrl);
                }
            } else {
                DialogUtils.showInfoDialog((JDialog)this, (String)this.errMsg);
            }
        }
    }

    private void infoUrlSplit(String infoUrl) {
        try {
            String[] str = infoUrl.split(" ");
            if (str.length < 2) {
                OSCmdUtils.executeCmd((String)("cmd.exe /c start " + str[0]));
            }
        }
        catch (Exception e) {
            LOGGER.error("Can not open ism info collect url.", (Throwable)e);
        }
    }

    private boolean connValue(TLVConnection conn) {
        if (conn.getLoginUser() != null && conn.getLoginUser().getStatus().equals((Object)User.Status.Pwd_expiring)) {
            LOGGER.info("The loginuser will expiring.");
            this.devStatusNormal = true;
            this.loginSuccess = false;
            this.errMsg = PwdSecurityResMgr.getInstance().getDesc(PwdSecurityType.PWD_WILL_EXPIRE, PwdSecurityUserScene.Tool);
            return true;
        }
        return false;
    }

    private boolean connMagIsNull(IConnectionManage connMag) {
        if (null == connMag) {
            LOGGER.error("Service load failure");
            this.loginSuccess = false;
            this.devStatusNormal = false;
            this.errMsg = "Service load failure";
            return true;
        }
        return false;
    }

    private void addCurDevice(DevNode device) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Toolframe dev after login ip:" + device.getIp());
        }
        for (Object ip : device.getIpList()) {
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("Toolframe dev after login innerip:" + (String)ip);
        }
        com.huawei.ism.tool.obase.entity.DevNode devNode = new com.huawei.ism.tool.obase.entity.DevNode();
        devNode.setDeviceSerialNumber(device.getDeviceSerialNumber());
        devNode.setDeviceName(device.getDeviceName());
        devNode.setDeviceType(com.huawei.ism.tool.obase.entity.DeviceType.valueOf((String)device.getDeviceType().toString()));
        devNode.setProductVersion(device.getProductVersion());
        devNode.setHotPatchVersion(device.getHotPatchVersion());
        devNode.setIp(device.getIp());
        for (String ip : device.getIpList()) {
            devNode.addIp(ip);
        }
        String pwd = device.getLoginUser().getPassword();
        User loginUser = new User(device.getLoginUser().getUserName(), pwd);
        com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)pwd);
        devNode.setLoginUser(loginUser);
        DevContext.getInstance().saveSingleObject("DevNode", devNode);
        devNode.setIpListAreInnerIp(device.isIpListAreInnerIp());
        devNode.setRemoteSNs(device.getRemoteSNs());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Base dev after login ip:" + devNode.getIp());
        }
        for (String ip : devNode.getIpList()) {
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("Base dev after login innerip:" + ip);
        }
    }

    private void initDeviceInfo(TLVConnection conn, DevNode device) {
        try {
            Record record = conn.pmGet(MOType.SYSTEM.getValue(), "", 30);
            if (record == null) {
                LOGGER.error("Get productVersion failed! record is null.");
                throw new NullPointerException("record is null.");
            }
            device.setProductVersion(record.getParamStrValue(TLV.SYSTEM.PRODUCTVERSION.getParamIndex()));
            this.replaceDevVersionSVP(device);
            device.setDeviceName(record.getParamStrValue(TLV.SYSTEM.NAME.getParamIndex()));
            int index = TLV.SYSTEM.PRODUCTMODE.getParamIndex();
            device.setDeviceType(DeviceType.valueOf((String)ProductModelType.getProductModel((int)record.getParamIntValue(index).intValue()).toString()));
            this.querySupportSVPOpt(device);
            this.queryStorageRemoteSNInfo(device);
            String sphStr = this.querySphVersion(device);
            device.setHotPatchVersion(sphStr);
        }
        catch (IsmException ie) {
            LOGGER.error("Auth Connection Failed: Get productVersion failed!");
            this.closeConnetcion((IConnection)conn);
        }
        catch (Exception e) {
            LOGGER.error("Get productVersion failed!", (Throwable)e);
            this.closeConnetcion((IConnection)conn);
        }
    }

    protected void querySupportSVPOpt(DevNode devNode) {
        try {
            com.huawei.ism.tool.obase.entity.DevNode devOld = EntityUtils.toOldDev((DevNode)devNode);
            ICliConnection con = null;
            con = SshConnectionManager.getSshConnection((com.huawei.ism.tool.obase.entity.DevNode)devOld, null, (boolean)true, (boolean)true);
            DeviceTypeUtil.SvpOptional svpOptional = DeviceTypeUtil.isSupportSVPCmd((ICliConnection)con);
            if (svpOptional == DeviceTypeUtil.SvpOptional.SUPPORT_NO) {
                devNode.setHighDevSVPModuleInfo(SVPModuleInfo.NEW_TOOLBOX_NOSVP.getName());
            } else if (DeviceTypeUtil.isDeviceHasSVPModule((String)devNode.getProductVersion(), (String)devNode.getDeviceType().toString())) {
                devNode.setHighDevSVPModuleInfo(SVPModuleInfo.NEW_TOOLBOX_HASSVP.getName());
            } else {
                devNode.setHighDevSVPModuleInfo(SVPModuleInfo.NEW_TOOLBOX_NOSVP.getName());
            }
            LOGGER.info("highDevSVPModuleInfo:" + devNode.getHighDevSVPModuleInfo());
        }
        catch (ToolException e) {
            LOGGER.error("query device svp info error!", (Throwable)e);
        }
    }

    protected String querySphVersion(DevNode devNode) {
        String sver = "";
        try {
            com.huawei.ism.tool.obase.entity.DevNode devOld = EntityUtils.toOldDev((DevNode)devNode);
            ICliConnection con = null;
            con = SshConnectionManager.getSshConnection((com.huawei.ism.tool.obase.entity.DevNode)devOld, null, (boolean)true, (boolean)true);
            String queryHyperMetroCmd = "show upgrade package";
            String cliResult = con.execCmdWithTimout(queryHyperMetroCmd, 15);
            cliResult = Normalizer.normalize(cliResult, Normalizer.Form.NFKC);
            cliResult = cliResult.toLowerCase(Locale.ENGLISH);
            sver = cliResult.contains(HOTPATCH_VERSION) ? this.getVerByKeys(cliResult) : "";
        }
        catch (Exception e) {
            LOGGER.error("query sph device info error!", (Throwable)e);
        }
        LOGGER.info("query sph device info is: ", (Object)sver);
        if (!StringUtils.isNULLStr((String)sver)) {
            return sver.toUpperCase(Locale.ENGLISH);
        }
        return "";
    }

    private String getVerByKeys(String cliInfo) {
        boolean isHotPatchVersion = false;
        String[] lines = cliInfo.split("\\s+");
        for (int i = 0; i < lines.length; ++i) {
            if ("hotpatch".equals(lines[i].trim())) {
                isHotPatchVersion = true;
            }
            if (!StringUtils.isFullIpAddress((String)lines[i]) || !isHotPatchVersion) continue;
            int sphIndex = i + 1;
            if (sphIndex >= lines.length) {
                LOGGER.info("Find the sph patch is out of index.");
                return "";
            }
            String ver = lines[sphIndex];
            if (!StringUtils.isNULLStr((String)ver) && "--".equals(ver.trim())) {
                return "";
            }
            if (!StringUtils.hasMatchStr((String)ver, (String)VER_REGEX)) continue;
            return StringUtils.findMatchStr((String)ver, (String)SPH_VER_REGEX, (int)0);
        }
        return "";
    }

    protected void queryStorageRemoteSNInfo(DevNode devNode) {
        String errRemoteSN = "UnknownDeviceSN";
        ArrayList<Object> remoteSNList = new ArrayList<Object>();
        try {
            com.huawei.ism.tool.obase.entity.DevNode devOld = EntityUtils.toOldDev((DevNode)devNode);
            ICliConnection con = null;
            con = SshConnectionManager.getSshConnection((com.huawei.ism.tool.obase.entity.DevNode)devOld, null, (boolean)true, (boolean)true);
            String queryCmd = "show hyper_metro_domain general |filterColumn include columnList=Remote\\sDevice\\sID";
            List hyperMetroDevList = CliResolverUtils.queryStorageRemoteSNInfo((ICliConnection)con, (String)queryCmd);
            String queryNasCmd = "show fs_hyper_metro_domain general |filterColumn include columnList=Remote\\sDevice\\sID";
            List nasHyperMetroDevList = CliResolverUtils.queryStorageRemoteSNInfo((ICliConnection)con, (String)queryNasCmd);
            hyperMetroDevList.removeAll(nasHyperMetroDevList);
            hyperMetroDevList.addAll(nasHyperMetroDevList);
            if (hyperMetroDevList.isEmpty()) {
                devNode.setRemoteSNs(remoteSNList);
                return;
            }
            String queryRemoteCmd = "show remote_device general |filterColumn include columnList=ID,SN";
            String cliResult1 = con.execCmdWithTimout(queryRemoteCmd, 15);
            if (CliResolverUtils.isCLIResultInValid((String)cliResult1) || cliResult1.contains("executed successfully")) {
                return;
            }
            List remoteDevList = CliResolverUtils.resloveCliRetToList((String)cliResult1);
            if (remoteDevList.isEmpty()) {
                return;
            }
            for (Map hyperMetroDev : hyperMetroDevList) {
                boolean getSnFlag = false;
                String hyperRemoteDevId = (String)hyperMetroDev.get("Remote Device ID");
                for (Map remoteDev : remoteDevList) {
                    if (!hyperRemoteDevId.equals(remoteDev.get("ID")) || remoteSNList.contains(remoteDev.get("SN"))) continue;
                    remoteSNList.add(remoteDev.get("SN"));
                    getSnFlag = true;
                    break;
                }
                if (getSnFlag) continue;
                remoteSNList.add(errRemoteSN + hyperRemoteDevId);
            }
        }
        catch (Exception e) {
            LOGGER.error("query remote device info error!", (Throwable)e);
            return;
        }
        devNode.setRemoteSNs(remoteSNList);
        LOGGER.info("query remote device info success: ", (Object)((Object)remoteSNList).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceDevVersionSVP(DevNode device) {
        try (SshConnection sshConn = null;){
            com.huawei.ism.tool.obase.entity.DevNode devBase;
            SshConnectionCreator creator;
            String devVersion;
            if (com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().isSpecificDeviceMode() && !StringUtils.isNULLStr((String)(devVersion = new VerSpcGainer().query((ICliConnection)(sshConn = (creator = new SshConnectionCreator(devBase = EntityUtils.toOldDev((DevNode)device), null, true, false)).create()))))) {
                device.setProductVersion(devVersion);
            }
        }
    }

    private DevNode getDevNode(String username, char[] pwd) {
        LoginInfoCfg loginInfo = this.parserLoginDev(username, pwd);
        DevNode node = new DevNode();
        node.setIp(com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getDeviceIP());
        node.setIpListAreInnerIp(!loginInfo.getIps().isEmpty());
        for (String ip : loginInfo.getIps()) {
            node.addIp(ip);
        }
        com.huawei.ism.tool.framework.pubservice.entity.User us = new com.huawei.ism.tool.framework.pubservice.entity.User(username, String.valueOf(pwd));
        node.setLoginUser(us);
        return node;
    }

    private LoginInfoCfg parserLoginDev(String username, char[] pwd) {
        ArrayList<String> ips = new ArrayList<String>();
        LoginInfoCfg loginInfo = new LoginInfoCfg();
        String ipStr = com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getDeviceInnerIPs();
        for (String ip : ipStr.split(",")) {
            ips.add(ip);
        }
        loginInfo.setIps(ips);
        loginInfo.setUserName(username);
        loginInfo.setPassWord(String.valueOf(pwd));
        return loginInfo;
    }

    private void closeConnetcion(IConnection conn) {
        if (null == conn) {
            return;
        }
        try {
            IConnection.ConnectionState state = conn.getConnectionState();
            if (IConnection.ConnectionState.Connected.equals((Object)state)) {
                conn.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("Not close connection because connection is not connected.");
        }
    }

    public void showDialog() {
        this.setVisible(true);
    }

    public void startLockThread(JFrame mainFrame) {
    }

    static /* synthetic */ boolean access$700(LoginDialog x0, IConnectionManage x1) {
        return x0.connMagIsNull(x1);
    }

    static /* synthetic */ void access$900(LoginDialog x0, TLVConnection x1, DevNode x2) {
        x0.initDeviceInfo(x1, x2);
    }

    static /* synthetic */ boolean access$1000(LoginDialog x0, TLVConnection x1) {
        return x0.connValue(x1);
    }

    static /* synthetic */ boolean access$500(LoginDialog x0) {
        return x0.loginSuccess;
    }

    private class LoginTask
    implements Callable<Boolean> {
        private LoginTask() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public Boolean call() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean setUserSelf(com.huawei.ism.tool.obase.entity.DevNode dev) throws ToolException {
            if (!this.checkProductUserRole(dev)) {
                LOGGER.info("Device version is {} , user role is not allowed...", (Object)LoginDialog.this.loginDev.getProductVersion());
                LoginDialog.this.loginSuccess = false;
                LoginDialog.this.devStatusNormal = false;
                LoginDialog.this.checkRoleOk = false;
                LoginDialog.this.errMsg = ResourceUtil.getString((String)"toolbox.showinfo.V3R6nonsupportroleid");
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkProductUserRole(com.huawei.ism.tool.obase.entity.DevNode dev) throws ToolException {
            ICliConnection con = null;
            boolean isCustomRole = false;
            try {
                con = SshConnectionManager.getSshConnection((com.huawei.ism.tool.obase.entity.DevNode)dev, null, (boolean)true, (boolean)true);
                isCustomRole = CliResolverUtils.checkUserRole((com.huawei.ism.tool.obase.entity.DevNode)dev, (ICliConnection)con, (int[])new int[]{1, 2, 13, 10});
            }
            catch (Throwable throwable) {
                SshConnectionManager.releaseConnection(con);
                throw throwable;
            }
            SshConnectionManager.releaseConnection((ICliConnection)con);
            return isCustomRole;
        }
    }

    static class CancelActionListener
    implements ActionListener {
        CancelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Runtime.getRuntime().exit(0);
        }
    }
}

