/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.utils;

import com.alibaba.fastjson.JSONArray;
import com.huawei.ism.tool.devicemanager.ui.context.DeviceSceneContext;
import com.huawei.ism.tool.devicemanager.utils.SceneParser;
import com.huawei.ism.tool.framework.platform.common.data.DeviceMode;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.ism.util.NumberUtils;
import com.huawei.ism.util.SceneEnum;
import com.huawei.ism.util.Utils;
import com.huawei.json.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceAddUtil {
    private static final Logger log = LoggerFactory.getLogger(DeviceAddUtil.class);
    private static final Properties PROPERTIES = new Properties();
    private static final String MAX_KEY = "max.device.size";

    public static boolean overMaxSelectDev(List<DevNode> devs) {
        Object maxNum = PROPERTIES.get(String.join((CharSequence)".", SceneParser.getInstance().getMainScene(), SceneParser.getInstance().getSubScene(), MAX_KEY));
        if (Objects.isNull(maxNum)) {
            return false;
        }
        return devs.size() > Integer.parseInt(maxNum.toString());
    }

    public static int getCurrentMaxConfig() {
        return Integer.parseInt(PROPERTIES.get(String.join((CharSequence)".", SceneParser.getInstance().getMainScene(), SceneParser.getInstance().getSubScene(), MAX_KEY)).toString());
    }

    public static boolean isReplaceCertScene() {
        JSONObject sceneJson = DeviceSceneContext.getInstance().getSceneJson();
        if (Objects.isNull(sceneJson)) {
            return false;
        }
        return sceneJson.getStringOrDefault("subScene", "").contains("ReplacingCertificates");
    }

    public static boolean isSceneSupportA800Only() {
        String subScene = DeviceAddUtil.getCurrentScene();
        return PROPERTIES.get(subScene) != null && PROPERTIES.get(subScene).equals(ItDeviceType.A800_NODE.getName());
    }

    public static boolean isSceneSupportOmOnly() {
        String subScene = DeviceAddUtil.getCurrentScene();
        return PROPERTIES.get(subScene) != null && PROPERTIES.get(subScene).equals(ItDeviceType.A800_OM.getName());
    }

    @NotNull
    public static String getCurrentScene() {
        JSONObject sceneJson = DeviceSceneContext.getInstance().getSceneJson();
        if (Objects.isNull(sceneJson)) {
            return "";
        }
        return sceneJson.getStringOrDefault("subScene", "");
    }

    public static boolean isA800SceneInToolBox() {
        JSONObject sceneJson = DeviceSceneContext.getInstance().getSceneJson();
        return DeviceAddUtil.judgeWitSceneJson(sceneJson);
    }

    public static boolean isA800InfoCollect() {
        JSONObject sceneJson = DeviceSceneContext.getInstance().getSceneJson();
        if (Objects.isNull(sceneJson)) {
            return false;
        }
        String field = sceneJson.getStringOrDefault("mainScene", "");
        String subField = sceneJson.getStringOrDefault("subScene", "");
        return "Troubleshooting".equals(field) && "IntelligentCompute_A800_Storage_Collect".equals(subField);
    }

    public static boolean isA800UpgradePrepare() {
        return DeviceAddUtil.isUpgradePrepareInSubScene("IntelligentCompute_A800_upgrade");
    }

    private static boolean isUpgradePrepareInSubScene(String targetSubScene) {
        JSONObject sceneJson = DeviceSceneContext.getInstance().getSceneJson();
        if (Objects.isNull(sceneJson)) {
            return false;
        }
        String mainScene = sceneJson.getStringOrDefault("mainScene", "");
        String subScene = sceneJson.getStringOrDefault("subScene", "");
        return DeviceAddUtil.isSetting(targetSubScene, mainScene, subScene);
    }

    private static boolean isSetting(String targetSubScene, String mainScene, String subScene) {
        return SceneEnum.A800_UPGRADE_UPGRADEPREPARE.getMainScene().equals(mainScene) && Objects.equals(targetSubScene, subScene) && Objects.nonNull(DeviceSceneContext.getInstance().getSceneJson()) && Objects.equals(SceneEnum.A800_UPGRADE_UPGRADEPREPARE.getStepID(), DeviceSceneContext.getInstance().getSceneJson().getStringOrDefault("stepID", ""));
    }

    public static boolean isA800UpgradeCheckPrepare() {
        return DeviceAddUtil.isUpgradePrepareInSubScene("IntelligentCompute_A800_upgrade_eval");
    }

    private static boolean judgeWitSceneJson(JSONObject sceneJson) {
        if (Objects.isNull(sceneJson)) {
            return false;
        }
        String field = sceneJson.getStringOrDefault("field", "");
        String subField = sceneJson.getStringOrDefault("sub_field", "");
        return "Solution".equals(field) && "INTELLIGENTCOMPUTE".equals(subField);
    }

    public static boolean isAllowZoneNoAuth(String scene) {
        return Arrays.asList("IntelligentCompute_A800_inspection", "IntelligentCompute_A800_Storage_Collect", "IntelligentCompute_A800_History", "IntelligentCompute_A800_FRU_Evaluation", "IntelligentCompute_A800_FRU_Replacement", "IntelligentCompute_A800_Quality_Checks").contains(scene);
    }

    public static boolean isAllowOmNoAuth(String scene) {
        return true;
    }

    public static int getMaxA800CollectSelectConfig() {
        return NumberUtils.parseIntDefault((String)PROPERTIES.get("Troubleshooting.IntelligentCompute_A800.max.a800.size").toString(), (int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<String> getDeviceModeByRest(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        try {
            log.info("Start to get device mode by rest , {}", (Object)devNode.getIp());
            RestConnection con = RestConnectionManager.getRestConnection(devNode);
            ResponseInfo requestInfo = con.execGet(RestUtil.getDeviceSystemInfoUri(devNode));
            if (requestInfo.isSuccess()) {
                String deviceKey = requestInfo.getContentMap().getOrDefault("PRODUCTMODE", "").toString();
                Optional<String> optional = DeviceAddUtil.getDeviceModeByLocalJson(deviceKey);
                return optional;
            }
        }
        catch (ToolException e) {
            log.error("Get device model by rest failed", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Close rest connection failed", (Throwable)e);
        }
        finally {
            RestConnectionManager.releaseConn(devNode);
        }
        return Optional.empty();
    }

    public static boolean needGetDeviceModeByRest(String cliResult) {
        if (cliResult.isEmpty()) {
            return false;
        }
        return cliResult.contains("OS Kernel Version") && !cliResult.contains("OceanStor OS Kernel Version");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<String> getDeviceModeByLocalJson(String deviceKey) {
        try (InputStream inputStream = DeviceAddUtil.class.getResourceAsStream("/config/product_mode.json");){
            if (inputStream == null) {
                log.error("Failed to load the device mode json}");
                Optional<String> optional2 = Optional.empty();
                return optional2;
            }
            List deviceModes = ApplicationContext.getInstance().getDeviceModeList();
            if (Utils.isNullList((List)deviceModes)) {
                deviceModes = JSONArray.parseArray((String)String.join((CharSequence)"", IOUtils.readLines((InputStream)inputStream, (Charset)StandardCharsets.UTF_8)), DeviceMode.class);
                ApplicationContext.getInstance().setDeviceModeList(deviceModes);
            }
            Optional<Object> optional = Optional.ofNullable(deviceModes.stream().filter(deviceMode -> deviceMode.getValue().equals(deviceKey)).map(DeviceMode::getModel).findFirst().orElse(null));
            return optional;
        }
        catch (IOException e) {
            log.error("Failed to map the device model through the config file", (Throwable)e);
            return Optional.empty();
        }
    }

    private DeviceAddUtil() {
    }

    static {
        try (InputStream resource = DeviceAddUtil.class.getClassLoader().getResourceAsStream("config/max_add.properties");
             InputStream a800Resource = DeviceAddUtil.class.getClassLoader().getResourceAsStream("config/a800_scene_add_config.properties");){
            if (Objects.nonNull(resource)) {
                PROPERTIES.load(resource);
            }
            if (Objects.nonNull(a800Resource)) {
                PROPERTIES.load(a800Resource);
            }
            log.info("init properties :{}", (Object)PROPERTIES);
        }
        catch (IOException | NumberFormatException e) {
            log.warn("read max add properties failed.");
        }
    }
}

