/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.utils;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.devicemanager.ui.mainframe.DeviceManagementPanel;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.service.timingtask.ITimingTaskService;
import com.huawei.ism.tool.framework.pubservice.entity.DevServicePkg;
import com.huawei.ism.tool.framework.pubservice.entity.SupportVersion;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Window;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeviceContext {
    private static final Logger log = LoggerFactory.getLogger(DeviceContext.class);
    public static final String INITIATOR_IB_CMD = "show ib_initiator general";
    public static final String CTRL_CMD = "show controller general";
    public static final String NEED_HANDLE_SNS = "needHandleSn";
    public static final String DEVICES_INFO = "devicesInfo";
    public static final String INITIATOR_FC_CMD = "show initiator initiator_type=FC";
    public static final String INITIATOR_ISCSI_CMD = "show initiator initiator_type=iSCSI";
    public static final String HOST_CMD = "show host general";
    private static DeviceContext instance = null;
    private static List<SupportVersion> supportVersions = Collections.synchronizedList(new ArrayList());
    private static List<DevServicePkg> devServicePkgs = Collections.synchronizedList(new ArrayList());
    private Map<String, String> keyNames = new HashMap<String, String>();
    private String defaultExportImportPath = "";
    private String defaultPackageExportImportPath = "";
    private String defaultBackUpPath = "";
    private String defaultFaildInfoExportPath = "";
    private int errorStatus = 0;
    private List<DevNode> modifyDevicesInfo = new ArrayList<DevNode>();
    private static boolean chooseDevType = false;

    public static boolean isChooseDevType() {
        return chooseDevType;
    }

    public static void setChooseDevType(boolean chooseDevType) {
        DeviceContext.chooseDevType = chooseDevType;
    }

    public String getDefaultFaildInfoExportPath() {
        return this.defaultFaildInfoExportPath;
    }

    public void setDefaultFaildInfoExportPath(String defaultFaildInfoExportPath) {
        this.defaultFaildInfoExportPath = defaultFaildInfoExportPath;
    }

    public String getDefaultBackUpPath() {
        return this.defaultBackUpPath;
    }

    public String[] getHostTypes() {
        return new String[]{"Linux", "AIX", "HP-UX", "Solaris", "VMware"};
    }

    public void setDefaultBackUpPath(String defaultBackUpPath) {
        this.defaultBackUpPath = defaultBackUpPath;
    }

    public static List<SupportVersion> getSupportVersions() {
        return supportVersions;
    }

    public static void setSupportVersions(List<SupportVersion> supportVersions) {
        DeviceContext.supportVersions = supportVersions;
    }

    public static List<DevServicePkg> getDevServicePkgs() {
        return devServicePkgs;
    }

    public static void setDevServicePkgs(List<DevServicePkg> devServicePkgs) {
        DeviceContext.devServicePkgs = devServicePkgs;
    }

    public String getDefaultPackageExportImportPath() {
        return this.defaultPackageExportImportPath;
    }

    public void setDefaultPackageExportImportPath(String defaultPackageExportImportPath) {
        this.defaultPackageExportImportPath = defaultPackageExportImportPath;
    }

    public static synchronized DeviceContext getInstance() {
        if (null == instance) {
            instance = new DeviceContext();
        }
        return instance;
    }

    public String getDefaultExportImportPath() {
        return this.defaultExportImportPath;
    }

    public void setDefaultExportImportPath(String defaultExportImportPath) {
        this.defaultExportImportPath = defaultExportImportPath;
    }

    public int getErrorStatus() {
        return this.errorStatus;
    }

    public void setErrorStatus(int errorStatus) {
        this.errorStatus = errorStatus;
    }

    public void setDefaultPathFileChooser(JFileChooser fileChooser) {
        if (!StringUtils.isNULLStr((String)this.defaultExportImportPath)) {
            File f = new File(this.defaultExportImportPath);
            File path = null;
            path = f.isDirectory() && f.exists() ? f : this.getParExistsDictionary(f);
            fileChooser.setCurrentDirectory(path);
        }
    }

    private File getParExistsDictionary(File child) {
        for (File parent = child.getParentFile(); null != parent; parent = parent.getParentFile()) {
            if (!parent.exists() || !parent.isDirectory()) continue;
            return parent;
        }
        return null;
    }

    public static boolean checkMarkedDevInTask(DeviceManagementPanel panel, String msg) {
        ITimingTaskService tService = (ITimingTaskService)PublicServiceManage.getInstance().getService(ITimingTaskService.class);
        if (null == tService) {
            return false;
        }
        List allMarketRows = panel.getDeviceTable().getMarkedRows();
        for (TableRow row : allMarketRows) {
            DevNode node;
            boolean containsTaskOfDev;
            Object obj = row.getIdentifier();
            if (!(obj instanceof DevNode) || !(containsTaskOfDev = tService.containsTaskOfDev((node = (DevNode)obj).getIp()))) continue;
            WarningDialog warningDialog = DialogUtils.showYesNoDialog((Window)panel.getParentJFrame(), (String)msg);
            if (0 == warningDialog.getValue()) {
                ITimingTaskService taskService = (ITimingTaskService)PublicServiceManage.getInstance().getService(ITimingTaskService.class);
                taskService.openTaskManageDialog();
            }
            return true;
        }
        return false;
    }

    public void loadProductSupportPkg(String path) {
        File file = new File(path + File.separator + "switch");
        if (!file.exists()) {
            return;
        }
        File[] files = file.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        for (File f : files) {
            if (!f.isDirectory()) continue;
            File sysConfigXml = new File(file, f.getName() + File.separator + "discovery" + File.separator + "sysconf.xml");
            try {
                Element sysConfigEle = this.getXmlElement(sysConfigXml);
                NodeList sysConfigNodeListName = sysConfigEle.getElementsByTagName("productname");
                NodeList sysConfigNodeListVer = sysConfigEle.getElementsByTagName("supporttypes");
                NodeList sysConfigNodeListPath = sysConfigEle.getElementsByTagName("pkgpath");
                SupportVersion ver = new SupportVersion();
                String type = this.getDevXml(sysConfigNodeListName);
                ver.setModel(type);
                ver.setVersion(this.getDevXml(sysConfigNodeListVer));
                ver.setScript(this.getDevXml(sysConfigNodeListPath));
                supportVersions.add(ver);
            }
            catch (RuntimeException e) {
                log.error("init checkitem runtime exception.", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                log.error("file not found:{}", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)sysConfigXml.getName()));
            }
            catch (Exception e) {
                ToolLoggerFactory.getLogger(DeviceContext.class).error("init checkitem error.", (Throwable)e);
            }
        }
    }

    public void analyForDev() {
        List<File> endConfFiles = this.getEndconfFiles();
        if (!this.isExistsEndconfFiles(endConfFiles)) {
            log.info("Find endconf is error, the path is {}", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)endConfFiles.toString()));
            return;
        }
        try {
            for (File endConfFile : endConfFiles) {
                if (!endConfFile.exists()) continue;
                if (log.isInfoEnabled()) {
                    log.info("init to add endconf file {}", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)endConfFile.getName()));
                }
                Element devEle = this.getXmlElement(endConfFile);
                String mutilCtr = devEle.getAttribute("mutilCtr");
                NodeList devNodeListJudge = devEle.getElementsByTagName("endingJudge");
                NodeList devNodeListCmd = devEle.getElementsByTagName("notSupportComd");
                DevServicePkg devServicePkg = new DevServicePkg();
                devServicePkg.setEndingJudge(this.getDevXmlNode(devNodeListJudge));
                devServicePkg.setNotSupportComd(this.getDevXmlNode(devNodeListCmd));
                devServicePkg.setMutilCtr(Boolean.valueOf(mutilCtr).booleanValue());
                devServicePkg.setDevType(DeviceType.ALL.toString());
                devServicePkgs.add(devServicePkg);
            }
        }
        catch (FileNotFoundException e) {
            log.error("init checkitem not found file.");
        }
        catch (Exception e) {
            log.error("init checkitem error.", (Throwable)e);
        }
    }

    private List<File> getEndconfFiles() {
        ArrayList<File> endconfFiles = new ArrayList<File>();
        String path = ApplicationContext.getInstance().getPackagesPath() + File.separator + "toolkit";
        File devXml = new File(path, "endconf.xml");
        endconfFiles.add(devXml);
        String pathParent = FilePathUtils.filterPath((String)FileUtils.getProductSuprotPkgPath());
        File devXmlParent = new File(pathParent, "endconf.xml");
        endconfFiles.add(devXmlParent);
        return endconfFiles;
    }

    private boolean isExistsEndconfFiles(List<File> endConfs) {
        for (File endConf : endConfs) {
            if (!endConf.exists()) continue;
            return true;
        }
        return false;
    }

    private Element getXmlElement(File sysConfigXml) throws FileNotFoundException {
        FileInputStream sysConfigIn = new FileInputStream(FilePathUtils.checkFile((File)sysConfigXml));
        Document sysConfigXmlDoc = XmlUtils.parseDocument((InputStream)sysConfigIn);
        Element sysConfigEle = sysConfigXmlDoc.getDocumentElement();
        StreamUtils.closeResource(null, (Closeable)sysConfigIn);
        return sysConfigEle;
    }

    private List<String> getDevXmlNode(NodeList nodeList) {
        ArrayList<String> nodeValues = new ArrayList<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n = nodeList.item(i);
            nodeValues.add(n.getTextContent());
        }
        return nodeValues;
    }

    private String getDevXml(NodeList nodeList) {
        if (null != nodeList && nodeList.getLength() > 0) {
            return nodeList.item(0).getTextContent();
        }
        return "";
    }

    public Map<String, String> getKeyNames() {
        return this.keyNames;
    }

    public void saveKeyName(String name, String path) {
        this.keyNames.put(name, path);
    }

    public List<DevNode> getModifyDevicesInfo() {
        return this.modifyDevicesInfo;
    }

    public void setModifyDevicesInfo(List<DevNode> modifyDevicesInfo) {
        this.modifyDevicesInfo = modifyDevicesInfo;
    }
}

